/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.items;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class MoneyBagContents {
    private EntityPlayer player;
    private int[] coinData = new int[]{0, 0, 0, 0, 0, 0, 0};

    public MoneyBagContents(EntityPlayer player) {
        this.player = player;
    }

    public void readNBT(NBTTagCompound compound) {
        this.coinData = compound.func_74759_k("coins");
    }

    public NBTTagCompound writeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74783_a("coins", this.coinData);
        return compound;
    }

    public void AddCurrency(CoinType coinType, byte stackSize, ItemStack theBag) {
        int n = coinType.ordinal();
        this.coinData[n] = this.coinData[n] + stackSize;
        theBag.field_77990_d.func_74782_a("contents", (NBTBase)this.writeNBT());
    }

    public void WithdrawCurrencyByVal(CoinType coinType, short amount, ItemStack theBag) {
        int amtAdded = 0;
        int n = coinType.ordinal();
        this.coinData[n] = this.coinData[n] - amtAdded;
        theBag.field_77990_d.func_74782_a("contents", (NBTBase)this.writeNBT());
    }

    public void WithdrawCurrencyByStack(CoinType coinType, byte numStacks, ItemStack theBag) {
        int amtAdded = 0;
        int n = coinType.ordinal();
        this.coinData[n] = this.coinData[n] - amtAdded;
        theBag.field_77990_d.func_74782_a("contents", (NBTBase)this.writeNBT());
    }

    public static enum CoinType {
        WOOD("WOOD", 0),
        STONE("STONE", 1),
        IRON("IRON", 2),
        GOLD("GOLD", 3),
        DIAMOND("DIAMOND", 4),
        BRONZE("BRONZE", 5),
        EMERALD("EMERALD", 6);

        private static final CoinType[] $VALUES;

        private CoinType(String var1, int var2) {
        }

        static {
            $VALUES = new CoinType[]{WOOD, STONE, IRON, GOLD, DIAMOND, BRONZE, EMERALD};
        }
    }
}

