/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import java.util.List;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import noppes.npcs.ICompatibilty;
import noppes.npcs.NBTTags;
import noppes.npcs.controllers.Line;
import noppes.npcs.controllers.Lines;
import noppes.npcs.entity.EntityNPCInterface;

public class VersionCompatibility {
    public static int ModRev = 16;

    public static void CheckNpcCompatibility(EntityNPCInterface npc, NBTTagCompound compound) {
        if (npc.npcVersion != ModRev) {
            NBTTagList var10;
            int var15;
            if (npc.npcVersion < 12) {
                VersionCompatibility.CompatabilityFix(compound, npc.advanced.writeToNBT(new NBTTagCompound()));
                VersionCompatibility.CompatabilityFix(compound, npc.ai.writeToNBT(new NBTTagCompound()));
                VersionCompatibility.CompatabilityFix(compound, npc.stats.writeToNBT(new NBTTagCompound()));
                VersionCompatibility.CompatabilityFix(compound, npc.display.writeToNBT(new NBTTagCompound()));
                VersionCompatibility.CompatabilityFix(compound, npc.inventory.writeEntityToNBT(new NBTTagCompound()));
            }
            if (npc.npcVersion < 5) {
                String bo = compound.func_74779_i("Texture");
                bo = bo.replace("/mob/customnpcs/", "customnpcs:textures/entity/");
                bo = bo.replace("/mob/", "customnpcs:textures/entity/");
                compound.func_74778_a("Texture", bo);
            }
            if (npc.npcVersion < 6 && compound.func_74781_a("NpcInteractLines") instanceof NBTTagList) {
                List var9 = NBTTags.getStringList(compound.func_150295_c("NpcInteractLines", 10));
                Lines comp = new Lines();
                for (int y = 0; y < var9.size(); ++y) {
                    Line x = new Line();
                    x.text = (String)var9.toArray()[y];
                    comp.lines.put(y, x);
                }
                compound.func_74782_a("NpcInteractLines", (NBTBase)comp.writeToNBT());
                List var14 = NBTTags.getStringList(compound.func_150295_c("NpcLines", 10));
                comp = new Lines();
                for (var15 = 0; var15 < var14.size(); ++var15) {
                    Line killedLines = new Line();
                    killedLines.text = (String)var14.toArray()[var15];
                    comp.lines.put(var15, killedLines);
                }
                compound.func_74782_a("NpcLines", (NBTBase)comp.writeToNBT());
                List var16 = NBTTags.getStringList(compound.func_150295_c("NpcAttackLines", 10));
                comp = new Lines();
                for (int var17 = 0; var17 < var16.size(); ++var17) {
                    Line i = new Line();
                    i.text = (String)var16.toArray()[var17];
                    comp.lines.put(var17, i);
                }
                compound.func_74782_a("NpcAttackLines", (NBTBase)comp.writeToNBT());
                List var18 = NBTTags.getStringList(compound.func_150295_c("NpcKilledLines", 10));
                comp = new Lines();
                for (int var19 = 0; var19 < var18.size(); ++var19) {
                    Line line = new Line();
                    line.text = (String)var18.toArray()[var19];
                    comp.lines.put(var19, line);
                }
                compound.func_74782_a("NpcKilledLines", (NBTBase)comp.writeToNBT());
            }
            if (npc.npcVersion == 12 && (var10 = compound.func_150295_c("StartPos", 3)).func_74745_c() == 3) {
                int var12 = ((NBTTagInt)var10.func_74744_a(2)).func_150287_d();
                int y = ((NBTTagInt)var10.func_74744_a(1)).func_150287_d();
                var15 = ((NBTTagInt)var10.func_74744_a(0)).func_150287_d();
                compound.func_74783_a("StartPosNew", new int[]{var15, y, var12});
            }
            if (npc.npcVersion == 13) {
                boolean var11 = compound.func_74767_n("HealthRegen");
                compound.func_74768_a("HealthRegen", var11 ? 1 : 0);
                NBTTagCompound var13 = compound.func_74775_l("TransformStats");
                var11 = var13.func_74767_n("HealthRegen");
                var13.func_74768_a("HealthRegen", var11 ? 1 : 0);
                compound.func_74782_a("TransformStats", (NBTBase)var13);
            }
            npc.npcVersion = ModRev;
        }
    }

    public static void CheckAvailabilityCompatibility(ICompatibilty compatibilty, NBTTagCompound compound) {
        if (compatibilty.getVersion() != ModRev) {
            VersionCompatibility.CompatabilityFix(compound, compatibilty.writeToNBT(new NBTTagCompound()));
            compatibilty.setVersion(ModRev);
        }
    }

    private static void CompatabilityFix(NBTTagCompound compound, NBTTagCompound check) {
        Set tags = check.func_150296_c();
        for (String name : tags) {
            NBTBase nbt = check.func_74781_a(name);
            if (!compound.func_74764_b(name)) {
                compound.func_74782_a(name, nbt);
                continue;
            }
            if (!(nbt instanceof NBTTagCompound) || !(compound.func_74781_a(name) instanceof NBTTagCompound)) continue;
            VersionCompatibility.CompatabilityFix(compound.func_74775_l(name), (NBTTagCompound)nbt);
        }
    }
}

