/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.ForgeEventFactory;
import noppes.npcs.controllers.SpawnController;
import noppes.npcs.controllers.SpawnData;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;

public class NPCSpawning {
    public static void findChunksForSpawning(WorldServer world) {
        int l1;
        int k1;
        HashMap<ChunkCoordIntPair, Boolean> eligibleChunksForSpawning = new HashMap<ChunkCoordIntPair, Boolean>();
        for (int tmp = 0; tmp < world.field_73010_i.size(); ++tmp) {
            EntityPlayer iterator = (EntityPlayer)world.field_73010_i.get(tmp);
            int chunkcoordintpair1 = MathHelper.func_76128_c((double)(iterator.field_70165_t / 16.0));
            int chunkposition = MathHelper.func_76128_c((double)(iterator.field_70161_v / 16.0));
            int j1 = 8;
            for (k1 = -j1; k1 <= j1; ++k1) {
                for (l1 = -j1; l1 <= j1; ++l1) {
                    boolean i = k1 == -j1 || k1 == j1 || l1 == -j1 || l1 == j1;
                    ChunkCoordIntPair x = new ChunkCoordIntPair(k1 + chunkcoordintpair1, l1 + chunkposition);
                    if (!i) {
                        eligibleChunksForSpawning.put(x, false);
                        continue;
                    }
                    if (eligibleChunksForSpawning.containsKey(x)) continue;
                    eligibleChunksForSpawning.put(x, true);
                }
            }
        }
        if (NPCSpawning.countNPCs((World)world) <= 5 * eligibleChunksForSpawning.size()) {
            ArrayList var17 = new ArrayList(eligibleChunksForSpawning.keySet());
            Collections.shuffle(var17);
            for (ChunkCoordIntPair var19 : var17) {
                if (((Boolean)eligibleChunksForSpawning.get(var19)).booleanValue()) continue;
                ChunkPosition var20 = NPCSpawning.getChunk((World)world, var19.field_77276_a, var19.field_77275_b);
                int var21 = var20.field_151329_a;
                k1 = var20.field_151327_b;
                l1 = var20.field_151328_c;
                for (int var22 = 0; var22 < 3; ++var22) {
                    int y;
                    int z;
                    int var23;
                    String name = world.func_72807_a((int)var23, (int)z).field_76791_y;
                    int b1 = 6;
                    var23 = var21 + (world.field_73012_v.nextInt(b1) - world.field_73012_v.nextInt(b1));
                    Block block = world.func_147439_a(var23, y = k1 + (world.field_73012_v.nextInt(1) - world.field_73012_v.nextInt(1)), z = l1 + (world.field_73012_v.nextInt(b1) - world.field_73012_v.nextInt(b1)));
                    SpawnData data = SpawnController.instance.getRandomSpawnData(name, block.func_149688_o() == Material.field_151579_a);
                    if (data == null || !NPCSpawning.canCreatureTypeSpawnAtLocation(data, (World)world, var23, y, z) || world.func_72977_a((double)var23, (double)y, (double)z, 24.0) != null) continue;
                    NPCSpawning.spawnData(data, (World)world, var23, y, z);
                }
            }
        }
    }

    public static int countNPCs(World world) {
        int count = 0;
        List list = world.field_72996_f;
        for (Entity entity : list) {
            if (!(entity instanceof EntityNPCInterface)) continue;
            ++count;
        }
        return count;
    }

    protected static ChunkPosition getChunk(World world, int x, int z) {
        Chunk chunk = world.func_72964_e(x, z);
        int k = x * 16 + world.field_73012_v.nextInt(16);
        int l = z * 16 + world.field_73012_v.nextInt(16);
        int i1 = world.field_73012_v.nextInt(chunk == null ? world.func_72940_L() : chunk.func_76625_h() + 16 - 1);
        return new ChunkPosition(k, i1, l);
    }

    public static void performWorldGenSpawning(World world, int x, int z, Random rand) {
        BiomeGenBase biome = world.func_72807_a(x + 8, z + 8);
        block0: while (rand.nextFloat() < biome.func_76741_f()) {
            SpawnData data = SpawnController.instance.getRandomSpawnData(biome.field_76791_y, true);
            if (data == null) continue;
            int size = 16;
            int j1 = x + rand.nextInt(size);
            int k1 = z + rand.nextInt(size);
            int l1 = j1;
            int i2 = k1;
            for (int k2 = 0; k2 < 4; ++k2) {
                int l2 = world.func_72825_h(j1, k1);
                if (!NPCSpawning.canCreatureTypeSpawnAtLocation(data, world, j1, l2, k1)) {
                    j1 += rand.nextInt(5) - rand.nextInt(5);
                    k1 += rand.nextInt(5) - rand.nextInt(5);
                    while (j1 < x || j1 >= x + size || k1 < z || k1 >= z + size) {
                        j1 = l1 + rand.nextInt(5) - rand.nextInt(5);
                        k1 = i2 + rand.nextInt(5) - rand.nextInt(5);
                    }
                    continue;
                }
                if (NPCSpawning.spawnData(data, world, j1, l2, k1)) continue block0;
            }
        }
    }

    private static boolean spawnData(SpawnData data, World world, int x, int y, int z) {
        EntityLiving entityliving;
        try {
            Entity canSpawn = EntityList.func_75615_a((NBTTagCompound)data.compound1, (World)world);
            if (canSpawn == null || !(canSpawn instanceof EntityLiving)) {
                return false;
            }
            entityliving = (EntityLiving)canSpawn;
            if (canSpawn instanceof EntityCustomNpc) {
                EntityCustomNpc npc = (EntityCustomNpc)canSpawn;
                npc.stats.spawnCycle = 3;
                npc.ai.returnToStart = false;
                npc.ai.startPos = new int[]{x, y, z};
            }
            canSpawn.func_70012_b((double)x + 0.5, (double)y, (double)z + 0.5, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
        }
        catch (Exception var8) {
            var8.printStackTrace();
            return false;
        }
        Event.Result canSpawn1 = ForgeEventFactory.canEntitySpawn((EntityLiving)entityliving, (World)world, (float)((float)x + 0.5f), (float)y, (float)((float)z + 0.5f));
        if (canSpawn1 != Event.Result.DENY && (canSpawn1 != Event.Result.DEFAULT || entityliving.func_70601_bi())) {
            world.func_72838_d((Entity)entityliving);
            return true;
        }
        return false;
    }

    public static boolean canCreatureTypeSpawnAtLocation(SpawnData data, World world, int x, int y, int z) {
        if (data.liquid) {
            return world.func_147439_a(x, y, z).func_149688_o().func_76224_d() && world.func_147439_a(x, y - 1, z).func_149688_o().func_76224_d() && !world.func_147439_a(x, y + 1, z).func_149721_r();
        }
        if (!World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z)) {
            return false;
        }
        Block block = world.func_147439_a(x, y - 1, z);
        boolean spawnBlock = block.canCreatureSpawn(EnumCreatureType.creature, (IBlockAccess)world, x, y - 1, z);
        return spawnBlock && !world.func_147439_a(x, y, z).func_149721_r() && !world.func_147439_a(x, y, z).func_149688_o().func_76224_d() && !world.func_147439_a(x, y + 1, z).func_149721_r();
    }
}

