/*
 * Decompiled with CFR 0.152.
 */
package foxz.command;

import foxz.commandhelper.ChMcLogger;
import foxz.commandhelper.annotations.Command;
import foxz.commandhelper.annotations.SubCommand;
import foxz.commandhelper.permissions.OpOnly;
import foxz.commandhelper.permissions.ParamCheck;
import foxz.commandhelper.permissions.PlayerOnly;
import foxz.utils.Utils;
import java.util.Iterator;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import noppes.npcs.controllers.ServerCloneController;
import noppes.npcs.entity.EntityNPCInterface;

@Command(name="clone", desc="Clone operation (server side)")
public class CmdClone
extends ChMcLogger {
    public CmdClone(Object sender) {
        super(sender);
    }

    @SubCommand(desc="Add NPC(s) to clone storage", usage="<npc> <tab> [clonedname]", permissions={OpOnly.class, PlayerOnly.class, ParamCheck.class})
    public Boolean add(String[] args) {
        NBTTagCompound compound;
        EntityNPCInterface npc;
        EntityPlayerMP player = (EntityPlayerMP)this.pcParam;
        int tab = 0;
        try {
            tab = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException var9) {
            // empty catch block
        }
        List list = Utils.getNearbeEntityFromPlayer(EntityNPCInterface.class, player, 80);
        Iterator var5 = list.iterator();
        do {
            if (!var5.hasNext()) {
                return true;
            }
            npc = (EntityNPCInterface)((Object)var5.next());
        } while (!npc.display.name.equalsIgnoreCase(args[0]));
        String name = npc.display.name;
        if (args.length > 2) {
            name = args[2];
        }
        if (!npc.func_70039_c(compound = new NBTTagCompound())) {
            return false;
        }
        ServerCloneController.Instance.addClone(compound, name, tab);
        return true;
    }

    @SubCommand(desc="List NPC from clone storage", usage="<tab>", permissions={OpOnly.class, ParamCheck.class})
    public Boolean list(String[] args) {
        this.sendmessage("--- Stored NPCs --- (server side)");
        int tab = 0;
        try {
            tab = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException var5) {
            // empty catch block
        }
        for (String name : ServerCloneController.Instance.getClones(tab)) {
            this.sendmessage(name);
        }
        this.sendmessage("------------------------------------");
        return true;
    }

    @SubCommand(desc="Remove NPC from clone storage", usage="<name> <tab>", permissions={OpOnly.class, ParamCheck.class})
    public Boolean del(String[] args) {
        String nametodel = args[0];
        int tab = 0;
        try {
            tab = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException var7) {
            // empty catch block
        }
        boolean deleted = false;
        for (String name : ServerCloneController.Instance.getClones(tab)) {
            if (!nametodel.equalsIgnoreCase(name)) continue;
            ServerCloneController.Instance.removeClone(name, tab);
            deleted = true;
            break;
        }
        if (!ServerCloneController.Instance.removeClone(nametodel, tab)) {
            this.sendmessage(String.format("Npc '%s' wasn't found", nametodel));
            return false;
        }
        return true;
    }

    @SubCommand(desc="Spawn cloned NPC", usage="<name> <tab> [[world:]x,y,z]] [newname]", permissions={OpOnly.class, ParamCheck.class})
    public boolean spawn(String[] args) {
        String name = args[0].replaceAll("%", " ");
        int tab = 0;
        try {
            tab = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException var17) {
            // empty catch block
        }
        String newname = null;
        NBTTagCompound compound = ServerCloneController.Instance.getCloneData(this.pcParam, name, tab);
        if (compound == null) {
            this.sendmessage("Unknown npc");
            return false;
        }
        World world = this.pcParam.func_130014_f_();
        double posX = this.pcParam.func_82114_b().field_71574_a;
        double posY = this.pcParam.func_82114_b().field_71572_b;
        double posZ = this.pcParam.func_82114_b().field_71573_c;
        if (args.length > 2) {
            String[] npc;
            String entity = args[2];
            if (entity.contains(":")) {
                npc = entity.split(":");
                entity = npc[1];
                world = Utils.getWorld(npc[0]);
                if (world == null) {
                    this.sendmessage(String.format("'%s' is an unknown world", npc[0]));
                    return false;
                }
            }
            if (entity.contains(",")) {
                npc = entity.split(",");
                if (npc.length != 3) {
                    this.sendmessage("Location need be x,y,z");
                    return false;
                }
                try {
                    posX = CommandBase.func_110666_a((ICommandSender)this.pcParam, (double)posX, (String)npc[0]);
                    posY = CommandBase.func_110665_a((ICommandSender)this.pcParam, (double)posY, (String)npc[1].trim(), (int)0, (int)0);
                    posZ = CommandBase.func_110666_a((ICommandSender)this.pcParam, (double)posZ, (String)npc[2]);
                }
                catch (NumberFormatException var16) {
                    this.sendmessage("Location should be in numbers");
                    return false;
                }
                if (args.length > 3) {
                    newname = args[3];
                }
            } else {
                newname = entity;
            }
        }
        if (posX == 0.0 && posY == 0.0 && posZ == 0.0) {
            this.sendmessage("Location needed");
            return false;
        }
        Entity entity1 = EntityList.func_75615_a((NBTTagCompound)compound, (World)world);
        entity1.func_70107_b(posX + 0.5, posY + 1.0, posZ + 0.5);
        if (entity1 instanceof EntityNPCInterface) {
            EntityNPCInterface npc1 = (EntityNPCInterface)entity1;
            npc1.ai.startPos = new int[]{MathHelper.func_76128_c((double)posX), MathHelper.func_76128_c((double)posY), MathHelper.func_76128_c((double)posZ)};
            if (newname != null && !newname.isEmpty()) {
                npc1.display.name = newname.replaceAll("%", " ");
            }
        }
        world.func_72838_d(entity1);
        return true;
    }
}

