/*
 * Decompiled with CFR 0.152.
 */
package tmechworks.blocks.logic;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import mantle.blocks.abstracts.InventoryLogic;
import mantle.blocks.iface.IActiveLogic;
import mantle.blocks.iface.IFacingLogic;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Facing;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import tmechworks.inventory.AdvancedDrawbridgeContainer;
import tmechworks.lib.TMechworksRegistry;
import tmechworks.lib.blocks.IDrawbridgeLogicBase;
import tmechworks.lib.player.FakePlayerLogic;

public class AdvancedDrawbridgeLogic
extends InventoryLogic
implements IFacingLogic,
IActiveLogic,
IDrawbridgeLogicBase {
    boolean active;
    boolean working;
    int ticks;
    public int selSlot = 0;
    byte extension;
    byte direction;
    byte placementDirection = (byte)4;
    FakePlayerLogic fakePlayer;
    ItemStack[] bufferStacks = new ItemStack[this.func_70302_i_()];
    public InvCamo camoInventory = new InvCamo();

    public AdvancedDrawbridgeLogic() {
        super(16);
    }

    public void func_145834_a(World par1World) {
        this.field_145850_b = par1World;
    }

    private void initFakePlayer() {
        if (this.fakePlayer == null && !this.func_145837_r()) {
            this.fakePlayer = new FakePlayerLogic(new GameProfile(null, "Player.Drawbridge"), (TileEntity)this);
        }
    }

    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean flag) {
        this.active = flag;
        this.working = true;
    }

    public byte getRenderDirection() {
        return this.direction;
    }

    public ForgeDirection getForgeDirection() {
        return ForgeDirection.VALID_DIRECTIONS[this.direction];
    }

    public void setDirection(int side) {
    }

    public boolean canDropInventorySlot(int slot) {
        return false;
    }

    public void setDirection(float yaw, float pitch, EntityLivingBase player) {
        if (pitch > 45.0f) {
            this.direction = 1;
        } else if (pitch < -45.0f) {
            this.direction = 0;
        } else {
            int facing = MathHelper.func_76128_c((double)((double)(yaw / 360.0f) + 0.5)) & 3;
            switch (facing) {
                case 0: {
                    this.direction = (byte)2;
                    break;
                }
                case 1: {
                    this.direction = (byte)5;
                    break;
                }
                case 2: {
                    this.direction = (byte)3;
                    break;
                }
                case 3: {
                    this.direction = (byte)4;
                }
            }
        }
    }

    public void setPlacementDirection(byte keycode) {
        if (!this.field_145850_b.field_72995_K) {
            this.initFakePlayer();
            if (keycode == 4) {
                this.fakePlayer.field_70177_z = 0.0f;
                this.fakePlayer.field_70125_A = 0.0f;
            } else if (this.direction == 0 || this.direction == 1) {
                switch (keycode) {
                    case 0: {
                        this.fakePlayer.field_70177_z = 0.0f;
                        break;
                    }
                    case 1: {
                        this.fakePlayer.field_70177_z = 90.0f;
                        break;
                    }
                    case 2: {
                        this.fakePlayer.field_70177_z = 180.0f;
                        break;
                    }
                    case 3: {
                        this.fakePlayer.field_70177_z = 270.0f;
                    }
                }
                this.fakePlayer.field_70125_A = this.direction == 0 ? -90.0f : 90.0f;
            } else if (keycode == 0) {
                this.fakePlayer.field_70177_z = this.mapDirection() * 90;
                this.fakePlayer.field_70125_A = keycode == 0 ? 90.0f : -90.0f;
            } else if (keycode == 2) {
                int face = this.mapDirection() + 2;
                if (face > 3) {
                    face -= 4;
                }
                this.fakePlayer.field_70177_z = face * 90;
                this.fakePlayer.field_70125_A = keycode == 0 ? 90.0f : -90.0f;
            } else {
                this.fakePlayer.field_70125_A = 0.0f;
                int facing = this.mapDirection();
                facing = keycode == 1 ? ++facing : --facing;
                if (facing >= 4) {
                    facing = 0;
                }
                if (facing < 0) {
                    facing = 3;
                }
                this.fakePlayer.field_70177_z = facing * 90;
            }
        }
        this.placementDirection = keycode;
    }

    int mapDirection() {
        if (this.direction == 2) {
            return 0;
        }
        if (this.direction == 5) {
            return 1;
        }
        if (this.direction == 3) {
            return 2;
        }
        return 3;
    }

    @Override
    public byte getPlacementDirection() {
        return this.placementDirection;
    }

    public ItemStack func_70301_a(int slot) {
        return slot < this.inventory.length ? this.inventory[slot] : null;
    }

    public ItemStack getStackInBufferSlot(int slot) {
        return slot < this.bufferStacks.length ? this.bufferStacks[slot] : null;
    }

    public void setBufferSlotContents(int slot, ItemStack itemstack) {
        if (slot >= this.bufferStacks.length) {
            return;
        }
        this.bufferStacks[slot] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public Container getGuiContainer(InventoryPlayer inventoryplayer, World world, int x, int y, int z) {
        return new AdvancedDrawbridgeContainer(inventoryplayer, this);
    }

    protected String getDefaultName() {
        return "tinker.drawbridge";
    }

    public ItemStack func_70298_a(int slot, int quantity) {
        ItemStack stack = super.func_70298_a(slot, quantity);
        if (slot == 1) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return stack;
    }

    public void func_145845_h() {
        if (this.working && !this.func_145837_r()) {
            ++this.ticks;
            if (this.ticks == 5) {
                this.ticks = 0;
                if (this.active) {
                    if (this.func_70301_a(this.extension) != null && this.func_70301_a((int)this.extension).field_77994_a > 0 && this.extension < 15) {
                        this.extension = (byte)(this.extension + 1);
                        int xPos = this.field_145851_c;
                        int yPos = this.field_145848_d;
                        int zPos = this.field_145849_e;
                        switch (this.direction) {
                            case 0: {
                                yPos -= this.extension;
                                break;
                            }
                            case 1: {
                                yPos += this.extension;
                                break;
                            }
                            case 2: {
                                zPos -= this.extension;
                                break;
                            }
                            case 3: {
                                zPos += this.extension;
                                break;
                            }
                            case 4: {
                                xPos -= this.extension;
                                break;
                            }
                            case 5: {
                                xPos += this.extension;
                            }
                        }
                        Block block = this.field_145850_b.func_147439_a(xPos, yPos, zPos);
                        if (block == null || block.isAir((IBlockAccess)this.field_145850_b, xPos, yPos, zPos) || block.func_149742_c(this.field_145850_b, xPos, yPos, zPos)) {
                            List list;
                            AxisAlignedBB axisalignedbb;
                            Item blockToItem;
                            this.initFakePlayer();
                            Item item = blockToItem = this.getStackInBufferSlot(this.extension - 1) != null && this.getStackInBufferSlot(this.extension - 1).func_77973_b() != null ? (Item)TMechworksRegistry.blockToItemMapping.get((Object)Block.func_149634_a((Item)this.getStackInBufferSlot(this.extension - 1).func_77973_b())) : Items.field_151055_y;
                            if (blockToItem == Item.func_150898_a((Block)Blocks.field_150350_a)) {
                                if (this.func_70301_a(this.extension - 1) == null || Block.func_149634_a((Item)this.func_70301_a(this.extension - 1).func_77973_b()) == null) {
                                    return;
                                }
                                ItemStack placeStack = this.getStackInBufferSlot(this.extension - 1);
                                if (placeStack != null) {
                                    Block placeBlock = Block.func_149634_a((Item)placeStack.func_77973_b());
                                    this.placeBlockAt(this.func_70301_a(this.extension - 1), (EntityPlayer)this.fakePlayer, this.field_145850_b, xPos, yPos, zPos, this.direction, 0.0f, 0.0f, 0.0f, this.func_70301_a(this.extension - 1).func_77960_j(), placeBlock);
                                }
                            } else {
                                Block placeBlock = Block.func_149634_a((Item)blockToItem);
                                this.placeBlockAt(this.func_70301_a(this.extension - 1), (EntityPlayer)this.fakePlayer, this.field_145850_b, xPos, yPos, zPos, this.direction, 0.0f, 0.0f, 0.0f, this.func_70301_a(this.extension - 1).func_77960_j(), placeBlock);
                            }
                            this.field_145850_b.func_72908_a((double)xPos + 0.5, (double)yPos + 0.5, (double)zPos + 0.5, "tile.piston.out", 0.25f, this.field_145850_b.field_73012_v.nextFloat() * 0.25f + 0.6f);
                            ArrayList pushedObjects = new ArrayList();
                            Block axis = this.field_145850_b.func_147439_a(xPos, yPos, zPos);
                            AxisAlignedBB axisAlignedBB = axisalignedbb = axis != null ? axis.func_149668_a(this.field_145850_b, xPos, yPos, zPos) : null;
                            if (axisalignedbb != null && !(list = this.field_145850_b.func_72839_b((Entity)null, axisalignedbb)).isEmpty()) {
                                pushedObjects.addAll(list);
                                for (Entity entity : pushedObjects) {
                                    entity.func_70091_d((double)Facing.field_71586_b[this.direction], (double)Facing.field_71587_c[this.direction], (double)Facing.field_71585_d[this.direction]);
                                }
                                pushedObjects.clear();
                            }
                            this.func_70298_a(this.extension - 1, 1);
                        } else {
                            this.extension = (byte)(this.extension - 1);
                            this.working = false;
                        }
                    } else {
                        this.working = false;
                    }
                } else if ((this.func_70301_a(this.extension) == null || this.func_70301_a((int)this.extension).field_77994_a < this.func_70301_a(this.extension).func_77976_d()) && this.extension > 0) {
                    int xPos = this.field_145851_c;
                    int yPos = this.field_145848_d;
                    int zPos = this.field_145849_e;
                    switch (this.direction) {
                        case 0: {
                            yPos -= this.extension;
                            break;
                        }
                        case 1: {
                            yPos += this.extension;
                            break;
                        }
                        case 2: {
                            zPos -= this.extension;
                            break;
                        }
                        case 3: {
                            zPos += this.extension;
                            break;
                        }
                        case 4: {
                            xPos -= this.extension;
                            break;
                        }
                        case 5: {
                            xPos += this.extension;
                        }
                    }
                    Block block = this.field_145850_b.func_147439_a(xPos, yPos, zPos);
                    if (block != null) {
                        int meta = this.field_145850_b.func_72805_g(xPos, yPos, zPos);
                        if (this.getStackInBufferSlot(this.extension - 1) != null && this.validBlock(this.extension - 1, block) && this.validMetadata(this.extension - 1, block, meta) && this.validDrawbridge(xPos, yPos, zPos)) {
                            this.field_145850_b.func_72908_a((double)xPos + 0.5, (double)yPos + 0.5, (double)zPos + 0.5, "tile.piston.in", 0.25f, this.field_145850_b.field_73012_v.nextFloat() * 0.15f + 0.6f);
                            if (this.field_145850_b.func_147449_b(xPos, yPos, zPos, Blocks.field_150350_a)) {
                                if (this.func_70301_a(this.extension - 1) == null) {
                                    this.func_70299_a(this.extension - 1, this.getStackInBufferSlot(this.extension - 1).func_77946_l());
                                } else {
                                    ++this.func_70301_a((int)(this.extension - 1)).field_77994_a;
                                }
                            }
                        } else {
                            this.working = false;
                        }
                    }
                    this.extension = (byte)(this.extension - 1);
                } else {
                    this.working = false;
                }
            }
        }
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata, Block block) {
        if (!world.func_147465_d(x, y, z, block, metadata, 3)) {
            return false;
        }
        if (world.func_147439_a(x, y, z) == block) {
            block.func_149689_a(world, x, y, z, (EntityLivingBase)player, stack);
            block.func_149714_e(world, x, y, z, metadata);
        }
        return true;
    }

    boolean validDrawbridge(int x, int y, int z) {
        TileEntity te = this.field_145850_b.func_147438_o(x, y, z);
        return !(te instanceof IDrawbridgeLogicBase) || !((IDrawbridgeLogicBase)te).hasExtended();
    }

    boolean validBlock(int slot, Block block) {
        Block type = TMechworksRegistry.interchangableBlockMapping.get(new ItemStack(block).func_77973_b());
        if (type != Blocks.field_150350_a && type == Block.func_149634_a((Item)this.getStackInBufferSlot(slot).func_77973_b())) {
            return true;
        }
        Item blockToItem = (Item)TMechworksRegistry.blockToItemMapping.get((Object)new ItemStack(block).func_77973_b());
        if (blockToItem != Item.func_150898_a((Block)Blocks.field_150350_a) && blockToItem == this.getStackInBufferSlot(slot).func_77973_b()) {
            return true;
        }
        return new ItemStack(block).func_77973_b() == this.getStackInBufferSlot(slot).func_77973_b();
    }

    boolean validMetadata(int slot, Block block, int metadata) {
        return true;
    }

    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        this.active = tags.func_74767_n("Active");
        this.working = tags.func_74767_n("Working");
        this.extension = tags.func_74771_c("Extension");
        NBTTagCompound camoTag = (NBTTagCompound)tags.func_74781_a("Camo");
        if (camoTag != null) {
            this.camoInventory.func_70299_a(0, ItemStack.func_77949_a((NBTTagCompound)camoTag));
        }
        this.readBufferFromNBT(tags);
        this.readCustomNBT(tags);
    }

    public void func_145841_b(NBTTagCompound tags) {
        super.func_145841_b(tags);
        tags.func_74757_a("Active", this.active);
        tags.func_74757_a("Working", this.working);
        tags.func_74774_a("Extension", this.extension);
        if (this.camoInventory.func_70301_a(0) != null) {
            NBTTagCompound camoTag = new NBTTagCompound();
            this.camoInventory.func_70301_a(0).func_77955_b(camoTag);
            tags.func_74782_a("Camo", (NBTBase)camoTag);
        }
        this.writeBufferToNBT(tags);
        this.writeCustomNBT(tags);
    }

    public void readBufferFromNBT(NBTTagCompound tags) {
        NBTTagList nbttaglist = tags.func_150295_c("Buffer", 10);
        this.bufferStacks = new ItemStack[this.func_70302_i_()];
        for (int iter = 0; iter < nbttaglist.func_74745_c(); ++iter) {
            NBTTagCompound tagList = nbttaglist.func_150305_b(iter);
            byte slotID = tagList.func_74771_c("Slot");
            if (slotID < 0 || slotID >= this.bufferStacks.length) continue;
            this.setBufferSlotContents(slotID, ItemStack.func_77949_a((NBTTagCompound)tagList));
        }
    }

    public void writeBufferToNBT(NBTTagCompound tags) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int iter = 0; iter < this.bufferStacks.length; ++iter) {
            if (this.getStackInBufferSlot(iter) == null) continue;
            NBTTagCompound tagList = new NBTTagCompound();
            tagList.func_74774_a("Slot", (byte)iter);
            this.getStackInBufferSlot(iter).func_77955_b(tagList);
            nbttaglist.func_74742_a((NBTBase)tagList);
        }
        tags.func_74782_a("Buffer", (NBTBase)nbttaglist);
    }

    public void readCustomNBT(NBTTagCompound tags) {
        this.direction = tags.func_74771_c("Direction");
        this.placementDirection = tags.func_74771_c("Placement");
    }

    public void writeCustomNBT(NBTTagCompound tags) {
        tags.func_74774_a("Direction", this.direction);
        tags.func_74774_a("Placement", this.placementDirection);
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
        this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public boolean hasExtended() {
        return this.extension != 0;
    }

    public void func_70296_d() {
        super.func_70296_d();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) == null) continue;
            this.setBufferSlotContents(i, this.func_70301_a(i).func_77946_l());
            this.getStackInBufferSlot((int)i).field_77994_a = 1;
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int func_70297_j_() {
        return 1;
    }

    public String func_145825_b() {
        return this.getDefaultName();
    }

    public boolean func_145818_k_() {
        return true;
    }

    public void func_70305_f() {
    }

    public void func_70295_k_() {
    }

    public class InvCamo
    extends InventoryBasic {
        private InvCamo() {
            super("camoSlot", false, 1);
        }

        public ItemStack getCamoStack() {
            return this.func_70301_a(0);
        }

        public void func_70299_a(int slot, ItemStack content) {
            super.func_70299_a(slot, content);
            if (slot == 0 && AdvancedDrawbridgeLogic.this.field_145850_b != null) {
                AdvancedDrawbridgeLogic.this.field_145850_b.func_147471_g(AdvancedDrawbridgeLogic.this.field_145851_c, AdvancedDrawbridgeLogic.this.field_145848_d, AdvancedDrawbridgeLogic.this.field_145849_e);
            }
        }

        public void func_70296_d() {
            super.func_70296_d();
            if (AdvancedDrawbridgeLogic.this.field_145850_b != null) {
                AdvancedDrawbridgeLogic.this.field_145850_b.func_147471_g(AdvancedDrawbridgeLogic.this.field_145851_c, AdvancedDrawbridgeLogic.this.field_145848_d, AdvancedDrawbridgeLogic.this.field_145849_e);
            }
        }

        public int func_70297_j_() {
            return 1;
        }
    }
}

