/*
 * Decompiled with CFR 0.152.
 */
package ckathode.archimedes.chunk;

import ckathode.archimedes.entity.EntityShip;
import ckathode.archimedes.entity.IShipTileEntity;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.common.util.ForgeDirection;

public class MobileChunk
implements IBlockAccess {
    public static final int CHUNK_SIZE = 16;
    public static final int CHUNK_SIZE_EXP = 4;
    public static final int CHUNK_MEMORY_USING = 24576;
    protected final World worldObj;
    protected final EntityShip entityShip;
    private Map<ChunkPosition, ExtendedBlockStorage> blockStorageMap;
    public Map<ChunkPosition, TileEntity> chunkTileEntityMap;
    private boolean boundsInit;
    private int minX;
    private int minY;
    private int minZ;
    private int maxX;
    private int maxY;
    private int maxZ;
    private int blockCount;
    public boolean isChunkLoaded;
    public boolean isModified;
    private BiomeGenBase creationSpotBiome;

    public MobileChunk(World world, EntityShip entityship) {
        this.worldObj = world;
        this.entityShip = entityship;
        this.blockStorageMap = new HashMap<ChunkPosition, ExtendedBlockStorage>(1);
        this.chunkTileEntityMap = new HashMap<ChunkPosition, TileEntity>(2);
        this.isChunkLoaded = false;
        this.isModified = false;
        this.boundsInit = false;
        this.maxZ = -1;
        this.maxY = -1;
        this.maxX = -1;
        this.minZ = -1;
        this.minY = -1;
        this.minX = -1;
        this.blockCount = 0;
        this.creationSpotBiome = BiomeGenBase.field_76771_b;
    }

    public ExtendedBlockStorage getBlockStorage(int x, int y, int z) {
        ChunkPosition pos = new ChunkPosition(x >> 4, y >> 4, z >> 4);
        return this.blockStorageMap.get(pos);
    }

    public ExtendedBlockStorage getBlockStorageOrCreate(int x, int y, int z) {
        ChunkPosition pos = new ChunkPosition(x >> 4, y >> 4, z >> 4);
        ExtendedBlockStorage storage = this.blockStorageMap.get(pos);
        if (storage != null) {
            return storage;
        }
        storage = new ExtendedBlockStorage(pos.field_151327_b, false);
        this.blockStorageMap.put(pos, storage);
        return storage;
    }

    public int getBlockCount() {
        return this.blockCount;
    }

    public float getCenterX() {
        return (float)(this.minX + this.maxX) / 2.0f;
    }

    public float getCenterY() {
        return (float)(this.minY + this.maxY) / 2.0f;
    }

    public float getCenterZ() {
        return (float)(this.minZ + this.maxZ) / 2.0f;
    }

    public int minX() {
        return this.minX;
    }

    public int maxX() {
        return this.maxX;
    }

    public int minY() {
        return this.minY;
    }

    public int maxY() {
        return this.maxY;
    }

    public int minZ() {
        return this.minZ;
    }

    public int maxZ() {
        return this.maxZ;
    }

    public void setCreationSpotBiomeGen(BiomeGenBase biomegenbase) {
        this.creationSpotBiome = biomegenbase;
    }

    public Block func_147439_a(int x, int y, int z) {
        ExtendedBlockStorage storage = this.getBlockStorage(x, y, z);
        if (storage == null) {
            return Blocks.field_150350_a;
        }
        return storage.func_150819_a(x & 0xF, y & 0xF, z & 0xF);
    }

    public int func_72805_g(int x, int y, int z) {
        ExtendedBlockStorage storage = this.getBlockStorage(x, y, z);
        if (storage == null) {
            return 0;
        }
        return storage.func_76665_b(x & 0xF, y & 0xF, z & 0xF);
    }

    public boolean setBlockIDWithMetadata(int x, int y, int z, Block block, int meta) {
        if (block == null) {
            return false;
        }
        ExtendedBlockStorage storage = this.getBlockStorageOrCreate(x, y, z);
        int i = x & 0xF;
        int j = y & 0xF;
        int k = z & 0xF;
        Block currentblock = storage.func_150819_a(i, j, k);
        int currentmeta = storage.func_76665_b(i, j, k);
        if (currentblock == block && currentmeta == meta) {
            return false;
        }
        storage.func_150818_a(i, j, k, block);
        storage.func_76654_b(i, j, k, meta);
        if (this.boundsInit) {
            this.minX = Math.min(this.minX, x);
            this.minY = Math.min(this.minY, y);
            this.minZ = Math.min(this.minZ, z);
            this.maxX = Math.max(this.maxX, x + 1);
            this.maxY = Math.max(this.maxY, y + 1);
            this.maxZ = Math.max(this.maxZ, z + 1);
        } else {
            this.boundsInit = true;
            this.minX = x;
            this.minY = y;
            this.minZ = z;
            this.maxX = x + 1;
            this.maxY = y + 1;
            this.maxZ = z + 1;
        }
        ++this.blockCount;
        this.setChunkModified();
        if (block.hasTileEntity(meta)) {
            TileEntity tileentity = this.func_147438_o(x, y, z);
            if (tileentity == null) {
                tileentity = block.createTileEntity(this.worldObj, meta);
                this.setTileEntity(x, y, z, tileentity);
            }
            if (tileentity != null) {
                tileentity.func_145836_u();
                tileentity.field_145854_h = block;
                tileentity.field_145847_g = meta;
            }
        }
        return true;
    }

    public boolean setBlockMetadata(int x, int y, int z, int meta) {
        TileEntity tileentity;
        ExtendedBlockStorage storage = this.getBlockStorage(x, y, z);
        if (storage == null) {
            return false;
        }
        int currentmeta = storage.func_76665_b(x, y & 0xF, z);
        if (currentmeta == meta) {
            return false;
        }
        this.setChunkModified();
        storage.func_76654_b(x & 0xF, y & 0xF, z & 0xF, meta);
        Block block = storage.func_150819_a(x & 0xF, y & 0xF, z & 0xF);
        if (block != null && block.hasTileEntity(meta) && (tileentity = this.func_147438_o(x, y, z)) != null) {
            tileentity.func_145836_u();
            tileentity.field_145847_g = meta;
        }
        return true;
    }

    public boolean setBlockAsFilledAir(int x, int y, int z) {
        ExtendedBlockStorage storage = this.getBlockStorage(x, y, z);
        if (storage == null) {
            return true;
        }
        Block block = storage.func_150819_a(x & 0xF, y & 0xF, z & 0xF);
        int meta = storage.func_76665_b(x & 0xF, y & 0xF, z & 0xF);
        if (block == Blocks.field_150350_a && meta == 1) {
            return true;
        }
        if (block == null || block.isAir((IBlockAccess)this.worldObj, x, y, z)) {
            storage.func_150818_a(x & 0xF, y & 0xF, z & 0xF, Blocks.field_150350_a);
            storage.func_76654_b(x & 0xF, y & 0xF, z & 0xF, 1);
            this.onSetBlockAsFilledAir(x, y, z);
            return true;
        }
        return false;
    }

    protected void onSetBlockAsFilledAir(int x, int y, int z) {
    }

    public TileEntity func_147438_o(int x, int y, int z) {
        ChunkPosition chunkposition = new ChunkPosition(x, y, z);
        TileEntity tileentity = this.chunkTileEntityMap.get(chunkposition);
        if (tileentity != null && tileentity.func_145837_r()) {
            this.chunkTileEntityMap.remove(chunkposition);
            tileentity = null;
        }
        if (tileentity == null) {
            Block block = this.func_147439_a(x, y, z);
            int meta = this.func_72805_g(x, y, z);
            if (block == null || !block.hasTileEntity(meta)) {
                return null;
            }
            tileentity = block.createTileEntity(this.worldObj, meta);
            this.setTileEntity(x, y, z, tileentity);
            tileentity = this.chunkTileEntityMap.get(chunkposition);
        }
        return tileentity;
    }

    public void setTileEntity(int x, int y, int z, TileEntity tileentity) {
        if (tileentity == null || tileentity.func_145837_r()) {
            return;
        }
        this.setChunkBlockTileEntity(x, y, z, tileentity);
    }

    private void setChunkBlockTileEntity(int x, int y, int z, TileEntity tileentity) {
        ChunkPosition chunkposition = new ChunkPosition(x, y, z);
        tileentity.func_145834_a(this.worldObj);
        int ox = tileentity.field_145851_c;
        int oy = tileentity.field_145848_d;
        int oz = tileentity.field_145849_e;
        tileentity.field_145851_c = x;
        tileentity.field_145848_d = y;
        tileentity.field_145849_e = z;
        Block block = this.func_147439_a(x, y, z);
        if (block != null && block.hasTileEntity(this.func_72805_g(x, y, z))) {
            if (this.chunkTileEntityMap.containsKey(chunkposition)) {
                this.chunkTileEntityMap.get(chunkposition).func_145843_s();
            }
            tileentity.field_145847_g = this.func_72805_g(x, y, z);
            tileentity.func_145829_t();
            this.chunkTileEntityMap.put(chunkposition, tileentity);
            if (tileentity instanceof IShipTileEntity) {
                ((IShipTileEntity)tileentity).setParentShip(this.entityShip, ox, oy, oz);
            }
            if (this.isChunkLoaded) {
                this.worldObj.addTileEntity(tileentity);
            }
        }
    }

    public void addTileEntity(TileEntity tileentity) {
        this.setChunkBlockTileEntity(tileentity.field_145851_c, tileentity.field_145848_d, tileentity.field_145849_e, tileentity);
    }

    public void removeChunkBlockTileEntity(int x, int y, int z) {
        TileEntity tileentity;
        ChunkPosition chunkposition = new ChunkPosition(x, y, z);
        if (this.isChunkLoaded && (tileentity = this.chunkTileEntityMap.remove(chunkposition)) != null) {
            if (tileentity instanceof IShipTileEntity) {
                ((IShipTileEntity)tileentity).setParentShip(null, x, y, z);
            }
            tileentity.func_145843_s();
        }
    }

    public void onChunkLoad() {
        this.isChunkLoaded = true;
        this.worldObj.func_147448_a(this.chunkTileEntityMap.values());
    }

    public void onChunkUnload() {
        this.isChunkLoaded = false;
    }

    public void setChunkModified() {
        this.isModified = true;
    }

    public int func_72802_i(int i, int j, int k, int l) {
        int lv = EnumSkyBlock.Sky.field_77198_c;
        return lv << 20 | l << 4;
    }

    public boolean func_147437_c(int x, int y, int z) {
        Block block = this.func_147439_a(x, y, z);
        return block == null || block.isAir((IBlockAccess)this.worldObj, x, y, z);
    }

    public boolean isBlockTakingWaterVolume(int x, int y, int z) {
        Block block = this.func_147439_a(x, y, z);
        return block != null && !block.isAir((IBlockAccess)this.worldObj, x, y, z) || this.func_72805_g(x, y, z) != 1;
    }

    public BiomeGenBase func_72807_a(int i, int j) {
        return this.creationSpotBiome;
    }

    public int func_72800_K() {
        return 16;
    }

    public boolean func_72806_N() {
        return false;
    }

    public boolean isSideSolid(int x, int y, int z, ForgeDirection side, boolean defaultvalue) {
        if (x < -30000000 || z < -30000000 || x >= 30000000 || z >= 30000000) {
            return defaultvalue;
        }
        Block block = this.func_147439_a(x, y, z);
        return block.isSideSolid((IBlockAccess)this.worldObj, x, y, z, side);
    }

    public int func_72879_k(int i, int j, int k, int l) {
        return 0;
    }

    public final int getMemoryUsage() {
        return 2 + this.blockCount * 9;
    }
}

