/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;
import squeek.spiceoflife.ModConfig;
import squeek.spiceoflife.foodtracker.FoodEaten;
import squeek.spiceoflife.foodtracker.FoodHistory;
import squeek.spiceoflife.gui.widget.WidgetButtonNextPage;
import squeek.spiceoflife.gui.widget.WidgetButtonSortDirection;
import squeek.spiceoflife.gui.widget.WidgetFoodEaten;

@SideOnly(value=Side.CLIENT)
public class GuiScreenFoodJournal
extends GuiContainer {
    private static final ResourceLocation bookGuiTextures = new ResourceLocation("textures/gui/book.png");
    private int bookImageWidth = 192;
    private int bookImageHeight = 192;
    protected List<WidgetFoodEaten> foodEatenWidgets = new ArrayList<WidgetFoodEaten>();
    protected int pageNum = 0;
    protected final int numPerPage = 5;
    protected int numPages;
    public ItemStack hoveredStack = null;
    protected GuiButton buttonNextPage;
    protected GuiButton buttonPrevPage;
    protected WidgetButtonSortDirection buttonSortDirection;

    public GuiScreenFoodJournal() {
        super((Container)new DummyContainer());
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.buttonPrevPage = new WidgetButtonNextPage(1, (this.field_146294_l - this.bookImageWidth) / 2 + 38, 156, false);
        this.field_146292_n.add(this.buttonPrevPage);
        this.buttonNextPage = new WidgetButtonNextPage(2, (this.field_146294_l - this.bookImageWidth) / 2 + 120, 156, true);
        this.field_146292_n.add(this.buttonNextPage);
        this.buttonSortDirection = new WidgetButtonSortDirection(3, this.field_146294_l / 2 - 55, 18, false);
        this.field_146292_n.add(this.buttonSortDirection);
        FoodHistory foodHistory = FoodHistory.get((EntityPlayer)this.field_146297_k.field_71439_g);
        if (!ModConfig.CLEAR_HISTORY_ON_FOOD_EATEN_THRESHOLD || foodHistory.totalFoodsEatenAllTime >= ModConfig.FOOD_EATEN_THRESHOLD) {
            for (FoodEaten foodEaten : foodHistory.getHistory()) {
                this.foodEatenWidgets.add(new WidgetFoodEaten(foodEaten));
            }
        }
        this.numPages = (int)Math.max(1.0, Math.ceil((float)this.foodEatenWidgets.size() / 5.0f));
        this.updateButtons();
    }

    private void updateButtons() {
        this.buttonNextPage.field_146125_m = this.pageNum < this.numPages - 1;
        this.buttonPrevPage.field_146125_m = this.pageNum > 0;
    }

    public void func_73863_a(int par1, int par2, float par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(bookGuiTextures);
        int x = (this.field_146294_l - this.bookImageWidth) / 2;
        int y = 2;
        this.func_73729_b(x, y, 0, 0, this.bookImageWidth, this.bookImageHeight);
        String pageIndicator = I18n.func_135052_a((String)"book.pageIndicator", (Object[])new Object[]{this.pageNum + 1, this.numPages});
        this.field_146289_q.func_78276_b(pageIndicator, x + this.bookImageWidth - this.field_146289_q.func_78256_a(pageIndicator) - 44, y + 16, 0);
        String numFoodsEatenAllTime = Integer.toString(FoodHistory.get((EntityPlayer)this.field_146297_k.field_71439_g).totalFoodsEatenAllTime);
        int allTimeW = this.field_146289_q.func_78256_a(numFoodsEatenAllTime);
        int allTimeX = this.field_146294_l / 2 - allTimeW / 2 - 5;
        int allTimeY = y + 158;
        this.field_146289_q.func_78276_b(numFoodsEatenAllTime, allTimeX, allTimeY, 0xA0A0A0);
        GL11.glDisable((int)2896);
        for (Object objButton : this.field_146292_n) {
            ((GuiButton)objButton).func_146112_a(this.field_146297_k, par1, par2);
        }
        if (!ModConfig.CLEAR_HISTORY_ON_FOOD_EATEN_THRESHOLD || FoodHistory.get((EntityPlayer)this.field_146297_k.field_71439_g).totalFoodsEatenAllTime >= ModConfig.FOOD_EATEN_THRESHOLD) {
            if (this.foodEatenWidgets.size() > 0) {
                int localY;
                int localX;
                WidgetFoodEaten foodEatenWidget;
                int foodEatenIndex;
                GL11.glPushMatrix();
                int startIndex = Math.max(0, this.pageNum * 5);
                int endIndex = startIndex + 5;
                for (foodEatenIndex = startIndex; foodEatenIndex < this.foodEatenWidgets.size() && foodEatenIndex < endIndex; ++foodEatenIndex) {
                    foodEatenWidget = this.foodEatenWidgets.get(foodEatenIndex);
                    localX = x + 36;
                    localY = y + 32 + (int)((float)((foodEatenIndex - startIndex) * this.field_146289_q.field_78288_b) * 2.5f);
                    foodEatenWidget.draw(localX, localY);
                    if (foodEatenWidget.foodEaten.itemStack == null) continue;
                    this.drawItemStack(foodEatenWidget.foodEaten.itemStack, localX, localY);
                }
                GL11.glPopMatrix();
                this.hoveredStack = null;
                for (foodEatenIndex = startIndex; foodEatenIndex < this.foodEatenWidgets.size() && foodEatenIndex < endIndex; ++foodEatenIndex) {
                    foodEatenWidget = this.foodEatenWidgets.get(foodEatenIndex);
                    localX = x + 36;
                    localY = y + 32 + (int)((float)((foodEatenIndex - startIndex) * this.field_146289_q.field_78288_b) * 2.5f);
                    if (par1 < localX || par1 >= localX + 16 || par2 < localY || par2 >= localY + 16) continue;
                    this.hoveredStack = foodEatenWidget.foodEaten.itemStack;
                    if (this.hoveredStack == null) continue;
                    this.func_146285_a(this.hoveredStack, par1, par2);
                }
            } else {
                this.field_146289_q.func_78279_b(StatCollector.func_74838_a((String)"spiceoflife.gui.no.recent.food.eaten"), x + 36, y + 16 + 16, 116, 0x404040);
            }
        } else {
            this.field_146289_q.func_78279_b(StatCollector.func_74838_a((String)"spiceoflife.gui.no.food.history.yet"), x + 36, y + 16 + 16, 116, 0x404040);
        }
        if (par1 >= allTimeX && par2 >= allTimeY && par1 < allTimeX + allTimeW && par2 < allTimeY + this.field_146289_q.field_78288_b) {
            this.drawHoveringText(Arrays.asList(StatCollector.func_74838_a((String)"spiceoflife.gui.alltime.food.eaten")), par1, par2, this.field_146289_q);
        }
        GL11.glDisable((int)2896);
    }

    protected void drawItemStack(ItemStack par1ItemStack, int par2, int par3) {
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)32.0f);
        this.field_73735_i = 200.0f;
        GuiScreenFoodJournal.field_146296_j.field_77023_b = 200.0f;
        FontRenderer font = null;
        if (par1ItemStack != null) {
            font = par1ItemStack.func_77973_b().getFontRenderer(par1ItemStack);
        }
        if (font == null) {
            font = this.field_146289_q;
        }
        field_146296_j.func_82406_b(font, this.field_146297_k.func_110434_K(), par1ItemStack, par2, par3);
        this.field_73735_i = 0.0f;
        GuiScreenFoodJournal.field_146296_j.field_77023_b = 0.0f;
    }

    protected void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        if (button.field_146124_l) {
            if (button.field_146127_k == 1) {
                --this.pageNum;
            } else if (button.field_146127_k == 2) {
                ++this.pageNum;
            } else if (button.field_146127_k == 3) {
                Collections.reverse(this.foodEatenWidgets);
                this.buttonSortDirection.sortDesc = !this.buttonSortDirection.sortDesc;
            }
            this.updateButtons();
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_146976_a(float f, int mouseX, int mouseY) {
    }

    private static class DummyContainer
    extends Container {
        private DummyContainer() {
        }

        public boolean func_75145_c(EntityPlayer entityplayer) {
            return false;
        }
    }
}

