/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cofh.core.util.CoreUtils;
import cofh.core.util.fluid.FluidTankAdv;
import cofh.lib.util.helpers.ItemHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.core.UtilInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiSteamBoiler;
import powercrystals.minefactoryreloaded.gui.container.ContainerFactoryInventory;
import powercrystals.minefactoryreloaded.gui.container.ContainerSteamBoiler;
import powercrystals.minefactoryreloaded.setup.MFRConfig;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryInventory;

public class TileEntitySteamBoiler
extends TileEntityFactoryInventory
implements ITankContainerBucketable {
    public static final int maxTemp = 730;
    private final int _liquidId;
    private int _ticksUntilConsumption = 0;
    private int _ticksSinceLastConsumption = 0;
    private int _totalBurningTime;
    private float _temp;

    public static final int getItemBurnTime(ItemStack itemStack) {
        return TileEntityFurnace.func_145952_a((ItemStack)itemStack) / 2;
    }

    public TileEntitySteamBoiler() {
        super(Machine.SteamBoiler);
        this.setManageSolids(true);
        this._liquidId = FluidRegistry.getFluid((String)"steam").getID();
        this._tanks[0].setLock(FluidRegistry.getFluid((String)"steam"));
        this._tanks[1].setLock(FluidRegistry.getFluid((String)"water"));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiSteamBoiler((ContainerFactoryInventory)this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerSteamBoiler getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerSteamBoiler(this, inventoryPlayer);
    }

    public float getTemp() {
        return this._temp;
    }

    public int getWorkMax() {
        return this._ticksUntilConsumption;
    }

    public int getWorkDone() {
        return this._ticksSinceLastConsumption;
    }

    @SideOnly(value=Side.CLIENT)
    public int getFuelConsumptionPerTick() {
        return 1 + (Math.abs(Math.max(this._totalBurningTime, -180)) + 1063) / 1064;
    }

    @SideOnly(value=Side.CLIENT)
    public void setTemp(int n) {
        this._temp = (float)n / 10.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public void setWorkDone(int n) {
        this._ticksSinceLastConsumption = n;
    }

    @SideOnly(value=Side.CLIENT)
    public void setWorkMax(int n) {
        this._ticksUntilConsumption = n;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            int n;
            boolean bl = this._ticksSinceLastConsumption < this._ticksUntilConsumption;
            this.setIsActive(bl);
            if (this._ticksUntilConsumption > 0) {
                n = 1 + (Math.abs(this._totalBurningTime) + 1063) / 1064;
                this._ticksSinceLastConsumption = Math.min(this._ticksSinceLastConsumption + n, this._ticksUntilConsumption);
            }
            int n2 = n = this._ticksSinceLastConsumption < this._ticksUntilConsumption ? 1 : 0;
            if (bl) {
                this._totalBurningTime = Math.max(Math.min(this._totalBurningTime + 1, 10649), -180);
            } else if (this._temp != 0.0f) {
                this._totalBurningTime = Math.max(this._totalBurningTime - 16, -21298);
                this._ticksUntilConsumption = 0;
            }
            if (this._temp == 0.0f && this._inventory[3] == null) {
                if ((this.field_145850_b.func_82737_E() & 0x6FL) == 0L && this._rednetState == 0 && !CoreUtils.isRedstonePowered((TileEntity)this)) {
                    this.mergeFuel();
                }
                return;
            }
            if (this._temp == 730.0f ? this._totalBurningTime < 0 : this._totalBurningTime > 0 || this._temp != 0.0f) {
                float f = (float)Math.sqrt(Math.abs(this._totalBurningTime)) / 103.0f;
                f = Math.copySign(f, this._totalBurningTime) / 1.26f;
                this._temp = Math.max(Math.min(this._temp + f * f * f / 50.0f, 730.0f), 0.0f);
            }
            if (this._temp > 80.0f) {
                int n3 = this.drain(this._tanks[1], 100, true);
                this._tanks[0].fill(new FluidStack(this._liquidId, n3 * 4), true);
            }
            if (n != 0 || CoreUtils.isRedstonePowered((TileEntity)this)) {
                return;
            }
            if (this.consumeFuel()) {
                this._ticksSinceLastConsumption = 0;
            }
            this.mergeFuel();
        }
    }

    protected void mergeFuel() {
        if (this._inventory[3] != null) {
            for (int i = 0; this._inventory[3].field_77994_a < this._inventory[3].func_77976_d() && i < 3; ++i) {
                UtilInventory.mergeStacks(this._inventory[3], this._inventory[i]);
                if (this._inventory[i] == null || this._inventory[i].field_77994_a != 0) continue;
                this._inventory[i] = null;
            }
        } else {
            for (int i = 0; i < 3; ++i) {
                if (this._inventory[i] == null) continue;
                this._inventory[3] = this._inventory[i];
                this._inventory[i] = null;
                break;
            }
        }
    }

    protected boolean consumeFuel() {
        if (this._inventory[3] == null) {
            return false;
        }
        int n = TileEntitySteamBoiler.getItemBurnTime(this._inventory[3]);
        if (n <= 0) {
            return false;
        }
        this._ticksUntilConsumption = n;
        this._inventory[3] = ItemHelper.consumeItem((ItemStack)this._inventory[3]);
        this.notifyNeighborTileChange();
        return true;
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74768_a("ticksSinceLastConsumption", this._ticksSinceLastConsumption);
        nBTTagCompound.func_74768_a("ticksUntilConsumption", this._ticksUntilConsumption);
        nBTTagCompound.func_74768_a("buffer", this._totalBurningTime);
        nBTTagCompound.func_74776_a("temp", this._temp);
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this._ticksSinceLastConsumption = nBTTagCompound.func_74762_e("ticksSinceLastConsumption");
        this._ticksUntilConsumption = nBTTagCompound.func_74762_e("ticksUntilConsumption");
        this._totalBurningTime = nBTTagCompound.func_74762_e("buffer");
        this._temp = nBTTagCompound.func_74760_g("temp");
    }

    public int func_70302_i_() {
        return 4;
    }

    @Override
    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        if (itemStack != null) {
            return TileEntitySteamBoiler.getItemBurnTime(itemStack) > 0;
        }
        return false;
    }

    @Override
    public boolean func_102008_b(int n, ItemStack itemStack, int n2) {
        return TileEntitySteamBoiler.getItemBurnTime(this._inventory[n]) <= 0;
    }

    @Override
    protected boolean shouldPumpLiquid() {
        return true;
    }

    @Override
    protected boolean shouldPumpTank(IFluidTank iFluidTank) {
        return iFluidTank == this._tanks[0];
    }

    @Override
    protected FluidTankAdv[] createTanks() {
        return new FluidTankAdv[]{new FluidTankAdv(32000), new FluidTankAdv(16000)};
    }

    @Override
    public boolean allowBucketFill(ItemStack itemStack) {
        return true;
    }

    @Override
    public boolean allowBucketDrain(ItemStack itemStack) {
        return true;
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (fluidStack != null && fluidStack.getFluid() == FluidRegistry.WATER) {
            if (MFRConfig.steamBoilerExplodes.getBoolean(false) && this._temp > 80.0f && this._tanks[1].getFluidAmount() == 0) {
                this.field_145850_b.func_72876_a(null, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 3.0f, true);
            }
            return this._tanks[1].fill(fluidStack, bl);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        FluidTankAdv fluidTankAdv = this._tanks[0];
        if (fluidTankAdv.getFluidAmount() > 0) {
            return fluidTankAdv.drain(n, bl);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        FluidTankAdv fluidTankAdv;
        if (fluidStack != null && fluidStack.isFluidEqual((fluidTankAdv = this._tanks[0]).getFluid())) {
            return fluidTankAdv.drain(fluidStack.amount, bl);
        }
        return null;
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return fluid == null || fluid == FluidRegistry.WATER;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }
}

