/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cofh.lib.util.WeightedRandomItemStack;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.api.IFactoryLaserTarget;
import powercrystals.minefactoryreloaded.core.UtilInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiLaserDrill;
import powercrystals.minefactoryreloaded.gui.container.ContainerFactoryInventory;
import powercrystals.minefactoryreloaded.gui.container.ContainerLaserDrill;
import powercrystals.minefactoryreloaded.setup.MFRConfig;
import powercrystals.minefactoryreloaded.setup.MFRThings;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryInventory;

public class TileEntityLaserDrill
extends TileEntityFactoryInventory
implements IFactoryLaserTarget {
    private static final int _energyPerWork = Machine.LaserDrillPrecharger.getActivationEnergy() * 4;
    private static final int _energyStoredMax = 1000000;
    private int _energyStored;
    private int _workStoredMax = MFRConfig.laserdrillCost.getInt();
    private float _workStored;
    private int _bedrockLevel;
    private Random _rand = new Random();

    public static boolean canReplaceBlock(Block block, World world, int n, int n2, int n3) {
        return block == null || block.func_149712_f(world, n, n2, n3) == 0.0f || block.isAir((IBlockAccess)world, n, n2, n3);
    }

    public TileEntityLaserDrill() {
        super(Machine.LaserDrill);
        this.setManageSolids(true);
    }

    @Override
    public ContainerFactoryInventory getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerLaserDrill(this, inventoryPlayer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiLaserDrill(this.getContainer(inventoryPlayer), this);
    }

    @Override
    public boolean canFormBeamWith(ForgeDirection forgeDirection) {
        return forgeDirection.ordinal() > 1 && forgeDirection.ordinal() < 6;
    }

    @Override
    public int addEnergy(ForgeDirection forgeDirection, int n, boolean bl) {
        if (!this.canFormBeamWith(forgeDirection)) {
            return n;
        }
        int n2 = Math.min(n, 1000000 - this._energyStored);
        if (!bl) {
            this._energyStored += n2;
        }
        return n - n2;
    }

    @Override
    public void func_145845_h() {
        if (this.func_145837_r() || this.field_145850_b.field_72995_K) {
            return;
        }
        super.func_145845_h();
        if (this.hasDrops()) {
            return;
        }
        if (this.shouldCheckDrill()) {
            this.updateDrill();
        }
        Block block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        if (this._bedrockLevel < 0) {
            if (block.equals(MFRThings.fakeLaserBlock)) {
                this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
            }
            return;
        }
        if (!block.equals(MFRThings.fakeLaserBlock) && TileEntityLaserDrill.canReplaceBlock(block, this.field_145850_b, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e)) {
            this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, MFRThings.fakeLaserBlock);
        }
        int n = Math.min(_energyPerWork, this._energyStored);
        float f = (float)_energyPerWork * (1.2f - 0.4f * Math.min((float)(this.field_145848_d - this._bedrockLevel), 128.0f) / 128.0f);
        float f2 = (float)n / f;
        this._workStored += f2;
        this._energyStored = (int)((float)this._energyStored - f2 * f);
        while (this._workStored >= (float)this._workStoredMax) {
            this._workStored -= (float)this._workStoredMax;
            this.doDrop(this.getRandomDrop());
        }
    }

    public int getWorkDone() {
        return (int)this._workStored;
    }

    public void setWorkDone(int n) {
        this._workStored = n;
    }

    public int getWorkMax() {
        return this._workStoredMax;
    }

    public int getEnergyStored() {
        return this._energyStored;
    }

    public void setEnergyStored(int n) {
        this._energyStored = n;
    }

    public int getEnergyMax() {
        return 1000000;
    }

    private boolean shouldCheckDrill() {
        return this.field_145850_b.func_82737_E() % 32L == 0L;
    }

    private void updateDrill() {
        int n = Integer.MAX_VALUE;
        n = this.field_145848_d;
        while (n-- > 0) {
            Block block = this.field_145850_b.func_147439_a(this.field_145851_c, n, this.field_145849_e);
            if (block.equals(MFRThings.fakeLaserBlock) || !block.isAir((IBlockAccess)this.field_145850_b, this.field_145851_c, n, this.field_145849_e) && TileEntityLaserDrill.canReplaceBlock(block, this.field_145850_b, this.field_145851_c, n, this.field_145849_e) && this.field_145850_b.func_147480_a(this.field_145851_c, n, this.field_145849_e, true)) continue;
            if (block.func_149667_c(Blocks.field_150357_h)) {
                this._bedrockLevel = n;
                return;
            }
            if (this.field_145850_b.func_147437_c(this.field_145851_c, n, this.field_145849_e)) continue;
            this._bedrockLevel = -1;
            return;
        }
        this._bedrockLevel = 0;
    }

    private ItemStack getRandomDrop() {
        LinkedList<WeightedRandomItemStack> linkedList = new LinkedList<WeightedRandomItemStack>();
        int n = WeightedRandom.func_76272_a(MFRRegistry.getLaserOres()) / 30;
        for (WeightedRandom.Item item : MFRRegistry.getLaserOres()) {
            WeightedRandomItemStack weightedRandomItemStack = (WeightedRandomItemStack)item;
            WeightedRandomItemStack weightedRandomItemStack2 = new WeightedRandomItemStack(weightedRandomItemStack.getStack(), weightedRandomItemStack.field_76292_a);
            linkedList.add(weightedRandomItemStack2);
            for (ItemStack itemStack : this._inventory) {
                if (itemStack == null || !itemStack.func_77973_b().equals(MFRThings.laserFocusItem) || MFRRegistry.getLaserPreferredOres(itemStack.func_77960_j()) == null) continue;
                List<ItemStack> list = MFRRegistry.getLaserPreferredOres(itemStack.func_77960_j());
                int n2 = n / Math.max(1, list.size() / 2) + 1;
                for (ItemStack itemStack2 : list) {
                    if (!UtilInventory.stacksEqual(weightedRandomItemStack2.getStack(), itemStack2)) continue;
                    weightedRandomItemStack2.field_76292_a += n2;
                }
            }
        }
        return ((WeightedRandomItemStack)WeightedRandom.func_76271_a((Random)this._rand, linkedList)).getStack();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public boolean shouldDrawBeam() {
        if (this.shouldCheckDrill()) {
            this.updateDrill();
        }
        return this._bedrockLevel >= 0;
    }

    public int getBeamHeight() {
        return this.field_145848_d - this._bedrockLevel;
    }

    @Override
    public void writeItemNBT(NBTTagCompound nBTTagCompound) {
        super.writeItemNBT(nBTTagCompound);
        nBTTagCompound.func_74768_a("energyStored", this._energyStored);
        nBTTagCompound.func_74776_a("workDone", this._workStored);
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this._energyStored = Math.min(nBTTagCompound.func_74762_e("energyStored"), 1000000);
        this._workStored = Math.min(nBTTagCompound.func_74760_g("workDone"), (float)this.getWorkMax());
    }

    public int func_70302_i_() {
        return 6;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        return false;
    }

    @Override
    public boolean func_102008_b(int n, ItemStack itemStack, int n2) {
        return false;
    }

    @Override
    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return entityPlayer.func_70092_e((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e) <= 64.0;
    }

    @Override
    public boolean func_94041_b(int n, ItemStack itemStack) {
        return false;
    }
}

