/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.minefactoryreloaded.core.IEntityCollidable;
import powercrystals.minefactoryreloaded.core.UtilInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiItemRouter;
import powercrystals.minefactoryreloaded.gui.container.ContainerFactoryInventory;
import powercrystals.minefactoryreloaded.gui.container.ContainerItemRouter;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryInventory;

public class TileEntityItemRouter
extends TileEntityFactoryInventory
implements IEntityCollidable {
    private boolean _routing = false;
    private boolean _rejectUnmapped;
    protected static final int[] _invOffsets = new int[]{0, 0, 9, 18, 36, 27};
    protected static final ForgeDirection[] _outputDirections = new ForgeDirection[]{ForgeDirection.DOWN, ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.WEST};
    private int[] _defaultRoutes = new int[_outputDirections.length];

    public TileEntityItemRouter() {
        this(Machine.ItemRouter);
    }

    public TileEntityItemRouter(Machine machine) {
        super(machine);
        this.setManageSolids(true);
    }

    public boolean getRejectUnmapped() {
        return this._rejectUnmapped;
    }

    public void setRejectUnmapped(boolean bl) {
        this._rejectUnmapped = bl;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            for (int i = 45; i < this.func_70302_i_(); ++i) {
                if (this._inventory[i] == null) continue;
                this._inventory[i] = this.routeItem(this._inventory[i]);
            }
        }
    }

    @Override
    public void onEntityCollided(Entity entity) {
        if (entity instanceof EntityItem && !entity.field_70128_L) {
            ItemStack itemStack = this.routeItem(((EntityItem)entity).func_92059_d());
            if (itemStack == null) {
                entity.func_70106_y();
            } else {
                ((EntityItem)entity).func_92058_a(itemStack);
            }
        }
    }

    public ItemStack routeItem(ItemStack itemStack) {
        int[] nArray = this.getRoutesForItem(itemStack);
        this._routing = true;
        if (this.hasRoutes(nArray)) {
            itemStack = (itemStack = this.weightedRouteItem(itemStack, nArray)) == null || itemStack.field_77994_a <= 0 ? null : itemStack;
        } else if (!this._rejectUnmapped && this.hasRoutes(this._defaultRoutes)) {
            itemStack = (itemStack = this.weightedRouteItem(itemStack, this._defaultRoutes)) == null || itemStack.field_77994_a <= 0 ? null : itemStack;
        }
        this._routing = false;
        return itemStack;
    }

    private ItemStack weightedRouteItem(ItemStack itemStack, int[] nArray) {
        int n;
        ItemStack itemStack2 = itemStack.func_77946_l();
        int n2 = this.totalWeight(nArray);
        if (itemStack.field_77994_a >= n2) {
            n = itemStack.field_77994_a;
            for (int i = 0; i < nArray.length; ++i) {
                ItemStack itemStack3 = itemStack.func_77946_l();
                itemStack3.field_77994_a = n * nArray[i] / n2;
                if (itemStack3.field_77994_a <= 0) continue;
                ItemStack itemStack4 = UtilInventory.dropStack((TileEntity)this, itemStack3, _outputDirections[i], _outputDirections[i]);
                itemStack2.field_77994_a = itemStack4 == null ? (itemStack2.field_77994_a -= itemStack3.field_77994_a) : (itemStack2.field_77994_a -= itemStack3.field_77994_a - itemStack4.field_77994_a);
                if (itemStack2.field_77994_a <= 0) break;
            }
        }
        if (0 < itemStack2.field_77994_a && itemStack2.field_77994_a < this.totalWeight(nArray)) {
            n = this.weightedRandomSide(nArray);
            itemStack2 = UtilInventory.dropStack((TileEntity)this, itemStack2, _outputDirections[n], _outputDirections[n]);
        }
        return itemStack2;
    }

    private int weightedRandomSide(int[] nArray) {
        int n = this.field_145850_b.field_73012_v.nextInt(this.totalWeight(nArray));
        for (int i = 0; i < nArray.length; ++i) {
            if ((n -= nArray[i]) >= 0) continue;
            return i;
        }
        return -1;
    }

    private int totalWeight(int[] nArray) {
        int n = 0;
        for (int n2 : nArray) {
            n += n2;
        }
        return n;
    }

    private boolean hasRoutes(int[] nArray) {
        for (int n : nArray) {
            if (n <= 0) continue;
            return true;
        }
        return false;
    }

    protected int[] getRoutesForItem(ItemStack itemStack) {
        int[] nArray = new int[_outputDirections.length];
        Item item = itemStack.func_77973_b();
        for (int i = 0; i < _outputDirections.length; ++i) {
            int n = _invOffsets[_outputDirections[i].ordinal()];
            nArray[i] = 0;
            for (int j = n; j < n + 9; ++j) {
                if (this._inventory[j] == null || !this._inventory[j].func_77973_b().equals(item) || !itemStack.func_77984_f() && this._inventory[j].func_77960_j() != itemStack.func_77960_j()) continue;
                int n2 = i;
                nArray[n2] = nArray[n2] + this._inventory[j].field_77994_a;
            }
        }
        return nArray;
    }

    private void recalculateDefaultRoutes() {
        for (int i = 0; i < _outputDirections.length; ++i) {
            this._defaultRoutes[i] = this.isSideEmpty(_outputDirections[i]) ? 1 : 0;
        }
    }

    public boolean hasRouteForItem(ItemStack itemStack) {
        return this.hasRoutes(this.getRoutesForItem(itemStack));
    }

    private boolean isSideEmpty(ForgeDirection forgeDirection) {
        int n;
        if (forgeDirection == ForgeDirection.UNKNOWN || forgeDirection == ForgeDirection.UP) {
            return false;
        }
        for (int i = n = _invOffsets[forgeDirection.ordinal()]; i < n + 9; ++i) {
            if (this._inventory[i] == null) continue;
            return false;
        }
        return true;
    }

    public int func_70302_i_() {
        return 48;
    }

    @Override
    public boolean shouldDropSlotWhenBroken(int n) {
        return n >= 45;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiItemRouter(this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerFactoryInventory getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerItemRouter(this, inventoryPlayer);
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Override
    public int getStartInventorySide(ForgeDirection forgeDirection) {
        return 45;
    }

    @Override
    public int getSizeInventorySide(ForgeDirection forgeDirection) {
        return 3;
    }

    @Override
    public void func_70299_a(int n, ItemStack itemStack) {
        int n2;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && n >= (n2 = this.getStartInventorySide(ForgeDirection.UNKNOWN)) && n <= n2 + this.getSizeInventorySide(ForgeDirection.UNKNOWN)) {
            if (itemStack != null) {
                if (itemStack.field_77994_a <= 0) {
                    itemStack = null;
                } else if ((itemStack = this.routeItem(itemStack)) != null && itemStack.field_77994_a > this.func_70297_j_()) {
                    itemStack.field_77994_a = this.func_70297_j_();
                }
            }
            this._inventory[n] = itemStack;
            return;
        }
        super.func_70299_a(n, itemStack);
    }

    @Override
    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        return !this._routing;
    }

    @Override
    public boolean func_94041_b(int n, ItemStack itemStack) {
        return !this._routing;
    }

    @Override
    public boolean func_102008_b(int n, ItemStack itemStack, int n2) {
        return false;
    }

    @Override
    protected void onFactoryInventoryChanged() {
        this.recalculateDefaultRoutes();
    }

    @Override
    public void writePortableData(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        nBTTagCompound.func_74757_a("rejectUnmapped", this._rejectUnmapped);
    }

    @Override
    public void readPortableData(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        this._rejectUnmapped = nBTTagCompound.func_74767_n("rejectUnmapped");
        this.recalculateDefaultRoutes();
    }

    @Override
    public void writeItemNBT(NBTTagCompound nBTTagCompound) {
        super.writeItemNBT(nBTTagCompound);
        nBTTagCompound.func_74757_a("rejectUnmapped", this._rejectUnmapped);
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this._rejectUnmapped = nBTTagCompound.func_74767_n("rejectUnmapped");
        this.recalculateDefaultRoutes();
    }
}

