/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.setup;

import cofh.lib.util.RegistryUtils;
import cofh.lib.util.helpers.StringHelper;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.registry.GameRegistry;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import powercrystals.minefactoryreloaded.block.BlockFactoryMachine;
import powercrystals.minefactoryreloaded.core.MFRUtil;
import powercrystals.minefactoryreloaded.setup.MFRConfig;
import powercrystals.minefactoryreloaded.setup.MFRThings;
import powercrystals.minefactoryreloaded.setup.MachineMaterial;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactory;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryGenerator;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityAutoAnvil;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityAutoBrewer;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityAutoDisenchanter;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityAutoDisenchanterFluid;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityAutoEnchanter;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityAutoJukebox;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityAutoSpawner;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityBioFuelGenerator;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityBioReactor;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityBlockBreaker;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityBlockPlacer;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityBlockSmasher;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityBreeder;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityChronotyper;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityChunkLoader;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityCollector;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityComposter;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityDeepStorageUnit;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityEjector;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityEnchantmentRouter;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityFertilizer;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityFisher;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityFountain;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityFruitPicker;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityGrinder;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityHarvester;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityItemRouter;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityLaserDrill;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityLaserDrillPrecharger;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityLavaFabricator;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityLiquiCrafter;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityLiquidRouter;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityMeatPacker;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityMobCounter;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityMobRouter;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityPlanter;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityRancher;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityRedNote;
import powercrystals.minefactoryreloaded.tile.machine.TileEntitySewer;
import powercrystals.minefactoryreloaded.tile.machine.TileEntitySlaughterhouse;
import powercrystals.minefactoryreloaded.tile.machine.TileEntitySludgeBoiler;
import powercrystals.minefactoryreloaded.tile.machine.TileEntitySteamBoiler;
import powercrystals.minefactoryreloaded.tile.machine.TileEntitySteamTurbine;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityUnifier;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityVet;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityWeather;

public class Machine {
    public static final Material MATERIAL = new MachineMaterial(MapColor.field_151668_h);
    protected static List<Machine> _machines = new LinkedList<Machine>();
    protected static TIntObjectHashMap<Machine> _machineMappings = new TIntObjectHashMap();
    protected static TIntArrayList _highestMetas = new TIntArrayList();
    public static Machine Planter = new Machine(0, 0, "Planter", TileEntityPlanter.class, 160, 8000);
    public static Machine Fisher = new Machine(0, 1, "Fisher", TileEntityFisher.class, 20, 16000);
    public static Machine Harvester = new Machine(0, 2, "Harvester", TileEntityHarvester.class, 240, 16000);
    public static Machine Rancher = new Machine(0, 3, "Rancher", TileEntityRancher.class, 320, 32000);
    public static Machine Fertilizer = new Machine(0, 4, "Fertilizer", TileEntityFertilizer.class, 960, 32000);
    public static Machine Vet = new Machine(0, 5, "Vet", TileEntityVet.class, 320, 32000);
    public static Machine ItemCollector = new Machine(0, 6, "ItemCollector", TileEntityCollector.class);
    public static Machine BlockBreaker = new Machine(0, 7, "BlockBreaker", TileEntityBlockBreaker.class, 960, 64000);
    public static Machine WeatherCollector = new Machine(0, 8, "WeatherCollector", TileEntityWeather.class, 10, 16000);
    public static Machine SludgeBoiler = new Machine(0, 9, "SludgeBoiler", TileEntitySludgeBoiler.class, 30, 16000);
    public static Machine Sewer = new Machine(0, 10, "Sewer", TileEntitySewer.class);
    public static Machine Composter = new Machine(0, 11, "Composter", TileEntityComposter.class, 40, 16000);
    public static Machine Breeder = new Machine(0, 12, "Breeder", TileEntityBreeder.class, 640, 16000);
    public static Machine Grinder = new Machine(0, 13, "Grinder", TileEntityGrinder.class, 3200, 32000);
    public static Machine AutoEnchanter = new Machine(0, 14, "AutoEnchanter", TileEntityAutoEnchanter.class, 160, 16000);
    public static Machine Chronotyper = new Machine(0, 15, "Chronotyper", TileEntityChronotyper.class, 1280, 16000);
    public static Machine Ejector = new Machine(1, 0, "Ejector", TileEntityEjector.class);
    public static Machine ItemRouter = new Machine(1, 1, "ItemRouter", TileEntityItemRouter.class);
    public static Machine LiquidRouter = new Machine(1, 2, "LiquidRouter", TileEntityLiquidRouter.class);
    public static Machine DeepStorageUnit = new Machine(1, 3, "DeepStorageUnit", TileEntityDeepStorageUnit.class){

        @Override
        public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List<String> list, boolean bl) {
            int n;
            ItemStack itemStack2;
            NBTTagCompound nBTTagCompound = itemStack.func_77978_p();
            if (nBTTagCompound != null && nBTTagCompound.func_74764_b("storedStack") && (itemStack2 = ItemStack.func_77949_a((NBTTagCompound)nBTTagCompound.func_74775_l("storedStack"))) != null & (n = nBTTagCompound.func_74762_e("storedQuantity")) > 0) {
                list.add(String.format(MFRUtil.localize("tip.info.mfr.dsu.contains", true), n + " " + itemStack2.func_82833_r() + (bl ? " (" + Item.field_150901_e.func_148757_b((Object)itemStack2.func_77973_b()) + ":" + itemStack2.func_77952_i() + ")" : "")));
            }
            super.addInformation(itemStack, entityPlayer, list, bl);
        }
    };
    public static Machine LiquiCrafter = new Machine(1, 4, "LiquiCrafter", TileEntityLiquiCrafter.class);
    public static Machine LavaFabricator = new Machine(1, 5, "LavaFabricator", TileEntityLavaFabricator.class, 200, 16000);
    public static Machine SteamBoiler = new Machine(1, 6, "SteamBoiler", TileEntitySteamBoiler.class);
    public static Machine AutoJukebox = new Machine(1, 7, "AutoJukebox", TileEntityAutoJukebox.class);
    public static Machine Unifier = new Machine(1, 8, "Unifier", TileEntityUnifier.class);
    public static Machine AutoSpawner = new Machine(1, 9, "AutoSpawner", TileEntityAutoSpawner.class, 600, 32000);
    public static Machine BioReactor = new Machine(1, 10, "BioReactor", TileEntityBioReactor.class);
    public static Machine BioFuelGenerator = new Machine(1, 11, "BioFuelGenerator", TileEntityBioFuelGenerator.class, 160, 10000);
    public static Machine AutoDisenchanter = new Machine(1, 12, "AutoDisenchanter", TileEntityAutoDisenchanter.class, 320, 16000){

        @Override
        public void load(Configuration configuration) {
            if (MFRConfig.disenchanterEssence.getBoolean(false)) {
                this._tileEntityClass = TileEntityAutoDisenchanterFluid.class;
            }
            super.load(configuration);
        }
    };
    public static Machine Slaughterhouse = new Machine(1, 13, "Slaughterhouse", TileEntitySlaughterhouse.class, 1000, 16000);
    public static Machine MeatPacker = new Machine(1, 14, "MeatPacker", TileEntityMeatPacker.class, 20, 16000);
    public static Machine EnchantmentRouter = new Machine(1, 15, "EnchantmentRouter", TileEntityEnchantmentRouter.class);
    public static Machine LaserDrill = new Machine(2, 0, "LaserDrill", TileEntityLaserDrill.class);
    public static Machine LaserDrillPrecharger = new Machine(2, 1, "LaserDrillPrecharger", TileEntityLaserDrillPrecharger.class, 5000, 96000);
    public static Machine AutoAnvil = new Machine(2, 2, "AutoAnvil", TileEntityAutoAnvil.class, 160, 16000);
    public static Machine BlockSmasher = new Machine(2, 3, "BlockSmasher", TileEntityBlockSmasher.class, 10, 16000);
    public static Machine RedNote = new Machine(2, 4, "RedNote", TileEntityRedNote.class);
    public static Machine AutoBrewer = new Machine(2, 5, "AutoBrewer", TileEntityAutoBrewer.class, 40, 16000);
    public static Machine FruitPicker = new Machine(2, 6, "FruitPicker", TileEntityFruitPicker.class, 320, 16000);
    public static Machine BlockPlacer = new Machine(2, 7, "BlockPlacer", TileEntityBlockPlacer.class, 10, 16000);
    public static Machine MobCounter = new Machine(2, 8, "MobCounter", TileEntityMobCounter.class);
    public static Machine SteamTurbine = new Machine(2, 9, "SteamTurbine", TileEntitySteamTurbine.class, 160, 10000);
    public static Machine ChunkLoader = new Machine(2, 10, "ChunkLoader", TileEntityChunkLoader.class, 10, Integer.MAX_VALUE, false){

        @Override
        public void load(Configuration configuration) {
            if (!MFRConfig.enableConfigurableCLEnergy.getBoolean(false)) {
                this._activationEnergy = 0;
            }
            super.load(configuration);
        }
    };
    public static Machine Fountain = new Machine(2, 11, "Fountain", TileEntityFountain.class, 80, 16000);
    public static Machine MobRouter = new Machine(2, 12, "MobRouter", TileEntityMobRouter.class, 2560, 16000);
    protected final int _blockIndex;
    protected final int _meta;
    protected final int _machineIndex;
    protected IIcon[] _iconsActive = new IIcon[6];
    protected IIcon[] _iconsIdle = new IIcon[6];
    protected final String _name;
    protected final String _internalName;
    protected final String _tileEntityName;
    protected Class<? extends TileEntityFactory> _tileEntityClass;
    protected int _activationEnergy;
    protected int _energyStoredMax;
    protected boolean _useDaRF;
    protected boolean _generator;
    protected Property _isRecipeEnabled;

    protected Machine(int n, int n2, String string, Class<? extends TileEntityFactory> clazz) {
        this(n, n2, string, clazz, 0, 0);
    }

    protected Machine(int n, int n2, String string, Class<? extends TileEntityFactory> clazz, int n3, int n4) {
        this(n, n2, string, clazz, n3, n4, true);
    }

    protected Machine(int n, int n2, String string, Class<? extends TileEntityFactory> clazz, int n3, int n4, boolean bl) {
        this._blockIndex = n;
        this._meta = n2;
        this._machineIndex = this._meta | this._blockIndex << 4;
        if (this._meta > 15) {
            throw new IllegalArgumentException("Maximum meta value for machines is 15");
        }
        if (_machineMappings.get(this._machineIndex) != null) {
            throw new IllegalArgumentException("Machine with index " + n + " and meta " + n2 + " already exists.");
        }
        this._name = string;
        this._internalName = "tile.mfr.machine." + string.toLowerCase();
        this._tileEntityName = "factory" + string;
        this._tileEntityClass = clazz;
        this._activationEnergy = n3;
        this._energyStoredMax = n4;
        this._useDaRF = bl;
        this._generator = TileEntityFactoryGenerator.class.isAssignableFrom(clazz);
        _machineMappings.put(this._machineIndex, (Object)this);
        _machines.add(this);
        _highestMetas.ensureCapacity(this._blockIndex);
        if (_highestMetas.getQuick(this._blockIndex) < this._meta) {
            _highestMetas.setQuick(this._blockIndex, this._meta);
        }
    }

    public static Machine getMachineFromIndex(int n, int n2) {
        return (Machine)_machineMappings.get(n2 | n << 4);
    }

    public static Machine getMachineFromId(BlockFactoryMachine blockFactoryMachine, int n) {
        return (Machine)_machineMappings.get(n | blockFactoryMachine.getBlockIndex() << 4);
    }

    public static int getHighestMetadata(int n) {
        return _highestMetas.getQuick(n);
    }

    public static List<Machine> values() {
        return _machines;
    }

    public static void LoadTextures(int n, IIconRegister iIconRegister) {
        for (Machine machine : _machines) {
            if (machine.getBlockIndex() != n) continue;
            machine.loadIcons(iIconRegister);
        }
    }

    private String getTooltipText() {
        return "tip.info.mfr." + this._name.toLowerCase();
    }

    public boolean hasTooltip(ItemStack itemStack) {
        if (itemStack.field_77990_d != null && this._energyStoredMax > 0 && itemStack.field_77990_d.func_74764_b("energyStored")) {
            return true;
        }
        return this._activationEnergy > 0 || StatCollector.func_94522_b((String)this.getTooltipText());
    }

    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List<String> list, boolean bl) {
        Object object;
        if (itemStack.field_77990_d != null) {
            object = itemStack.field_77990_d;
            if (this._energyStoredMax > 0 && object.func_74764_b("energyStored")) {
                String string = StringHelper.getScaledNumber((long)this._energyStoredMax);
                String string2 = StringHelper.getScaledNumber((long)Math.min(this._energyStoredMax, object.func_74762_e("energyStored")));
                list.add(MFRUtil.localize("info.cofh.energyStored", true) + ": " + string2 + " / " + string + " RF");
            }
        }
        if (this._activationEnergy > 0) {
            if (this._generator) {
                list.add(MFRUtil.localize("info.cofh.energyProduce", true) + ": " + EnumChatFormatting.GREEN + this._activationEnergy + " RF/t" + EnumChatFormatting.RESET);
                list.add(MFRUtil.localize("tip.info.mfr.generator.produces", true));
            } else {
                list.add(MFRUtil.localize("info.cofh.energyConsume", true) + ": " + EnumChatFormatting.RED + this._activationEnergy + " RF/Wk" + EnumChatFormatting.RESET);
            }
        }
        if (StatCollector.func_94522_b((String)(object = this.getTooltipText()))) {
            if (((String)(object = StatCollector.func_74838_a((String)object))).contains("\n")) {
                list.addAll(Arrays.asList(((String)object).split("\n")));
            } else {
                list.add((String)object);
            }
        }
    }

    public final String getName() {
        return this._name;
    }

    public final String getInternalName() {
        return this._internalName;
    }

    public Block getBlock() {
        return (Block)MFRThings.machineBlocks.get(this._blockIndex);
    }

    public ItemStack getItemStack() {
        return new ItemStack((Block)MFRThings.machineBlocks.get(this._blockIndex), 1, this._meta);
    }

    public final int getMeta() {
        return this._meta;
    }

    public final int getBlockIndex() {
        return this._blockIndex;
    }

    public final boolean getIsRecipeEnabled() {
        return this._isRecipeEnabled.getBoolean(true);
    }

    public TileEntityFactory getNewTileEntity() {
        try {
            TileEntityFactory tileEntityFactory = this._tileEntityClass.newInstance();
            return tileEntityFactory;
        }
        catch (IllegalAccessException illegalAccessException) {
            FMLLog.severe((String)"Unable to create instance of TileEntity from %s", (Object[])new Object[]{this._tileEntityClass.getName()});
            return null;
        }
        catch (InstantiationException instantiationException) {
            FMLLog.severe((String)"Unable to create instance of TileEntity from %s", (Object[])new Object[]{this._tileEntityClass.getName()});
            return null;
        }
    }

    public final int getActivationEnergyDaRF() {
        return this._activationEnergy / 10;
    }

    public final int getActivationEnergy() {
        return this._activationEnergy;
    }

    public final int getMaxEnergyStorage() {
        return this._energyStoredMax;
    }

    public void load(Configuration configuration) {
        this._isRecipeEnabled = configuration.get("Machine." + this._name, "Recipe.Enabled", true).setRequiresMcRestart(true);
        if (this._activationEnergy > 0) {
            String string = "The energy cost for this machine to complete one work cycle";
            if (this._generator) {
                string = "The amount of energy generated by this machine in one tick";
            }
            this._activationEnergy = this._useDaRF ? configuration.get("Machine." + this._name, "ActivationCostDaRF", this.getActivationEnergyDaRF(), string + ", in units of 10 RF (i.e., 2 DaRF = 20 RF)").setRequiresMcRestart(true).getInt() * 10 : configuration.get("Machine." + this._name, "ActivationCostRF", this.getActivationEnergy(), string + ", in units of **1** RF").setRequiresMcRestart(true).getInt();
        }
        ((Block)MFRThings.machineBlocks.get(this._blockIndex)).setHarvestLevel("pickaxe", 0, this._meta);
        GameRegistry.registerTileEntity(this._tileEntityClass, (String)this._tileEntityName);
    }

    public IIcon getIcon(int n, boolean bl) {
        return (bl ? this._iconsActive : this._iconsIdle)[n];
    }

    public void loadIcons(IIconRegister iIconRegister) {
        this._iconsActive[0] = iIconRegister.func_94245_a(this.loadIcon(Side.bottom, true));
        this._iconsActive[1] = iIconRegister.func_94245_a(this.loadIcon(Side.top, true));
        this._iconsActive[2] = iIconRegister.func_94245_a(this.loadIcon(Side.front, true));
        this._iconsActive[3] = iIconRegister.func_94245_a(this.loadIcon(Side.back, true));
        this._iconsActive[4] = iIconRegister.func_94245_a(this.loadIcon(Side.left, true));
        this._iconsActive[5] = iIconRegister.func_94245_a(this.loadIcon(Side.right, true));
        this._iconsIdle[0] = iIconRegister.func_94245_a(this.loadIcon(Side.bottom, false));
        this._iconsIdle[1] = iIconRegister.func_94245_a(this.loadIcon(Side.top, false));
        this._iconsIdle[2] = iIconRegister.func_94245_a(this.loadIcon(Side.front, false));
        this._iconsIdle[3] = iIconRegister.func_94245_a(this.loadIcon(Side.back, false));
        this._iconsIdle[4] = iIconRegister.func_94245_a(this.loadIcon(Side.left, false));
        this._iconsIdle[5] = iIconRegister.func_94245_a(this.loadIcon(Side.right, false));
    }

    protected String loadIcon(Side side, boolean bl) {
        String string = side.getMain(bl);
        String string2 = this.getInternalName() + ".";
        String string3 = "minefactoryreloaded:machines/" + string2 + string;
        if (RegistryUtils.blockTextureExists((String)string3)) {
            return string3;
        }
        if (side.hasAlt && RegistryUtils.blockTextureExists((String)(string3 = "minefactoryreloaded:machines/" + string2 + side.getAlt(bl)))) {
            return string3;
        }
        string3 = "minefactoryreloaded:machines/" + string2 + side.name;
        if (RegistryUtils.blockTextureExists((String)string3)) {
            return string3;
        }
        if (side.hasAlt && RegistryUtils.blockTextureExists((String)(string3 = "minefactoryreloaded:machines/" + string2 + side.alt))) {
            return string3;
        }
        string3 = "minefactoryreloaded:machines/tile.mfr.machine.0." + string;
        if (RegistryUtils.blockTextureExists((String)string3)) {
            return string3;
        }
        if (side.hasAlt && RegistryUtils.blockTextureExists((String)(string3 = "minefactoryreloaded:machines/tile.mfr.machine.0." + side.getAlt(bl)))) {
            return string3;
        }
        string3 = "minefactoryreloaded:machines/tile.mfr.machine.0." + side.name;
        if (RegistryUtils.blockTextureExists((String)string3)) {
            return string3;
        }
        return "minefactoryreloaded:machines/tile.mfr.machine.0." + side.alt;
    }

    protected static enum Side {
        bottom(null),
        top(null),
        front("side"),
        back("side"),
        left("side"),
        right("side");

        protected String active = "active.";
        protected String idle = "idle.";
        public final String name = this.name();
        public final String alt;
        public boolean hasAlt;

        private Side(String string2) {
            this.hasAlt = string2 != null;
            this.alt = this.hasAlt ? string2 : this.name;
        }

        public String getMain(boolean bl) {
            return (bl ? this.active : this.idle) + this.name();
        }

        public String getAlt(boolean bl) {
            return this.hasAlt ? (bl ? this.active : this.idle) + this.alt : "";
        }
    }
}

