/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.core;

import buildcraft.api.tools.IToolWrench;
import cofh.api.item.IToolHammer;
import cofh.lib.util.helpers.StringHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.input.Keyboard;
import powercrystals.minefactoryreloaded.api.IMFRHammer;
import powercrystals.minefactoryreloaded.setup.MFRThings;

public class MFRUtil {
    public static final int[] COLORS_DYE = new int[]{0x1E1E1E, 0xB62222, 4679965, 8405024, 0x404080, 0x803880, 5547675, 0xA3A3A3, 0x505050, 14188964, 4833610, 14203168, 9283574, 13054117, 14902784, 0xF0F0F0};
    public static final int[] COLORS = new int[16];
    private static final String mojangString = "\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000";
    public static final List<ForgeDirection> VALID_DIRECTIONS;
    private static boolean bcWrenchExists;

    @SideOnly(value=Side.CLIENT)
    public static boolean isAltKeyDown() {
        return Keyboard.isKeyDown((int)56) || Keyboard.isKeyDown((int)184);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isCtrlKeyDown() {
        if (Minecraft.field_142025_a) {
            return Keyboard.isKeyDown((int)219) || Keyboard.isKeyDown((int)220);
        }
        return Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isShiftKeyDown() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    public static String shiftForInfo() {
        return StringHelper.shiftForDetails();
    }

    public static String empty() {
        return EnumChatFormatting.ITALIC + "<" + MFRUtil.localize("info.cofh.empty", true) + ">" + EnumChatFormatting.RESET;
    }

    public static String energy() {
        return MFRUtil.localize("info.cofh.energy", true);
    }

    public static String getFluidName(FluidStack fluidStack) {
        return StringHelper.getFluidName((FluidStack)fluidStack);
    }

    public static boolean containsForcedUnicode(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (mojangString.indexOf(string.charAt(i)) >= 0) continue;
            return true;
        }
        return false;
    }

    public static String localize(String string) {
        return MFRUtil.localize(string + ".name", false, string);
    }

    public static String localize(String string, String string2) {
        return MFRUtil.localize(string + string2 + ".name", true, string2);
    }

    public static String localize(String string, boolean bl) {
        return MFRUtil.localize(string, bl, string);
    }

    public static String localize(String string, boolean bl, String string2) {
        if (!StatCollector.func_94522_b((String)string)) {
            return bl ? string2 : (StatCollector.func_94522_b((String)string2) ? MFRUtil.localize(StatCollector.func_74838_a((String)string2), true) : string2);
        }
        return StatCollector.func_74838_a((String)string);
    }

    public static String localize(String string, Object ... objectArray) {
        if (!StatCollector.func_94522_b((String)string)) {
            return string;
        }
        return StatCollector.func_74837_a((String)string, (Object[])objectArray);
    }

    public static String toNumerals(short s) {
        String string = "potion.potency." + s;
        if (StatCollector.func_94522_b((String)string)) {
            return StatCollector.func_74838_a((String)string);
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (s < 0) {
            s = -s;
            stringBuilder.append('-');
        }
        for (Numeral numeral : Numeral.values) {
            int n = s / numeral.value;
            while (n-- > 0) {
                stringBuilder.append(numeral.name);
            }
            s = (short)(s % numeral.value);
        }
        return stringBuilder.toString();
    }

    public static boolean isHoldingUsableTool(EntityPlayer entityPlayer, int n, int n2, int n3) {
        if (entityPlayer == null) {
            return false;
        }
        if (entityPlayer.field_71071_by.func_70448_g() == null) {
            return false;
        }
        Item item = entityPlayer.field_71071_by.func_70448_g().func_77973_b();
        if (item instanceof IToolHammer) {
            return ((IToolHammer)item).isUsable(entityPlayer.field_71071_by.func_70448_g(), (EntityLivingBase)entityPlayer, n, n2, n3);
        }
        if (item instanceof IMFRHammer) {
            return true;
        }
        return bcWrenchExists && MFRUtil.canHandleBCWrench(item, entityPlayer, n, n2, n3);
    }

    public static void usedWrench(EntityPlayer entityPlayer, int n, int n2, int n3) {
        if (entityPlayer == null) {
            return;
        }
        if (entityPlayer.field_71071_by.func_70448_g() == null) {
            return;
        }
        Item item = entityPlayer.field_71071_by.func_70448_g().func_77973_b();
        if (item instanceof IToolHammer) {
            ((IToolHammer)item).toolUsed(entityPlayer.field_71071_by.func_70448_g(), (EntityLivingBase)entityPlayer, n, n2, n3);
        } else if (!(item instanceof IMFRHammer) && bcWrenchExists) {
            MFRUtil.bcWrenchUsed(item, entityPlayer, n, n2, n3);
        }
    }

    private static boolean canHandleBCWrench(Item item, EntityPlayer entityPlayer, int n, int n2, int n3) {
        return item instanceof IToolWrench && ((IToolWrench)item).canWrench(entityPlayer, n, n2, n3);
    }

    private static void bcWrenchUsed(Item item, EntityPlayer entityPlayer, int n, int n2, int n3) {
        if (item instanceof IToolWrench) {
            ((IToolWrench)item).wrenchUsed(entityPlayer, n, n2, n3);
        }
    }

    public static boolean isHoldingHammer(EntityPlayer entityPlayer) {
        if (entityPlayer == null) {
            return false;
        }
        if (entityPlayer.field_71071_by.func_70448_g() == null) {
            return false;
        }
        Item item = entityPlayer.field_71071_by.func_70448_g().func_77973_b();
        return item instanceof IMFRHammer;
    }

    public static boolean isHolding(EntityPlayer entityPlayer, Class<? extends Item> clazz) {
        if (entityPlayer == null) {
            return false;
        }
        if (entityPlayer.field_71071_by.func_70448_g() == null) {
            return false;
        }
        Item item = entityPlayer.field_71071_by.func_70448_g().func_77973_b();
        return item != null && clazz.isAssignableFrom(item.getClass());
    }

    public static <V extends Entity, T extends Class<V>> V prepareMob(T t, World world) {
        try {
            Entity entity = (Entity)t.getConstructor(World.class).newInstance(world);
            return (V)entity;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static final TileEntity getTile(World world, int n, int n2, int n3) {
        return world.func_72938_d(n, n3).getTileEntityUnsafe(n & 0xF, n2, n3 & 0xF);
    }

    public static ForgeDirection[] directionsWithoutConveyors(World world, int n, int n2, int n3) {
        ArrayList<ForgeDirection> arrayList = new ArrayList<ForgeDirection>();
        Block block = MFRThings.conveyorBlock;
        for (ForgeDirection forgeDirection : ForgeDirection.VALID_DIRECTIONS) {
            if (world.func_147439_a(n + forgeDirection.offsetX, n2 + forgeDirection.offsetY, n3 + forgeDirection.offsetZ).equals(block)) continue;
            arrayList.add(forgeDirection);
        }
        return arrayList.toArray(new ForgeDirection[arrayList.size()]);
    }

    public static void notifyNearbyBlocks(World world, int n, int n2, int n3, Block block) {
        ForgeDirection[] forgeDirectionArray = ForgeDirection.VALID_DIRECTIONS;
        if (world.func_72899_e(n, n2, n3)) {
            for (int i = 0; i < 6; ++i) {
                ForgeDirection forgeDirection = forgeDirectionArray[i];
                int n4 = n + forgeDirection.offsetX;
                int n5 = n2 + forgeDirection.offsetY;
                int n6 = n3 + forgeDirection.offsetZ;
                if (!world.func_72899_e(n4, n5, n6)) continue;
                world.func_147460_e(n4, n5, n6, block);
            }
        }
    }

    public static void notifyNearbyBlocksExcept(World world, int n, int n2, int n3, Block block) {
        ForgeDirection[] forgeDirectionArray = ForgeDirection.VALID_DIRECTIONS;
        if (world.func_72899_e(n, n2, n3) && world.func_147439_a(n, n2, n3) != block) {
            world.func_147460_e(n, n2, n3, block);
            for (int i = 0; i < 6; ++i) {
                ForgeDirection forgeDirection = forgeDirectionArray[i];
                int n4 = n + forgeDirection.offsetX;
                int n5 = n2 + forgeDirection.offsetY;
                int n6 = n3 + forgeDirection.offsetZ;
                if (!world.func_72899_e(n4, n5, n6) || world.func_147439_a(n4, n5, n6) == block) continue;
                world.func_147460_e(n4, n5, n6, block);
            }
        }
    }

    public static void wideNotifyNearbyBlocksExcept(World world, int n, int n2, int n3, Block block) {
        ForgeDirection[] forgeDirectionArray = ForgeDirection.VALID_DIRECTIONS;
        for (int i = 0; i < 6; ++i) {
            ForgeDirection forgeDirection = forgeDirectionArray[i];
            int n4 = n + forgeDirection.offsetX;
            int n5 = n2 + forgeDirection.offsetY;
            int n6 = n3 + forgeDirection.offsetZ;
            if (!world.func_72899_e(n4, n5, n6) || world.func_147439_a(n4, n5, n6) == block) continue;
            world.func_147460_e(n4, n5, n6, block);
            for (int j = 0; j < 6; ++j) {
                if ((j ^ 1) == i) continue;
                ForgeDirection forgeDirection2 = forgeDirectionArray[j];
                int n7 = n4 + forgeDirection2.offsetX;
                int n8 = n5 + forgeDirection2.offsetY;
                int n9 = n6 + forgeDirection2.offsetZ;
                if (!world.func_72899_e(n7, n8, n9) || world.func_147439_a(n7, n8, n9) == block) continue;
                world.func_147460_e(n7, n8, n9, block);
            }
        }
    }

    public static NBTTagCompound writeModifierToNBT(String string, AttributeModifier attributeModifier) {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        nBTTagCompound.func_74778_a("AttributeName", string);
        nBTTagCompound.func_74778_a("Name", attributeModifier.func_111166_b());
        nBTTagCompound.func_74780_a("Amount", attributeModifier.func_111164_d());
        nBTTagCompound.func_74768_a("Operation", attributeModifier.func_111169_c());
        nBTTagCompound.func_74772_a("UUIDMost", attributeModifier.func_111167_a().getMostSignificantBits());
        nBTTagCompound.func_74772_a("UUIDLeast", attributeModifier.func_111167_a().getLeastSignificantBits());
        return nBTTagCompound;
    }

    static {
        int n = 16;
        int n2 = 0;
        while (n-- > 0) {
            MFRUtil.COLORS[n2] = COLORS_DYE[n];
            ++n2;
        }
        VALID_DIRECTIONS = Arrays.asList(ForgeDirection.VALID_DIRECTIONS);
        bcWrenchExists = false;
        try {
            Class.forName("buildcraft.api.tools.IToolWrench");
            bcWrenchExists = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static enum Numeral {
        M(1000),
        CM(900),
        D(500),
        CD(400),
        C(100),
        XC(90),
        L(50),
        XL(40),
        X(10),
        IX(9),
        V(5),
        IV(4),
        I(1);

        public final String name = this.name();
        public final int value;
        private static final Numeral[] values;

        private Numeral(int n2) {
            this.value = n2;
        }

        static {
            values = Numeral.values();
        }
    }
}

