/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.proxy;

import com.github.lunatrius.core.util.vector.Vector3i;
import com.github.lunatrius.core.version.VersionChecker;
import com.github.lunatrius.schematica.api.ISchematic;
import com.github.lunatrius.schematica.command.CommandSchematicaGenerate;
import com.github.lunatrius.schematica.command.CommandSchematicaList;
import com.github.lunatrius.schematica.command.CommandSchematicaRemove;
import com.github.lunatrius.schematica.command.CommandSchematicaSave;
import com.github.lunatrius.schematica.handler.ConfigurationHandler;
import com.github.lunatrius.schematica.handler.DownloadHandler;
import com.github.lunatrius.schematica.handler.QueueTickHandler;
import com.github.lunatrius.schematica.nbt.NBTHelper;
import com.github.lunatrius.schematica.nbt.TileEntityException;
import com.github.lunatrius.schematica.network.PacketHandler;
import com.github.lunatrius.schematica.reference.Reference;
import com.github.lunatrius.schematica.world.SchematicWorld;
import com.github.lunatrius.schematica.world.chunk.FileSaveSchematicContainer;
import com.github.lunatrius.schematica.world.chunk.GenerateSchematicContainer;
import com.github.lunatrius.schematica.world.schematic.SchematicFormat;
import com.github.lunatrius.schematica.world.schematic.SchematicUtil;
import com.github.lunatrius.schematica.world.storage.Schematic;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public abstract class CommonProxy {
    public boolean isSaveEnabled = true;
    public boolean isLoadEnabled = true;

    public void preInit(FMLPreInitializationEvent event) {
        Reference.logger = event.getModLog();
        ConfigurationHandler.init(event.getSuggestedConfigurationFile());
        VersionChecker.registerMod((ModMetadata)event.getModMetadata(), (String)"10.13.2.1230");
    }

    public void init(FMLInitializationEvent event) {
        PacketHandler.init();
        FMLCommonHandler.instance().bus().register((Object)QueueTickHandler.INSTANCE);
        FMLCommonHandler.instance().bus().register((Object)DownloadHandler.INSTANCE);
    }

    public void postInit(FMLPostInitializationEvent event) {
    }

    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandSchematicaSave());
        event.registerServerCommand((ICommand)new CommandSchematicaList());
        event.registerServerCommand((ICommand)new CommandSchematicaRemove());
        event.registerServerCommand((ICommand)new CommandSchematicaGenerate());
    }

    public void createFolders() {
        if (!ConfigurationHandler.schematicDirectory.exists() && !ConfigurationHandler.schematicDirectory.mkdirs()) {
            Reference.logger.info("Could not create schematic directory [%s]!", new Object[]{ConfigurationHandler.schematicDirectory.getAbsolutePath()});
        }
    }

    public abstract File getDataDirectory();

    public void resetSettings() {
        this.isSaveEnabled = true;
        this.isLoadEnabled = true;
    }

    public void copyChunkToSchematic(ISchematic schematic, World world, int chunkX, int chunkZ, int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        int localMinX = minX < chunkX << 4 ? 0 : minX & 0xF;
        int localMaxX = maxX > (chunkX << 4) + 15 ? 15 : maxX & 0xF;
        int localMinZ = minZ < chunkZ << 4 ? 0 : minZ & 0xF;
        int localMaxZ = maxZ > (chunkZ << 4) + 15 ? 15 : maxZ & 0xF;
        Chunk chunk = world.func_72964_e(chunkX, chunkZ);
        for (int i = 0; i < chunk.field_76645_j.length; ++i) {
            for (Object entityObj : chunk.field_76645_j[i]) {
                Entity entity = (Entity)entityObj;
                entity.field_70165_t -= (double)minX;
                entity.field_70163_u -= (double)minY;
                entity.field_70161_v -= (double)minZ;
                schematic.addEntity(entity);
                entity.field_70165_t += (double)minX;
                entity.field_70163_u += (double)minY;
                entity.field_70161_v += (double)minZ;
            }
        }
        for (int chunkLocalX = localMinX; chunkLocalX <= localMaxX; ++chunkLocalX) {
            for (int chunkLocalZ = localMinZ; chunkLocalZ <= localMaxZ; ++chunkLocalZ) {
                for (int y = minY; y <= maxY; ++y) {
                    int x = chunkLocalX | chunkX << 4;
                    int z = chunkLocalZ | chunkZ << 4;
                    int localX = x - minX;
                    int localY = y - minY;
                    int localZ = z - minZ;
                    try {
                        TileEntity tileEntity;
                        Block block = world.func_147439_a(x, y, z);
                        int metadata = world.func_72805_g(x, y, z);
                        boolean success = schematic.setBlock(localX, localY, localZ, block, metadata);
                        if (!success || !block.hasTileEntity(metadata) || (tileEntity = world.func_147438_o(x, y, z)) == null) continue;
                        try {
                            TileEntity reloadedTileEntity = NBTHelper.reloadTileEntity(tileEntity, minX, minY, minZ);
                            schematic.setTileEntity(localX, localY, localZ, reloadedTileEntity);
                        }
                        catch (TileEntityException tee) {
                            Reference.logger.error(String.format("Error while trying to save tile entity '%s'!", tileEntity), (Throwable)tee);
                            schematic.setBlock(localX, localY, localZ, Blocks.field_150357_h);
                        }
                        continue;
                    }
                    catch (Exception e) {
                        Reference.logger.error("Something went wrong!", (Throwable)e);
                    }
                }
            }
        }
    }

    public boolean generateSchematic(ICommandSender sender, File directory, String filename, World world, Vector3i from) {
        ISchematic schematic = SchematicFormat.readFromFile(directory, filename);
        if (schematic == null) {
            return false;
        }
        GenerateSchematicContainer container = new GenerateSchematicContainer(schematic, sender, world, from, filename);
        QueueTickHandler.INSTANCE.queueSchematic(container);
        return true;
    }

    public void generateSchematicChunk(ISchematic schematic, World world, int chunkX, int chunkZ, Vector3i from) {
        int maxX = from.x + schematic.getWidth() - 1;
        int maxZ = from.z + schematic.getLength() - 1;
        int maxY = from.y + schematic.getHeight() - 1;
        int localMinX = from.x < chunkX << 4 ? 0 : from.x & 0xF;
        int localMaxX = maxX > (chunkX << 4) + 15 ? 15 : maxX & 0xF;
        int localMinZ = from.z < chunkZ << 4 ? 0 : from.z & 0xF;
        int localMaxZ = maxZ > (chunkZ << 4) + 15 ? 15 : maxZ & 0xF;
        for (int x = localMinX; x <= localMaxX; ++x) {
            for (int z = localMinZ; z <= localMaxZ; ++z) {
                for (int y = from.y; y <= maxY; ++y) {
                    int worldX = x | chunkX << 4;
                    int worldZ = z | chunkZ << 4;
                    Block block = schematic.getBlock(worldX - from.x, y - from.y, worldZ - from.z);
                    int meta = schematic.getBlockMetadata(worldX - from.x, y - from.y, worldZ - from.z);
                    world.func_147465_d(worldX, y, worldZ, block, meta, 3);
                    TileEntity te = schematic.getTileEntity(worldX - from.x, y - from.y, worldZ - from.z);
                    if (te == null) continue;
                    try {
                        te = NBTHelper.reloadTileEntity(te, -from.x, -from.y, -from.z);
                        world.func_147455_a(worldX, y, worldZ, te);
                        continue;
                    }
                    catch (TileEntityException ex) {
                        Reference.logger.error(String.format("Error while trying to generate tile entity '%s'!", te), (Throwable)ex);
                        world.func_147449_b(worldX, y, worldZ, Blocks.field_150357_h);
                    }
                }
            }
        }
    }

    public boolean saveSchematic(EntityPlayer player, File directory, String filename, World world, Vector3i from, Vector3i to) {
        try {
            String iconName = "";
            try {
                String[] parts = filename.split(";");
                if (parts.length == 2) {
                    iconName = parts[0];
                    filename = parts[1];
                }
            }
            catch (Exception e) {
                Reference.logger.error("Failed to parse icon data!", (Throwable)e);
            }
            int minX = Math.min(from.x, to.x);
            int maxX = Math.max(from.x, to.x);
            int minY = Math.min(from.y, to.y);
            int maxY = Math.max(from.y, to.y);
            int minZ = Math.min(from.z, to.z);
            int maxZ = Math.max(from.z, to.z);
            short width = (short)(Math.abs(maxX - minX) + 1);
            short height = (short)(Math.abs(maxY - minY) + 1);
            short length = (short)(Math.abs(maxZ - minZ) + 1);
            Schematic schematic = new Schematic(SchematicUtil.getIconFromName(iconName), width, height, length);
            FileSaveSchematicContainer container = new FileSaveSchematicContainer(schematic, (ICommandSender)player, world, new File(directory, filename), new Vector3i(minX, minY, minZ));
            QueueTickHandler.INSTANCE.queueSchematic(container);
            return true;
        }
        catch (Exception e) {
            Reference.logger.error("Failed to save schematic!", (Throwable)e);
            return false;
        }
    }

    public abstract boolean loadSchematic(EntityPlayer var1, File var2, String var3);

    public abstract void setActiveSchematic(SchematicWorld var1);

    public abstract void setActiveSchematic(SchematicWorld var1, EntityPlayer var2);

    public abstract SchematicWorld getActiveSchematic();

    public abstract SchematicWorld getActiveSchematic(EntityPlayer var1);

    public abstract boolean isPlayerQuotaExceeded(EntityPlayer var1);

    public abstract File getPlayerSchematicDirectory(EntityPlayer var1, boolean var2);
}

