/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.nbt;

import com.github.lunatrius.schematica.nbt.TileEntityException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class NBTHelper {
    public static List<TileEntity> readTileEntitiesFromCompound(NBTTagCompound compound) {
        return NBTHelper.readTileEntitiesFromCompound(compound, new ArrayList<TileEntity>());
    }

    public static List<TileEntity> readTileEntitiesFromCompound(NBTTagCompound compound, List<TileEntity> tileEntities) {
        NBTTagList tagList = compound.func_150295_c("TileEntities", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tileEntityCompound = tagList.func_150305_b(i);
            TileEntity tileEntity = TileEntity.func_145827_c((NBTTagCompound)tileEntityCompound);
            tileEntities.add(tileEntity);
        }
        return tileEntities;
    }

    public static NBTTagCompound writeTileEntitiesToCompound(List<TileEntity> tileEntities) {
        return NBTHelper.writeTileEntitiesToCompound(tileEntities, new NBTTagCompound());
    }

    public static NBTTagCompound writeTileEntitiesToCompound(List<TileEntity> tileEntities, NBTTagCompound compound) {
        NBTTagList tagList = new NBTTagList();
        for (TileEntity tileEntity : tileEntities) {
            NBTTagCompound tileEntityCompound = new NBTTagCompound();
            tileEntity.func_145841_b(tileEntityCompound);
            tagList.func_74742_a((NBTBase)tileEntityCompound);
        }
        compound.func_74782_a("TileEntities", (NBTBase)tagList);
        return compound;
    }

    public static List<Entity> readEntitiesFromCompound(NBTTagCompound compound) {
        return NBTHelper.readEntitiesFromCompound(compound, null, new ArrayList<Entity>());
    }

    public static List<Entity> readEntitiesFromCompound(NBTTagCompound compound, World world) {
        return NBTHelper.readEntitiesFromCompound(compound, world, new ArrayList<Entity>());
    }

    public static List<Entity> readEntitiesFromCompound(NBTTagCompound compound, List<Entity> entities) {
        return NBTHelper.readEntitiesFromCompound(compound, null, entities);
    }

    public static List<Entity> readEntitiesFromCompound(NBTTagCompound compound, World world, List<Entity> entities) {
        NBTTagList tagList = compound.func_150295_c("Entities", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound entityCompound = tagList.func_150305_b(i);
            Entity entity = EntityList.func_75615_a((NBTTagCompound)entityCompound, (World)world);
            entities.add(entity);
        }
        return entities;
    }

    public static NBTTagCompound writeEntitiesToCompound(List<Entity> entities) {
        return NBTHelper.writeEntitiesToCompound(entities, new NBTTagCompound());
    }

    public static NBTTagCompound writeEntitiesToCompound(List<Entity> entities, NBTTagCompound compound) {
        NBTTagList tagList = new NBTTagList();
        for (Entity entity : entities) {
            NBTTagCompound entityCompound = new NBTTagCompound();
            entity.func_70109_d(entityCompound);
            tagList.func_74742_a((NBTBase)entityCompound);
        }
        compound.func_74782_a("Entities", (NBTBase)tagList);
        return compound;
    }

    public static TileEntity reloadTileEntity(TileEntity tileEntity) throws TileEntityException {
        return NBTHelper.reloadTileEntity(tileEntity, 0, 0, 0);
    }

    public static TileEntity reloadTileEntity(TileEntity tileEntity, int offsetX, int offsetY, int offsetZ) throws TileEntityException {
        if (tileEntity == null) {
            return null;
        }
        try {
            NBTTagCompound tileEntityCompound = new NBTTagCompound();
            tileEntity.func_145841_b(tileEntityCompound);
            tileEntity = TileEntity.func_145827_c((NBTTagCompound)tileEntityCompound);
            tileEntity.field_145851_c -= offsetX;
            tileEntity.field_145848_d -= offsetY;
            tileEntity.field_145849_e -= offsetZ;
        }
        catch (Exception e) {
            throw new TileEntityException(tileEntity, (Throwable)e);
        }
        return tileEntity;
    }
}

