/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.util.ForgeDirection;

public class PlacementData {
    public static final ForgeDirection[] VALID_DIRECTIONS = ForgeDirection.VALID_DIRECTIONS;
    public final PlacementType type;
    public int maskOffset = 0;
    public float offsetLowY = 0.0f;
    public float offsetHighY = 1.0f;
    public int maskMetaInHand = -1;
    public int bitShiftMetaInHand = 0;
    public int maskMeta = 15;
    public final Map<ForgeDirection, Integer> mapping = new HashMap<ForgeDirection, Integer>();

    public PlacementData(PlacementType type, int ... metadata) {
        this.type = type;
        for (int i = 0; i < VALID_DIRECTIONS.length && i < metadata.length; ++i) {
            if (metadata[i] < 0 || metadata[i] > 15) continue;
            this.mapping.put(VALID_DIRECTIONS[i], metadata[i]);
        }
    }

    public PlacementData setOffset(int maskOffset, float offsetLowY, float offsetHighY) {
        this.maskOffset = maskOffset;
        this.offsetLowY = offsetLowY;
        this.offsetHighY = offsetHighY;
        return this;
    }

    public PlacementData setMaskMetaInHand(int maskMetaInHand) {
        this.maskMetaInHand = maskMetaInHand;
        return this;
    }

    public PlacementData setBitShiftMetaInHand(int bitShiftMetaInHand) {
        this.bitShiftMetaInHand = bitShiftMetaInHand;
        return this;
    }

    public PlacementData setMaskMeta(int maskMeta) {
        this.maskMeta = maskMeta;
        return this;
    }

    public float getOffsetFromMetadata(int metadata) {
        return (metadata & this.maskOffset) == 0 ? this.offsetLowY : this.offsetHighY;
    }

    public int getMetaInHand(int metadata) {
        if (this.maskMetaInHand != -1) {
            metadata &= this.maskMetaInHand;
        }
        if (this.bitShiftMetaInHand > 0) {
            metadata >>= this.bitShiftMetaInHand;
        } else if (this.bitShiftMetaInHand < 0) {
            metadata <<= -this.bitShiftMetaInHand;
        }
        return metadata;
    }

    public ForgeDirection[] getValidDirections(ForgeDirection[] solidSides, int metadata) {
        ArrayList<ForgeDirection> list = new ArrayList<ForgeDirection>();
        for (ForgeDirection direction : solidSides) {
            Integer meta;
            if (this.maskOffset != 0 && ((metadata & this.maskOffset) != 0 ? this.offsetLowY < 0.5f && direction == ForgeDirection.DOWN : this.offsetLowY < 0.5f && direction == ForgeDirection.UP)) continue;
            if (this.type == PlacementType.BLOCK && ((meta = this.mapping.get(direction)) != null ? meta : -1) != (this.maskMeta & metadata) && this.mapping.size() != 0) continue;
            list.add(direction);
        }
        ForgeDirection[] directions = new ForgeDirection[list.size()];
        return list.toArray(directions);
    }

    public static enum PlacementType {
        BLOCK,
        PLAYER,
        PISTON;

    }
}

