/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.item.tool;

import cofh.api.energy.IEnergyContainerItem;
import cofh.core.item.IEqualityOverrideItem;
import cofh.lib.util.helpers.EnergyHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermalexpansion.item.tool.ItemToolBase;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class ItemEnergyContainerBase
extends ItemToolBase
implements IEnergyContainerItem,
IEqualityOverrideItem {
    public int maxEnergy = 80000;
    public int maxTransfer = 160;
    public int energyPerUse = 400;

    public ItemEnergyContainerBase(String string) {
        super(string);
    }

    public ItemEnergyContainerBase setEnergyParameters(int n, int n2, int n3) {
        this.maxEnergy = n;
        this.maxTransfer = n2;
        this.energyPerUse = n3;
        return this;
    }

    public void func_150895_a(Item item, CreativeTabs creativeTabs, List list) {
        list.add(EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack(item, 1, 0), (int)0));
        list.add(EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack(item, 1, 0), (int)this.maxEnergy));
    }

    @Override
    protected void addInformationDelegate(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean bl) {
        super.addInformationDelegate(itemStack, entityPlayer, list, bl);
        if (itemStack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)itemStack, (int)0);
        }
        list.add(StringHelper.localize((String)"info.cofh.charge") + ": " + itemStack.field_77990_d.func_74762_e("Energy") + " / " + this.maxEnergy + " RF");
        list.add("\u00a76" + this.energyPerUse + " RF " + StringHelper.localize((String)"info.cofh.perUse") + "\u00a7r");
    }

    public boolean isDamaged(ItemStack itemStack) {
        return itemStack.func_77960_j() != Short.MAX_VALUE;
    }

    public int getDisplayDamage(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)itemStack, (int)0);
        }
        return 1 + this.maxEnergy - itemStack.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxDamage(ItemStack itemStack) {
        return 1 + this.maxEnergy;
    }

    public int receiveEnergy(ItemStack itemStack, int n, boolean bl) {
        if (itemStack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)itemStack, (int)0);
        }
        int n2 = itemStack.field_77990_d.func_74762_e("Energy");
        int n3 = Math.min(n, Math.min(this.maxEnergy - n2, this.maxTransfer));
        if (!bl) {
            itemStack.field_77990_d.func_74768_a("Energy", n2 += n3);
        }
        return n3;
    }

    public int extractEnergy(ItemStack itemStack, int n, boolean bl) {
        if (itemStack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)itemStack, (int)0);
        }
        int n2 = itemStack.field_77990_d.func_74762_e("Energy");
        int n3 = Math.min(n, n2);
        if (!bl) {
            itemStack.field_77990_d.func_74768_a("Energy", n2 -= n3);
        }
        return n3;
    }

    public int getEnergyStored(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)itemStack, (int)0);
        }
        return itemStack.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxEnergyStored(ItemStack itemStack) {
        return this.maxEnergy;
    }

    public boolean isLastHeldItemEqual(ItemStack itemStack, ItemStack itemStack2) {
        NBTTagCompound nBTTagCompound = itemStack.field_77990_d;
        NBTTagCompound nBTTagCompound2 = itemStack2.field_77990_d;
        if (nBTTagCompound == nBTTagCompound2) {
            return true;
        }
        if (nBTTagCompound == null || nBTTagCompound2 == null) {
            return false;
        }
        nBTTagCompound = (NBTTagCompound)nBTTagCompound.func_74737_b();
        nBTTagCompound2 = (NBTTagCompound)nBTTagCompound2.func_74737_b();
        nBTTagCompound.func_82580_o("Energy");
        nBTTagCompound2.func_82580_o("Energy");
        return nBTTagCompound.equals((Object)nBTTagCompound2);
    }
}

