/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.gui.container;

import cofh.api.item.IInventoryContainerItem;
import cofh.lib.gui.slot.ISlotValidator;
import cofh.lib.gui.slot.SlotValidated;
import cofh.lib.util.helpers.MathHelper;
import cofh.thermalexpansion.block.strongbox.BlockStrongbox;
import cofh.thermalexpansion.block.strongbox.TileStrongbox;
import cofh.thermalexpansion.gui.container.ContainerTEBase;
import cpw.mods.fml.common.Optional;
import gnu.trove.map.hash.THashMap;
import invtweaks.api.container.ChestContainer;
import invtweaks.api.container.ContainerSection;
import invtweaks.api.container.ContainerSectionCallback;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

@ChestContainer
public class ContainerStrongbox
extends ContainerTEBase
implements ISlotValidator {
    int storageIndex;
    int rowSize;
    TileStrongbox myTile;

    public ContainerStrongbox(InventoryPlayer inventoryPlayer, TileEntity tileEntity) {
        super(tileEntity);
        this.myTile = (TileStrongbox)tileEntity;
        this.myTile.func_70295_k_();
        this.storageIndex = this.myTile.getStorageIndex();
        this.rowSize = MathHelper.clampI((int)(this.storageIndex + 1), (int)9, (int)13);
        int n = MathHelper.clampI((int)this.storageIndex, (int)2, (int)8);
        int n2 = this.rowSize * n;
        this.addPlayerSlotsToContainer(inventoryPlayer, 8 + 9 * (this.rowSize - 9), n);
        if (this.storageIndex == 0) {
            this.func_75146_a((Slot)new SlotValidated((ISlotValidator)this, (IInventory)this.myTile, 0, 80, 26));
            this.rowSize = 1;
        } else {
            int n3 = 17;
            for (int i = 0; i < n2; ++i) {
                this.func_75146_a((Slot)new SlotValidated((ISlotValidator)this, (IInventory)this.myTile, i, 8 + i % this.rowSize * 18, n3 + i / this.rowSize * 18));
            }
        }
    }

    private void addPlayerSlotsToContainer(InventoryPlayer inventoryPlayer, int n, int n2) {
        int n3;
        for (n3 = 0; n3 < 3; ++n3) {
            for (int i = 0; i < 9; ++i) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, i + n3 * 9 + 9, n + i * 18, 30 + 18 * n2 + n3 * 18));
            }
        }
        for (n3 = 0; n3 < 9; ++n3) {
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, n3, n + n3 * 18, 88 + 18 * n2));
        }
    }

    public void func_75134_a(EntityPlayer entityPlayer) {
        super.func_75134_a(entityPlayer);
        this.myTile.func_70305_f();
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer entityPlayer, int n) {
        if (this.myTile.getType() == BlockStrongbox.Types.CREATIVE.ordinal()) {
            return null;
        }
        return super.func_82846_b(entityPlayer, n);
    }

    public TileStrongbox getTile() {
        return this.myTile;
    }

    @Optional.Method(modid="inventorytweaks")
    @ChestContainer.RowSizeCallback
    public int getRowSize() {
        return this.rowSize;
    }

    @ContainerSectionCallback
    @Optional.Method(modid="inventorytweaks")
    public Map<ContainerSection, List<Slot>> getContainerSections() {
        THashMap tHashMap = new THashMap();
        tHashMap.put(ContainerSection.INVENTORY, this.field_75151_b.subList(0, 36));
        tHashMap.put(ContainerSection.INVENTORY_NOT_HOTBAR, this.field_75151_b.subList(0, 27));
        tHashMap.put(ContainerSection.INVENTORY_HOTBAR, this.field_75151_b.subList(27, 36));
        tHashMap.put(ContainerSection.CHEST, this.field_75151_b.subList(36, this.field_75151_b.size()));
        return tHashMap;
    }

    public boolean isItemValid(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        if (itemStack.func_77973_b() instanceof IInventoryContainerItem) {
            return ((IInventoryContainerItem)itemStack.func_77973_b()).getSizeInventory(itemStack) <= 0;
        }
        return true;
    }
}

