/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.api.crafting;

import java.util.ArrayList;
import java.util.List;
import net.mcft.copy.betterstorage.api.crafting.IRecipeInput;
import net.mcft.copy.betterstorage.api.crafting.IStationRecipe;
import net.mcft.copy.betterstorage.api.crafting.RecipeBounds;
import net.mcft.copy.betterstorage.api.crafting.RecipeInputItemStack;
import net.mcft.copy.betterstorage.api.crafting.RecipeInputOreDict;
import net.mcft.copy.betterstorage.api.crafting.StationCrafting;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public final class BetterStorageCrafting {
    public static final List<IStationRecipe> recipes = new ArrayList<IStationRecipe>();

    private BetterStorageCrafting() {
    }

    public static void addStationRecipe(IStationRecipe recipe) {
        recipes.add(recipe);
    }

    public static StationCrafting findMatchingStationCrafting(ItemStack[] input) {
        RecipeBounds bounds = new RecipeBounds(input);
        for (IStationRecipe recipe : recipes) {
            StationCrafting crafting = recipe.checkMatch(input, bounds);
            if (crafting == null) continue;
            return crafting;
        }
        return null;
    }

    public static IRecipeInput makeInput(Object obj) {
        if (obj instanceof IRecipeInput) {
            return (IRecipeInput)obj;
        }
        if (obj instanceof ItemStack) {
            return new RecipeInputItemStack((ItemStack)obj);
        }
        if (obj instanceof Item) {
            return new RecipeInputItemStack(new ItemStack((Item)obj));
        }
        if (obj instanceof Block) {
            return new RecipeInputItemStack(new ItemStack((Block)obj));
        }
        if (obj instanceof String) {
            return new RecipeInputOreDict((String)obj, 1);
        }
        throw new IllegalArgumentException(String.format("Argument is %s, not an IRecipeInput, ItemStack, Item, Block or String.", obj != null ? obj.getClass().getSimpleName() : "null"));
    }
}

