/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.core.settings.TickRates;
import appeng.me.GridAccessException;
import appeng.parts.p2p.PartP2PTunnel;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class PartP2PLight
extends PartP2PTunnel<PartP2PLight>
implements IGridTickable {
    int lastValue = 0;
    float opacity = -1.0f;

    public PartP2PLight(ItemStack is) {
        super(is);
    }

    @Override
    public void chanRender(MENetworkChannelsChanged c) {
        this.onTunnelNetworkChange();
        super.chanRender(c);
    }

    @Override
    public void powerRender(MENetworkPowerStatusChange c) {
        this.onTunnelNetworkChange();
        super.powerRender(c);
    }

    @Override
    public void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
        data.writeInt(this.output ? this.lastValue : 0);
    }

    @Override
    public boolean readFromStream(ByteBuf data) throws IOException {
        super.readFromStream(data);
        this.lastValue = data.readInt();
        this.output = this.lastValue > 0;
        return false;
    }

    private boolean doWork() {
        if (this.output) {
            return false;
        }
        TileEntity te = this.getTile();
        World w = te.func_145831_w();
        int newLevel = w.func_72957_l(te.field_145851_c + this.side.offsetX, te.field_145848_d + this.side.offsetY, te.field_145849_e + this.side.offsetZ);
        if (this.lastValue != newLevel && this.proxy.isActive()) {
            this.lastValue = newLevel;
            try {
                for (PartP2PLight out : this.getOutputs()) {
                    out.setLightLevel(this.lastValue);
                }
            }
            catch (GridAccessException e) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    @Override
    public void onNeighborChanged() {
        this.opacity = -1.0f;
        this.doWork();
        if (this.output) {
            this.getHost().markForUpdate();
        }
    }

    @Override
    public int getLightLevel() {
        if (this.output && this.isPowered()) {
            return this.blockLight(this.lastValue);
        }
        return 0;
    }

    public void setLightLevel(int out) {
        this.lastValue = out;
        this.getHost().markForUpdate();
    }

    private int blockLight(int emit) {
        if (this.opacity < 0.0f) {
            TileEntity te = this.getTile();
            this.opacity = 255 - te.func_145831_w().getBlockLightOpacity(te.field_145851_c + this.side.offsetX, te.field_145848_d + this.side.offsetY, te.field_145849_e + this.side.offsetZ);
        }
        return (int)((float)emit * (this.opacity / 255.0f));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getTypeTexture() {
        return Blocks.field_150371_ca.func_149733_h(0);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        if (tag.func_74764_b("opacity")) {
            this.opacity = tag.func_74760_g("opacity");
        }
        this.lastValue = tag.func_74762_e("lastValue");
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74776_a("opacity", this.opacity);
        tag.func_74768_a("lastValue", this.lastValue);
    }

    @Override
    public void onTunnelConfigChange() {
        this.onTunnelNetworkChange();
    }

    @Override
    public void onTunnelNetworkChange() {
        if (this.output) {
            PartP2PLight src = (PartP2PLight)this.getInput();
            if (src != null && src.proxy.isActive()) {
                this.setLightLevel(src.lastValue);
            } else {
                this.getHost().markForUpdate();
            }
        } else {
            this.doWork();
        }
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.LightTunnel.min, TickRates.LightTunnel.max, false, false);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int TicksSinceLastCall) {
        return this.doWork() ? TickRateModulation.FASTER : TickRateModulation.SLOWER;
    }

    public float getPowerDrainPerTick() {
        return 0.5f;
    }
}

