/*
 * Decompiled with CFR 0.152.
 */
package appeng.core;

import appeng.api.IAppEngApi;
import appeng.api.definitions.Blocks;
import appeng.api.definitions.Items;
import appeng.api.definitions.Materials;
import appeng.api.definitions.Parts;
import appeng.api.exceptions.FailedConnection;
import appeng.api.features.IRegistryContainer;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridNode;
import appeng.api.storage.IStorageHelper;
import appeng.core.ApiDefinitions;
import appeng.core.api.ApiPart;
import appeng.core.api.ApiStorage;
import appeng.core.features.registries.RegistryContainer;
import appeng.me.GridConnection;
import appeng.me.GridNode;
import appeng.util.Platform;
import net.minecraftforge.common.util.ForgeDirection;

public final class Api
implements IAppEngApi {
    public static final Api INSTANCE = new Api();
    private final ApiPart partHelper;
    private final IRegistryContainer registryContainer;
    private final IStorageHelper storageHelper;
    private final Materials materials;
    private final Items items;
    private final Blocks blocks;
    private final Parts parts = new Parts();
    private final ApiDefinitions definitions;

    private Api() {
        this.blocks = new Blocks();
        this.items = new Items();
        this.materials = new Materials();
        this.storageHelper = new ApiStorage();
        this.registryContainer = new RegistryContainer();
        this.partHelper = new ApiPart();
        this.definitions = new ApiDefinitions(this.partHelper);
    }

    @Override
    public IRegistryContainer registries() {
        return this.registryContainer;
    }

    @Override
    public IStorageHelper storage() {
        return this.storageHelper;
    }

    @Override
    public ApiPart partHelper() {
        return this.partHelper;
    }

    @Override
    public Items items() {
        return this.items;
    }

    @Override
    public Materials materials() {
        return this.materials;
    }

    @Override
    public Blocks blocks() {
        return this.blocks;
    }

    @Override
    public Parts parts() {
        return this.parts;
    }

    @Override
    public ApiDefinitions definitions() {
        return this.definitions;
    }

    @Override
    public IGridNode createGridNode(IGridBlock blk) {
        if (Platform.isClient()) {
            throw new IllegalStateException("Grid features for " + blk + " are server side only.");
        }
        return new GridNode(blk);
    }

    @Override
    public IGridConnection createGridConnection(IGridNode a, IGridNode b) throws FailedConnection {
        return new GridConnection(a, b, ForgeDirection.UNKNOWN);
    }
}

