/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.inventory;

import net.minecraft.item.ItemStack;

public abstract class InventoryStack {
    private ItemStack nativeStack;
    private ItemStack inStack;
    private ItemStack outStack;
    private int nativeCount;
    private int inCount;
    private int outCount;

    public void init() {
        this.reset();
    }

    public void reset() {
        this.nativeStack = this.getNewItemStack();
        this.inStack = this.getNewItemStack();
        this.outStack = this.getNewItemStack();
        this.nativeCount = 0;
        this.inCount = 0;
        this.outCount = 0;
        this.refresh();
    }

    public ItemStack getNativeStack() {
        return this.nativeStack;
    }

    public ItemStack getInStack() {
        if (this.inStack == null || this.inStack.field_77994_a == 0) {
            return null;
        }
        return this.inStack;
    }

    public ItemStack getOutStack() {
        return this.outStack;
    }

    protected abstract ItemStack getNewItemStack();

    protected abstract int getItemStackSize();

    protected abstract int getItemCount();

    protected abstract int getItemCapacity();

    public void markDirty() {
        this.applyDiff(this.getDiff());
        this.refresh();
    }

    public boolean markDirtyIfNeeded() {
        int diff = this.getDiff();
        if (diff != 0) {
            this.applyDiff(diff);
            this.refresh();
            return true;
        }
        return false;
    }

    public int getDiff() {
        if (this.nativeStack == null) {
            return 0;
        }
        int diffNative = this.nativeStack.field_77994_a - this.nativeCount;
        int diffIn = this.inStack.field_77994_a - this.inCount;
        int diffOut = this.outStack.field_77994_a - this.outCount;
        return diffNative + diffIn + diffOut;
    }

    protected abstract void applyDiff(int var1);

    protected void refresh() {
        int itemStackLimit = this.getItemStackSize();
        int itemCount = this.getItemCount();
        int remainingLimit = this.getItemCapacity() - itemCount;
        if (this.nativeStack != null) {
            this.nativeStack.field_77994_a = this.nativeCount = itemCount;
        }
        if (this.inStack != null) {
            this.inStack.field_77994_a = this.inCount = itemStackLimit - Math.min(itemStackLimit, remainingLimit);
        }
        if (this.outStack != null) {
            this.outStack.field_77994_a = this.outCount = Math.min(itemStackLimit, itemCount);
        }
    }
}

