/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.config;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class OreDictRegistry {
    private Set<String> blacklist = new HashSet<String>();
    private Set<String> whitelist = new HashSet<String>();
    private List<String> blacklistPrefix = new ArrayList<String>();
    private Set<String> blacklistCache = new HashSet<String>();
    private Set<String> graylistCache = new HashSet<String>();

    public OreDictRegistry() {
        this.addBlacklist("logWood");
        this.addBlacklist("plankWood");
        this.addBlacklist("slabWood");
        this.addBlacklist("stairWood");
        this.addBlacklist("treeSapling");
        this.addBlacklist("treeLeaves");
        this.addBlacklist("blockGlass");
        this.addBlacklist("paneGlass");
        this.addBlacklist("record");
        this.addBlacklist("stone");
        this.addBlacklist("cobblestone");
        this.addBlacklist("sand");
        this.addBlacklist("sandstone");
        this.addBlacklistPrefix("list");
    }

    public boolean addBlacklist(String entry) {
        if (entry == null) {
            return false;
        }
        this.blacklistCache.add(entry);
        this.graylistCache.remove(entry);
        return this.blacklist.add(entry);
    }

    public boolean addBlacklistPrefix(String entry) {
        if (entry == null) {
            return false;
        }
        if (this.blacklistPrefix.contains(entry)) {
            return false;
        }
        this.graylistCache.clear();
        return this.blacklistPrefix.add(entry);
    }

    public boolean addWhitelist(String entry) {
        if (entry == null) {
            return false;
        }
        return this.whitelist.add(entry);
    }

    public boolean removeBlacklist(String entry) {
        this.blacklistCache.remove(entry);
        return this.blacklist.remove(entry);
    }

    public boolean removeBlacklistPrefix(String entry) {
        return this.blacklistPrefix.remove(entry);
    }

    public boolean removeWhitelist(String entry) {
        return this.whitelist.remove(entry);
    }

    public boolean isEntryBlacklisted(String entry) {
        if (this.blacklistCache.contains(entry)) {
            return true;
        }
        int n = this.blacklistPrefix.size();
        for (int i = 0; i < n; ++i) {
            if (!entry.startsWith(this.blacklistPrefix.get(i))) continue;
            this.blacklistCache.add(entry);
            return true;
        }
        return false;
    }

    public boolean isEntryWhitelisted(String entry) {
        return this.whitelist.contains(entry);
    }

    public boolean isEntryValid(String entry) {
        if (this.graylistCache.contains(entry)) {
            return true;
        }
        if (!this.whitelist.contains(entry)) {
            if (this.isEntryBlacklisted(entry)) {
                return false;
            }
            if (!this.isValidForEquiv(entry)) {
                this.blacklistCache.add(entry);
                return false;
            }
        }
        this.graylistCache.add(entry);
        return true;
    }

    private boolean isValidForEquiv(String oreName) {
        ArrayList oreList = OreDictionary.getOres((String)oreName);
        if (oreList.size() == 0) {
            return false;
        }
        int n = oreList.size();
        for (int i = 0; i < n; ++i) {
            if (((ItemStack)oreList.get(i)).func_77960_j() != Short.MAX_VALUE) continue;
            return false;
        }
        HashSet<Integer> mergedIds = new HashSet<Integer>();
        int maxKeyCount = 0;
        int n2 = oreList.size();
        for (int i = 0; i < n2; ++i) {
            int[] ids = OreDictionary.getOreIDs((ItemStack)((ItemStack)oreList.get(i)));
            maxKeyCount = Math.max(maxKeyCount, ids.length);
            for (int id : ids) {
                mergedIds.add(id);
            }
        }
        return maxKeyCount >= mergedIds.size();
    }
}

