/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.config;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;

public class ConfigManager {
    private static final String LANG_PREFIX = "storageDrawers.config.";
    private final Configuration config;
    public final ConfigCache cache;
    public final List<ConfigSection> sections = new ArrayList<ConfigSection>();
    public final ConfigSection sectionGeneral = new ConfigSection(this.sections, "general", "general");
    public final ConfigSection sectionIntegration = new ConfigSection(this.sections, "integration", "integration");
    public final ConfigSection sectionBlocks = new ConfigSection(this.sections, "blocks", "blocks");
    public final ConfigSection sectionUpgrades = new ConfigSection(this.sections, "upgrades", "upgrades");
    public final List<ConfigSection> blockSections = new ArrayList<ConfigSection>();
    public final ConfigSection sectionBlocksFullDrawers1x1 = new ConfigSection(this.blockSections, this.sectionBlocks, "fulldrawers1", "blocks.fullDrawers1");
    public final ConfigSection sectionBlocksFullDrawers1x2 = new ConfigSection(this.blockSections, this.sectionBlocks, "fulldrawers2", "blocks.fullDrawers2");
    public final ConfigSection sectionBlocksFullDrawers2x2 = new ConfigSection(this.blockSections, this.sectionBlocks, "fulldrawers4", "blocks.fullDrawers4");
    public final ConfigSection sectionBlocksHalfDrawers1x2 = new ConfigSection(this.blockSections, this.sectionBlocks, "halfdrawers2", "blocks.halfDrawers2");
    public final ConfigSection sectionBlocksHalfDrawers2x2 = new ConfigSection(this.blockSections, this.sectionBlocks, "halfdrawers4", "blocks.halfDrawers4");
    public final ConfigSection sectionBlocksCompDrawers = new ConfigSection(this.blockSections, this.sectionBlocks, "compdrawers", "blocks.compDrawers");
    public final ConfigSection sectionBlocksController = new ConfigSection(this.blockSections, this.sectionBlocks, "controller", "blocks.controller");
    public final ConfigSection sectionBlocksTrim = new ConfigSection(this.blockSections, this.sectionBlocks, "trim", "blocks.trim");
    public final ConfigSection sectionBlocksSlave = new ConfigSection(this.blockSections, this.sectionBlocks, "controllerSlave", "blocks.controllerSlave");
    public Map<String, ConfigSection> blockSectionsMap = new HashMap<String, ConfigSection>();

    public ConfigManager(File file) {
        this.config = new Configuration(file);
        this.cache = new ConfigCache();
        for (ConfigSection section : this.sections) {
            section.getCategory();
        }
        for (ConfigSection section : this.blockSections) {
            section.getCategory();
            this.blockSectionsMap.put(section.name, section);
        }
        this.syncConfig();
    }

    public void syncConfig() {
        this.cache.enableIndicatorUpgrades = this.config.get("general", "enableIndicatorUpgrades", true).setLanguageKey("storageDrawers.config.prop.enableIndicatorUpgrades").setRequiresMcRestart(true).getBoolean();
        this.cache.enableStorageUpgrades = this.config.get("general", "enableStorageUpgrades", true).setLanguageKey("storageDrawers.config.prop.enableStorageUpgrades").setRequiresMcRestart(true).getBoolean();
        this.cache.enableLockUpgrades = this.config.get("general", "enableLockUpgrades", true).setLanguageKey("storageDrawers.config.prop.enableLockUpgrades").setRequiresMcRestart(true).getBoolean();
        this.cache.enableVoidUpgrades = this.config.get("general", "enableVoidUpgrades", true).setLanguageKey("storageDrawers.config.prop.enableVoidUpgrades").setRequiresMcRestart(true).getBoolean();
        this.cache.enableShroudUpgrades = this.config.get("general", "enableShroudUpgrades", true).setLanguageKey("storageDrawers.config.prop.enableShroudUpgrades").setRequiresMcRestart(true).getBoolean();
        this.cache.enableSortingUpgrades = this.config.get("general", "enableSortingUpgrades", true).setLanguageKey("storageDrawers.config.prop.enableSortingUpgrades").setRequiresMcRestart(true).getBoolean();
        this.cache.itemRenderType = this.config.get("general", "itemRenderType", "fast", null, new String[]{"fancy", "fast"}).setLanguageKey("storageDrawers.config.prop.itemRenderType").getString();
        this.cache.renderStorageUpgrades = this.config.get("general", "renderStorageUpgrades", true).setLanguageKey("storageDrawers.config.prop.renderStorageUpgrades").getBoolean();
        this.cache.creativeTabVanillaWoods = this.config.get("general", "creativeTabVanillaWoods", true).setLanguageKey("storageDrawers.config.prop.creativeTabVanillaWoods").getBoolean();
        this.cache.enableDrawerUI = this.config.get("general", "enableDrawerUI", true).setLanguageKey("storageDrawers.config.prop.enableDrawerUI").getBoolean();
        this.cache.enableSidedInput = this.config.get("general", "enableSidedInput", true).setLanguageKey("storageDrawers.config.prop.enableSidedInput").getBoolean();
        this.cache.enableSidedOutput = this.config.get("general", "enableSidedOutput", true).setLanguageKey("storageDrawers.config.prop.enableSidedOutput").getBoolean();
        this.cache.enableItemConversion = this.config.get("general", "enableItemConversion", true).setLanguageKey("storageDrawers.config.prop.enableItemConversion").getBoolean();
        this.cache.invertShift = this.config.get("general", "invertShift", false, "Inverts how shift works with drawers. If this is true, shifting will only give one item, where regular clicks will give a full stack. Leave false for default behavior.").setLanguageKey("storageDrawers.config.prop.invertShift").getBoolean();
        this.cache.debugTrace = this.config.get("general", "enableDebugLogging", false, "Writes additional log messages while using the mod.  Mainly for debug purposes.  Should be kept disabled unless instructed otherwise.").setLanguageKey("storageDrawers.config.prop.enableDebugLogging").getBoolean();
        this.cache.enableAE2Integration = this.config.get(this.sectionIntegration.getQualifiedName(), "enableAE2", true).setLanguageKey("storageDrawers.config.integration.enableAE2").setRequiresMcRestart(true).getBoolean();
        this.cache.enableWailaIntegration = this.config.get(this.sectionIntegration.getQualifiedName(), "enableWaila", true).setLanguageKey("storageDrawers.config.integration.enableWaila").setRequiresMcRestart(true).getBoolean();
        this.cache.enableThaumcraftIntegration = this.config.get(this.sectionIntegration.getQualifiedName(), "enableThaumcraft", true).setLanguageKey("storageDrawers.config.integration.enableThaumcraft").setRequiresMcRestart(true).getBoolean();
        this.cache.enableMineTweakerIntegration = this.config.get(this.sectionIntegration.getQualifiedName(), "enableMineTweaker", true).setLanguageKey("storageDrawers.config.integration.enableMineTweaker").setRequiresMcRestart(true).getBoolean();
        this.cache.enableRefinedRelocationIntegration = this.config.get(this.sectionIntegration.getQualifiedName(), "enableRefinedRelocation", true).setLanguageKey("storageDrawers.config.integration.enableRefinedRelocation").setRequiresMcRestart(true).getBoolean();
        this.config.get(this.sectionBlocksFullDrawers1x1.getQualifiedName(), "enabled", true).setLanguageKey("storageDrawers.config.prop.enabled").setRequiresMcRestart(true);
        this.config.get(this.sectionBlocksFullDrawers1x1.getQualifiedName(), "baseStorage", 32).setLanguageKey("storageDrawers.config.prop.baseStorage").setRequiresWorldRestart(true);
        this.config.get(this.sectionBlocksFullDrawers1x1.getQualifiedName(), "recipeOutput", 1).setLanguageKey("storageDrawers.config.prop.recipeOutput").setRequiresMcRestart(true);
        this.config.get(this.sectionBlocksFullDrawers1x2.getQualifiedName(), "enabled", true).setLanguageKey("storageDrawers.config.prop.enabled").setRequiresMcRestart(true);
        this.config.get(this.sectionBlocksFullDrawers1x2.getQualifiedName(), "baseStorage", 16).setLanguageKey("storageDrawers.config.prop.baseStorage").setRequiresWorldRestart(true);
        this.config.get(this.sectionBlocksFullDrawers1x2.getQualifiedName(), "recipeOutput", 2).setLanguageKey("storageDrawers.config.prop.recipeOutput").setRequiresMcRestart(true);
        this.config.get(this.sectionBlocksFullDrawers2x2.getQualifiedName(), "enabled", true).setLanguageKey("storageDrawers.config.prop.enabled").setRequiresMcRestart(true);
        this.config.get(this.sectionBlocksFullDrawers2x2.getQualifiedName(), "baseStorage", 8).setLanguageKey("storageDrawers.config.prop.baseStorage").setRequiresWorldRestart(true);
        this.config.get(this.sectionBlocksFullDrawers2x2.getQualifiedName(), "recipeOutput", 4).setLanguageKey("storageDrawers.config.prop.recipeOutput").setRequiresMcRestart(true);
        this.config.get(this.sectionBlocksHalfDrawers1x2.getQualifiedName(), "enabled", true).setLanguageKey("storageDrawers.config.prop.enabled").setRequiresMcRestart(true);
        this.config.get(this.sectionBlocksHalfDrawers1x2.getQualifiedName(), "baseStorage", 8).setLanguageKey("storageDrawers.config.prop.baseStorage").setRequiresWorldRestart(true);
        this.config.get(this.sectionBlocksHalfDrawers1x2.getQualifiedName(), "recipeOutput", 2).setLanguageKey("storageDrawers.config.prop.recipeOutput").setRequiresMcRestart(true);
        this.config.get(this.sectionBlocksHalfDrawers2x2.getQualifiedName(), "enabled", true).setLanguageKey("storageDrawers.config.prop.enabled").setRequiresMcRestart(true);
        this.config.get(this.sectionBlocksHalfDrawers2x2.getQualifiedName(), "baseStorage", 4).setLanguageKey("storageDrawers.config.prop.baseStorage").setRequiresWorldRestart(true);
        this.config.get(this.sectionBlocksHalfDrawers2x2.getQualifiedName(), "recipeOutput", 4).setLanguageKey("storageDrawers.config.prop.recipeOutput").setRequiresMcRestart(true);
        this.config.get(this.sectionBlocksCompDrawers.getQualifiedName(), "enabled", true).setLanguageKey("storageDrawers.config.prop.enabled").setRequiresMcRestart(true);
        this.config.get(this.sectionBlocksCompDrawers.getQualifiedName(), "baseStorage", 16).setLanguageKey("storageDrawers.config.prop.baseStorage").setRequiresWorldRestart(true);
        this.config.get(this.sectionBlocksCompDrawers.getQualifiedName(), "recipeOutput", 1).setLanguageKey("storageDrawers.config.prop.recipeOutput").setRequiresMcRestart(true);
        this.config.get(this.sectionBlocksController.getQualifiedName(), "enabled", true).setLanguageKey("storageDrawers.config.prop.enabled").setRequiresMcRestart(true);
        this.config.get(this.sectionBlocksTrim.getQualifiedName(), "enabled", true).setLanguageKey("storageDrawers.config.prop.enabled").setRequiresMcRestart(true);
        this.config.get(this.sectionBlocksTrim.getQualifiedName(), "recipeOutput", 4).setLanguageKey("storageDrawers.config.prop.recipeOutput").setRequiresMcRestart(true);
        this.config.get(this.sectionBlocksSlave.getQualifiedName(), "enabled", true).setLanguageKey("storageDrawers.config.prop.enabled").setRequiresMcRestart(true);
        this.cache.level2Mult = this.config.get(this.sectionUpgrades.getQualifiedName(), "level2Mult", 2).setLanguageKey("storageDrawers.config.upgrades.level2Mult").setRequiresWorldRestart(true).getInt();
        this.cache.level3Mult = this.config.get(this.sectionUpgrades.getQualifiedName(), "level3Mult", 3).setLanguageKey("storageDrawers.config.upgrades.level3Mult").setRequiresWorldRestart(true).getInt();
        this.cache.level4Mult = this.config.get(this.sectionUpgrades.getQualifiedName(), "level4Mult", 5).setLanguageKey("storageDrawers.config.upgrades.level4Mult").setRequiresWorldRestart(true).getInt();
        this.cache.level5Mult = this.config.get(this.sectionUpgrades.getQualifiedName(), "level5Mult", 8).setLanguageKey("storageDrawers.config.upgrades.level5Mult").setRequiresWorldRestart(true).getInt();
        this.cache.level6Mult = this.config.get(this.sectionUpgrades.getQualifiedName(), "level6Mult", 13).setLanguageKey("storageDrawers.config.upgrades.level6Mult").setRequiresWorldRestart(true).getInt();
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    public boolean isFancyItemRenderEnabled() {
        return this.cache.itemRenderType.equals("fancy");
    }

    public String getPath() {
        return this.config.toString();
    }

    public boolean isBlockEnabled(String blockName) {
        if (!this.blockSectionsMap.containsKey(blockName)) {
            return false;
        }
        ConfigSection section = this.blockSectionsMap.get(blockName);
        return section.getCategory().get("enabled").getBoolean();
    }

    public int getBlockBaseStorage(String blockName) {
        if (!this.blockSectionsMap.containsKey(blockName)) {
            return 0;
        }
        ConfigSection section = this.blockSectionsMap.get(blockName);
        return section.getCategory().get("baseStorage").getInt();
    }

    public int getBlockRecipeOutput(String blockName) {
        if (!this.blockSectionsMap.containsKey(blockName)) {
            return 0;
        }
        ConfigSection section = this.blockSectionsMap.get(blockName);
        return section.getCategory().get("recipeOutput").getInt();
    }

    public int getStorageUpgradeMultiplier(int level) {
        switch (level) {
            case 2: {
                return this.cache.level2Mult;
            }
            case 3: {
                return this.cache.level3Mult;
            }
            case 4: {
                return this.cache.level4Mult;
            }
            case 5: {
                return this.cache.level5Mult;
            }
            case 6: {
                return this.cache.level6Mult;
            }
        }
        return 1;
    }

    public class ConfigCache {
        public boolean enableIndicatorUpgrades;
        public boolean enableStorageUpgrades;
        public boolean enableLockUpgrades;
        public boolean enableVoidUpgrades;
        public boolean enableShroudUpgrades;
        public boolean enableSortingUpgrades;
        public boolean renderStorageUpgrades;
        public boolean enableDrawerUI;
        public String itemRenderType;
        public boolean creativeTabVanillaWoods;
        public boolean enableSidedInput;
        public boolean enableSidedOutput;
        public boolean enableItemConversion;
        public boolean enableWailaIntegration;
        public boolean enableAE2Integration;
        public boolean enableThaumcraftIntegration;
        public boolean enableMineTweakerIntegration;
        public boolean enableRefinedRelocationIntegration;
        public boolean invertShift;
        public boolean debugTrace;
        public int level2Mult;
        public int level3Mult;
        public int level4Mult;
        public int level5Mult;
        public int level6Mult;
    }

    public class ConfigSection {
        public final ConfigSection parent;
        public final String name;
        public final String lang;
        private ConfigCategory category;

        public ConfigSection(List<ConfigSection> list, ConfigSection parent, String name, String lang) {
            this.parent = parent;
            this.name = name;
            this.lang = lang;
            list.add(this);
        }

        public ConfigSection(List<ConfigSection> list, String name, String lang) {
            this(list, null, name, lang);
        }

        public ConfigCategory getCategory() {
            if (this.category != null) {
                return this.category;
            }
            this.category = this.parent != null ? ConfigManager.this.config.getCategory(this.parent.getCategory().getQualifiedName() + "." + this.name.toLowerCase()) : ConfigManager.this.config.getCategory(this.name.toLowerCase());
            this.category.setLanguageKey(ConfigManager.LANG_PREFIX + this.lang);
            return this.category;
        }

        public String getQualifiedName() {
            return this.getCategory().getQualifiedName();
        }
    }
}

