/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.util.minecraftTypes;

import java.util.HashMap;
import java.util.Map;

public enum MobNames {
    BAT("Bat", "bat"),
    BLAZE("Blaze", "blaze"),
    CAVE_SPIDER("CaveSpider", "cavespider", "cave_spider"),
    CHICKEN("Chicken", "chicken"),
    COW("Cow", "cow"),
    CREEPER("Creeper", "creeper"),
    ENDER_DRAGON("EnderDragon", "enderdragon", "ender_dragon"),
    ENDERMAN("Enderman", "enderman"),
    GHAST("Ghast", "ghast"),
    GIANT("Giant", "giant", "giantzombie", "zombiegiant"),
    HORSE("EntityHorse", "Horse", "horse"),
    IRON_GOLEM("VillagerGolem", "villagergolem", "villager_golem", "IronGolem", "irongolem", "iron_golem"),
    MAGMA_CUBE("LavaSlime", "lavaslime", "lava_slime", "magmacube", "magma_cube"),
    MUSHROOM_COW("MushroomCow", "mushroomcow", "shroom", "mooshroom", "moshoom", "mcow", "shroomcow"),
    OCELOT("Ozelot", "ozelot", "Ocelot", "ocelot"),
    PIG("Pig", "pig"),
    PIG_ZOMBIE("PigZombie", "pigzombie", "pig_zombie"),
    SHEEP("Sheep", "sheep"),
    SILVERFISH("Silverfish", "silverfish", "silver_fish"),
    SKELETON("Skeleton", "skeleton"),
    SLIME("Slime", "slime"),
    SNOWMAN("SnowMan", "snowman"),
    SPIDER("Spider", "spider"),
    SQUID("Squid", "squid"),
    VILLAGER("Villager", "villager"),
    WITCH("Witch", "witch"),
    WITHER("WitherBoss", "witherboss", "wither_boss", "Wither", "wither"),
    WOLF("Wolf", "wolf"),
    ZOMBIE("Zombie", "zombie");

    private static Map<String, String> mobAliases;
    private String[] aliases;
    private String internalMinecraftName;

    public static String toInternalName(String alias) {
        if (mobAliases.containsKey(alias)) {
            return mobAliases.get(alias);
        }
        return alias;
    }

    private static void register(String internalMinecraftName, String ... aliases) {
        for (String alias : aliases) {
            mobAliases.put(alias, internalMinecraftName);
        }
    }

    private MobNames(String internalMinecraftName, String ... aliases) {
        this.internalMinecraftName = internalMinecraftName;
        this.aliases = aliases;
    }

    public String getInternalName() {
        return this.internalMinecraftName;
    }

    static {
        mobAliases = new HashMap<String, String>();
        for (MobNames alt : MobNames.values()) {
            MobNames.register(alt.internalMinecraftName, alt.aliases);
        }
    }
}

