/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.util.minecraftTypes;

import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.configuration.BiomeLoadInstruction;
import com.khorn.terraincontrol.configuration.standard.MinecraftBiomeTemplates;
import com.khorn.terraincontrol.configuration.standard.MojangSettings;
import com.khorn.terraincontrol.configuration.standard.StandardBiomeTemplate;
import com.khorn.terraincontrol.logging.LogMarker;

public enum DefaultBiome {
    OCEAN(0, "Ocean", MinecraftBiomeTemplates.Ocean.class),
    PLAINS(1, "Plains", MinecraftBiomeTemplates.Plains.class),
    DESERT(2, "Desert", MinecraftBiomeTemplates.Desert.class),
    EXTREME_HILLS(3, "Extreme Hills", MinecraftBiomeTemplates.ExtremeHills.class),
    FOREST(4, "Forest", MinecraftBiomeTemplates.Forest.class),
    TAIGA(5, "Taiga", MinecraftBiomeTemplates.Taiga.class),
    SWAMPLAND(6, "Swampland", MinecraftBiomeTemplates.Swampland.class),
    RIVER(7, "River", MinecraftBiomeTemplates.River.class),
    HELL(8, "Hell", MinecraftBiomeTemplates.Hell.class),
    SKY(9, "Sky", MinecraftBiomeTemplates.Sky.class),
    FROZEN_OCEAN(10, "FrozenOcean", MinecraftBiomeTemplates.FrozenOcean.class),
    FROZEN_RIVER(11, "FrozenRiver", MinecraftBiomeTemplates.FrozenRiver.class),
    ICE_PLAINS(12, "Ice Plains", MinecraftBiomeTemplates.IcePlains.class),
    ICE_MOUNTAINS(13, "Ice Mountains", MinecraftBiomeTemplates.IceMountains.class),
    MUSHROOM_ISLAND(14, "MushroomIsland", MinecraftBiomeTemplates.MushroomIsland.class),
    MUSHROOM_SHORE(15, "MushroomIslandShore", MinecraftBiomeTemplates.MushroomIslandShore.class),
    BEACH(16, "Beach", MinecraftBiomeTemplates.Beach.class),
    DESERT_HILLS(17, "DesertHills", MinecraftBiomeTemplates.DesertHills.class),
    FOREST_HILLS(18, "ForestHills", MinecraftBiomeTemplates.ForestHills.class),
    TAIGA_HILLS(19, "TaigaHills", MinecraftBiomeTemplates.TaigaHills.class),
    SMALL_MOUNTAINS(20, "Extreme Hills Edge", MinecraftBiomeTemplates.ExtremeHillsEdge.class),
    JUNGLE(21, "Jungle", MinecraftBiomeTemplates.Jungle.class),
    JUNGLE_HILLS(22, "JungleHills", MinecraftBiomeTemplates.JungleHills.class),
    JUNGLE_EDGE(23, "JungleEdge", MinecraftBiomeTemplates.JungleEdge.class),
    DEEP_OCEAN(24, "Deep Ocean", MinecraftBiomeTemplates.DeepOcean.class),
    STONE_BEACH(25, "Stone Beach", MinecraftBiomeTemplates.StoneBeach.class),
    COLD_BEACH(26, "Cold Beach", MinecraftBiomeTemplates.ColdBeach.class),
    BIRCH_FOREST(27, "Birch Forest", MinecraftBiomeTemplates.BirchForest.class),
    BIRCH_FOREST_HILLS(28, "Birch Forest Hills", MinecraftBiomeTemplates.BirchForestHills.class),
    ROOFED_FOREST(29, "Roofed Forest", MinecraftBiomeTemplates.RoofedForest.class),
    COLD_TAIGA(30, "Cold Taiga", MinecraftBiomeTemplates.ColdTaiga.class),
    COLD_TAIGA_HILLS(31, "Cold Taiga Hills", MinecraftBiomeTemplates.ColdTaigaHills.class),
    MEGA_TAIGA(32, "Mega Taiga", MinecraftBiomeTemplates.MegaTaiga.class),
    MEGA_TAIGA_HILLS(33, "Mega Taiga Hills", MinecraftBiomeTemplates.MegaTaigaHills.class),
    EXTREME_HILLS_PLUS(34, "Extreme Hills+", MinecraftBiomeTemplates.ExtremeHillsPlus.class),
    SAVANNA(35, "Savanna", MinecraftBiomeTemplates.Savanna.class),
    SAVANNA_PLATEAU(36, "Savanna Plateau", MinecraftBiomeTemplates.SavannaPlateau.class),
    MESA(37, "Mesa", MinecraftBiomeTemplates.Mesa.class),
    MESA_PLATEAU_FOREST(38, "Mesa Plateau F", MinecraftBiomeTemplates.MesaPlateauForest.class),
    MESA_PLATEAU(39, "Mesa Plateau", MinecraftBiomeTemplates.MesaPlateau.class),
    SUNFLOWER_PLAINS(129, "Sunflower Plains", MinecraftBiomeTemplates.SunflowerPlains.class),
    DESERT_MOUNTAINS(130, "Desert M", MinecraftBiomeTemplates.DesertMountains.class),
    EXTREME_HILLS_MOUNTAINS(131, "Extreme Hills M", MinecraftBiomeTemplates.ExtremeHillsMountains.class),
    FLOWER_FOREST(132, "Flower Forest", MinecraftBiomeTemplates.FlowerForest.class),
    TAIGA_MOUNTAINS(133, "Taiga M", MinecraftBiomeTemplates.TaigaMountains.class),
    SWAMPLAND_MOUNTAINS(134, "Swampland M", MinecraftBiomeTemplates.SwamplandMountains.class),
    ICE_PLAINS_SPIKES(140, "Ice Plains Spikes", MinecraftBiomeTemplates.IcePlainsSpikes.class),
    JUNGLE_MOUNTAINS(149, "Jungle M", MinecraftBiomeTemplates.JungleMountains.class),
    JUNGLE_EDGE_MOUNTAINS(151, "JungleEdge M", MinecraftBiomeTemplates.JungleEdgeMountains.class),
    BIRCH_FOREST_MOUNTAINS(155, "Birch Forest M", MinecraftBiomeTemplates.BirchForestMountains.class),
    BIRCH_FOREST_HILLS_MOUNTAINS(156, "Birch Forest Hills M", MinecraftBiomeTemplates.BirchForestHillsMountains.class),
    ROOFED_FOREST_MOUNTAINS(157, "Roofed Forest M", MinecraftBiomeTemplates.RoofedForestMountains.class),
    COLD_TAIGA_MOUNTAINS(158, "Cold Taiga M", MinecraftBiomeTemplates.ColdTaigaMountains.class),
    MEGA_SPRUCE_TAIGA(160, "Mega Spruce Taiga", MinecraftBiomeTemplates.MegaSpruceTaiga.class),
    EXTREME_HILLS_PLUS_MOUNTAINS(162, "Extreme Hills+ M", MinecraftBiomeTemplates.ExtremeHillsPlusMountains.class),
    SAVANNA_MOUNTAINS(163, "Savanna M", MinecraftBiomeTemplates.SavannaMountains.class),
    SAVANNA_PLATEAU_MOUNTAINS(164, "Savanna Plateau M", MinecraftBiomeTemplates.SavannaPlateauMountains.class),
    MESA_BRYCE(165, "Mesa (Bryce)", MinecraftBiomeTemplates.MesaBryce.class),
    MESA_PLATEAU_FOREST_MOUNTAINS(166, "Mesa Plateau F M", MinecraftBiomeTemplates.MesaPlateauForestMountains.class),
    MESA_PLATEAU_MOUNTAINS(167, "Mesa Plateau M", MinecraftBiomeTemplates.MesaPlateauMountains.class);

    public final int Id;
    public final String Name;
    private final Class<? extends MinecraftBiomeTemplates.MinecraftBiomeTemplate> defaultSettingsClass;
    private static DefaultBiome[] lookupID;

    private DefaultBiome(int i, String name, Class<? extends MinecraftBiomeTemplates.MinecraftBiomeTemplate> defaultSettings) {
        this.Id = i;
        this.Name = name;
        this.defaultSettingsClass = defaultSettings;
    }

    public static DefaultBiome getBiome(int id) {
        if (id < lookupID.length) {
            return lookupID[id];
        }
        return null;
    }

    public BiomeLoadInstruction getLoadInstructions(MojangSettings mojangSettings, int maxWorldHeight) {
        try {
            StandardBiomeTemplate template = (StandardBiomeTemplate)this.defaultSettingsClass.getConstructors()[0].newInstance(mojangSettings, maxWorldHeight);
            return new BiomeLoadInstruction(this.Name, this.Id, template);
        }
        catch (Exception e) {
            TerrainControl.log(LogMarker.FATAL, "Failed to create default biome", new Object[0]);
            TerrainControl.printStackTrace(LogMarker.FATAL, e);
            return new BiomeLoadInstruction(this.Name, this.Id, new StandardBiomeTemplate(maxWorldHeight));
        }
    }

    public static boolean Contain(String name) {
        for (DefaultBiome biome : DefaultBiome.values()) {
            if (!biome.Name.equals(name)) continue;
            return true;
        }
        return false;
    }

    public static Integer getId(String name) {
        for (DefaultBiome biome : DefaultBiome.values()) {
            if (!biome.Name.equals(name)) continue;
            return biome.Id;
        }
        return null;
    }

    static {
        lookupID = new DefaultBiome[256];
        DefaultBiome[] arr$ = DefaultBiome.values();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            DefaultBiome biome;
            DefaultBiome.lookupID[biome.Id] = biome = arr$[i$];
        }
    }
}

