/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.util;

import com.khorn.terraincontrol.LocalMaterialData;
import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.exception.InvalidConfigException;
import com.khorn.terraincontrol.util.MaterialSetEntry;
import com.khorn.terraincontrol.util.helpers.StringHelper;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;

public class MaterialSet {
    private static String ALL_MATERIALS = "All";
    private static String SOLID_MATERIALS = "Solid";
    private boolean allSolidMaterials = false;
    private boolean allMaterials = false;
    private int[] materialIntSet = new int[0];
    private Set<MaterialSetEntry> materials = new LinkedHashSet<MaterialSetEntry>();
    private boolean intSetUpToDate = true;

    public void parseAndAdd(String input) throws InvalidConfigException {
        if (input.equalsIgnoreCase(ALL_MATERIALS)) {
            this.allMaterials = true;
            return;
        }
        if (input.equalsIgnoreCase(SOLID_MATERIALS)) {
            this.allSolidMaterials = true;
            return;
        }
        LocalMaterialData material = TerrainControl.readMaterial(input);
        boolean checkIncludesBlockData = StringHelper.specifiesBlockData(input);
        this.add(new MaterialSetEntry(material, checkIncludesBlockData));
    }

    public void add(MaterialSetEntry entry) {
        this.intSetUpToDate = false;
        this.materials.add(entry);
    }

    private void updateIntSet() {
        if (this.intSetUpToDate) {
            return;
        }
        this.materialIntSet = new int[this.materials.size()];
        int i = 0;
        for (MaterialSetEntry entry : this.materials) {
            this.materialIntSet[i] = entry.hashCode();
            ++i;
        }
        Arrays.sort(this.materialIntSet);
        this.intSetUpToDate = true;
    }

    public boolean contains(LocalMaterialData material) {
        if (material == null) {
            return false;
        }
        if (this.allMaterials && !material.isAir()) {
            return true;
        }
        if (this.allSolidMaterials && material.isSolid()) {
            return true;
        }
        this.updateIntSet();
        if (Arrays.binarySearch(this.materialIntSet, material.hashCodeWithoutBlockData()) >= 0) {
            return true;
        }
        return Arrays.binarySearch(this.materialIntSet, material.hashCode()) >= 0;
    }

    public String toString() {
        if (this.allMaterials) {
            return ALL_MATERIALS;
        }
        StringBuilder builder = new StringBuilder();
        if (this.allSolidMaterials) {
            builder.append(SOLID_MATERIALS).append(',');
        }
        for (MaterialSetEntry material : this.materials) {
            builder.append(material.toString()).append(',');
        }
        if (builder.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    public MaterialSet rotate() {
        MaterialSet rotated = new MaterialSet();
        if (this.allMaterials) {
            rotated.allMaterials = true;
        }
        if (this.allSolidMaterials) {
            rotated.allSolidMaterials = true;
        }
        rotated.intSetUpToDate = false;
        for (MaterialSetEntry material : this.materials) {
            rotated.materials.add(material.rotate());
        }
        return rotated;
    }
}

