/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.generator.resource;

import com.khorn.terraincontrol.LocalMaterialData;
import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.exception.InvalidConfigException;
import com.khorn.terraincontrol.generator.resource.Resource;
import com.khorn.terraincontrol.logging.LogMarker;
import com.khorn.terraincontrol.util.minecraftTypes.DefaultMaterial;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class SmallLakeGen
extends Resource {
    private final boolean[] BooleanBuffer = new boolean[2048];
    public int minAltitude;
    public int maxAltitude;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void spawn(LocalWorld world, Random rand, boolean villageInChunk, int x, int z) {
        int y;
        if (villageInChunk) {
            return;
        }
        x -= 8;
        z -= 8;
        for (y = rand.nextInt(this.maxAltitude - this.minAltitude) + this.minAltitude; y > 5 && world.isEmpty(x, y, z); --y) {
        }
        if (y <= 4) {
            return;
        }
        y -= 4;
        boolean[] blArray = this.BooleanBuffer;
        synchronized (this.BooleanBuffer) {
            int i1;
            int j;
            LocalMaterialData air = TerrainControl.toLocalMaterialData(DefaultMaterial.AIR, 0);
            boolean[] BooleanBuffer = new boolean[2048];
            int i = rand.nextInt(4) + 4;
            for (int j2 = 0; j2 < i; ++j2) {
                double d1 = rand.nextDouble() * 6.0 + 3.0;
                double d2 = rand.nextDouble() * 4.0 + 2.0;
                double d3 = rand.nextDouble() * 6.0 + 3.0;
                double d4 = rand.nextDouble() * (16.0 - d1 - 2.0) + 1.0 + d1 / 2.0;
                double d5 = rand.nextDouble() * (8.0 - d2 - 4.0) + 2.0 + d2 / 2.0;
                double d6 = rand.nextDouble() * (16.0 - d3 - 2.0) + 1.0 + d3 / 2.0;
                for (int k = 1; k < 15; ++k) {
                    for (int m = 1; m < 15; ++m) {
                        for (int n = 1; n < 7; ++n) {
                            double d7 = ((double)k - d4) / (d1 / 2.0);
                            double d8 = ((double)n - d5) / (d2 / 2.0);
                            double d9 = ((double)m - d6) / (d3 / 2.0);
                            double d10 = d7 * d7 + d8 * d8 + d9 * d9;
                            if (d10 >= 1.0) continue;
                            BooleanBuffer[(k * 16 + m) * 8 + n] = true;
                        }
                    }
                }
            }
            for (j = 0; j < 16; ++j) {
                for (i1 = 0; i1 < 16; ++i1) {
                    for (int i2 = 0; i2 < 8; ++i2) {
                        boolean flag;
                        boolean bl = flag = !BooleanBuffer[(j * 16 + i1) * 8 + i2] && (j < 15 && BooleanBuffer[((j + 1) * 16 + i1) * 8 + i2] || j > 0 && BooleanBuffer[((j - 1) * 16 + i1) * 8 + i2] || i1 < 15 && BooleanBuffer[(j * 16 + (i1 + 1)) * 8 + i2] || i1 > 0 && BooleanBuffer[(j * 16 + (i1 - 1)) * 8 + i2] || i2 < 7 && BooleanBuffer[(j * 16 + i1) * 8 + (i2 + 1)] || i2 > 0 && BooleanBuffer[(j * 16 + i1) * 8 + (i2 - 1)]);
                        if (!flag) continue;
                        LocalMaterialData localMaterialData = world.getMaterial(x + j, y + i2, z + i1);
                        if (i2 >= 4 && localMaterialData.isLiquid()) {
                            // ** MonitorExit[var7_7] (shouldn't be in output)
                            return;
                        }
                        if (i2 >= 4 || localMaterialData.isSolid() || world.getMaterial(x + j, y + i2, z + i1).equals(this.material)) continue;
                        // ** MonitorExit[var7_7] (shouldn't be in output)
                        return;
                    }
                }
            }
            for (j = 0; j < 16; ++j) {
                for (i1 = 0; i1 < 16; ++i1) {
                    int i2;
                    for (i2 = 0; i2 < 4; ++i2) {
                        if (!BooleanBuffer[(j * 16 + i1) * 8 + i2]) continue;
                        world.setBlock(x + j, y + i2, z + i1, this.material);
                        BooleanBuffer[(j * 16 + i1) * 8 + i2] = false;
                    }
                    for (i2 = 4; i2 < 8; ++i2) {
                        if (!BooleanBuffer[(j * 16 + i1) * 8 + i2]) continue;
                        world.setBlock(x + j, y + i2, z + i1, air);
                        BooleanBuffer[(j * 16 + i1) * 8 + i2] = false;
                    }
                }
            }
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void load(List<String> args) throws InvalidConfigException {
        this.assureSize(5, args);
        this.material = this.readMaterial(args.get(0));
        this.frequency = this.readInt(args.get(1), 1, 100);
        this.rarity = this.readRarity(args.get(2));
        this.minAltitude = this.readInt(args.get(3), 0, 256);
        this.maxAltitude = this.readInt(args.get(4), this.minAltitude + 1, 256);
    }

    @Override
    public String makeString() {
        return "SmallLake(" + this.material + "," + this.frequency + "," + this.rarity + "," + this.minAltitude + "," + this.maxAltitude + ")";
    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = 41 * hash + super.hashCode();
        hash = 41 * hash + Arrays.hashCode(this.BooleanBuffer);
        hash = 41 * hash + this.minAltitude;
        hash = 41 * hash + this.maxAltitude;
        return hash;
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        SmallLakeGen compare = (SmallLakeGen)other;
        TerrainControl.log(LogMarker.DEBUG, "Equals::{}", this.minAltitude == compare.minAltitude && this.maxAltitude == compare.maxAltitude && Arrays.equals(this.BooleanBuffer, compare.BooleanBuffer));
        return this.minAltitude == compare.minAltitude && this.maxAltitude == compare.maxAltitude && Arrays.equals(this.BooleanBuffer, compare.BooleanBuffer);
    }
}

