/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.generator.resource;

import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.exception.InvalidConfigException;
import com.khorn.terraincontrol.generator.resource.Resource;
import java.util.List;
import java.util.Random;

public class AboveWaterGen
extends Resource {
    @Override
    public void load(List<String> args) throws InvalidConfigException {
        this.assureSize(3, args);
        this.material = this.readMaterial(args.get(0));
        this.frequency = this.readInt(args.get(1), 1, 100);
        this.rarity = this.readRarity(args.get(2));
    }

    @Override
    public void spawn(LocalWorld world, Random rand, boolean villageInChunk, int x, int z) {
        int y = world.getLiquidHeight(x, z);
        if (y == -1) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            int m;
            int j = x + rand.nextInt(8) - rand.nextInt(8);
            if (!world.isEmpty(j, y, m = z + rand.nextInt(8) - rand.nextInt(8)) || !world.getMaterial(j, y - 1, m).isLiquid()) continue;
            world.setBlock(j, y, m, this.material);
        }
    }

    @Override
    public String makeString() {
        return "AboveWaterRes(" + this.material + "," + this.frequency + "," + this.rarity + ")";
    }
}

