/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.forge.generator;

import com.khorn.terraincontrol.configuration.ConfigProvider;
import com.khorn.terraincontrol.configuration.WorldConfig;
import com.khorn.terraincontrol.forge.ForgeWorld;
import com.khorn.terraincontrol.forge.generator.ForgeChunkBuffer;
import com.khorn.terraincontrol.generator.ChunkProviderTC;
import com.khorn.terraincontrol.generator.ObjectSpawner;
import com.khorn.terraincontrol.generator.biome.OutputType;
import com.khorn.terraincontrol.util.ChunkCoordinate;
import java.util.List;
import net.minecraft.block.BlockSand;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;

public class ChunkProvider
implements IChunkProvider {
    private ForgeWorld world;
    private World worldHandle;
    private boolean TestMode = false;
    private ChunkProviderTC generator;
    private ObjectSpawner spawner;
    private int[] biomeIntArray;

    public ChunkProvider(ForgeWorld _world) {
        this.world = _world;
        this.worldHandle = _world.getWorld();
        this.TestMode = this.world.getConfigs().getWorldConfig().ModeTerrain == WorldConfig.TerrainMode.TerrainTest;
        this.generator = new ChunkProviderTC(this.world.getConfigs(), this.world);
        this.spawner = new ObjectSpawner(this.world.getConfigs(), this.world);
    }

    public boolean func_73149_a(int i, int i1) {
        return true;
    }

    public Chunk func_73154_d(int chunkX, int chunkZ) {
        ChunkCoordinate chunkCoord = ChunkCoordinate.fromChunkCoords(chunkX, chunkZ);
        ForgeChunkBuffer chunkBuffer = new ForgeChunkBuffer(chunkCoord);
        this.generator.generate(chunkBuffer);
        Chunk chunk = chunkBuffer.toChunk(this.worldHandle);
        this.fillBiomeArray(chunk);
        chunk.func_76603_b();
        return chunk;
    }

    private void fillBiomeArray(Chunk chunk) {
        byte[] chunkBiomeArray = chunk.func_76605_m();
        ConfigProvider configProvider = this.world.getConfigs();
        this.biomeIntArray = this.world.getBiomeGenerator().getBiomes(this.biomeIntArray, chunk.field_76635_g * 16, chunk.field_76647_h * 16, 16, 16, OutputType.DEFAULT_FOR_WORLD);
        for (int i = 0; i < chunkBiomeArray.length; ++i) {
            int generationId = this.biomeIntArray[i];
            chunkBiomeArray[i] = (byte)configProvider.getBiomeByIdOrNull(generationId).getIds().getSavedId();
        }
    }

    public Chunk func_73158_c(int i, int i1) {
        return this.func_73154_d(i, i1);
    }

    public void func_73153_a(IChunkProvider ChunkProvider2, int x, int z) {
        if (this.TestMode) {
            return;
        }
        BlockSand.field_149832_M = true;
        this.spawner.populate(ChunkCoordinate.fromChunkCoords(x, z));
        BlockSand.field_149832_M = false;
    }

    public boolean func_73151_a(boolean b, IProgressUpdate il) {
        return true;
    }

    public boolean func_73156_b() {
        return false;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "TerrainControlLevelSource";
    }

    public List<?> func_73155_a(EnumCreatureType paramaca, int paramInt1, int paramInt2, int paramInt3) {
        BiomeGenBase Biome = this.worldHandle.func_72807_a(paramInt1, paramInt3);
        if (Biome == null) {
            return null;
        }
        return Biome.func_76747_a(paramaca);
    }

    public ChunkPosition func_147416_a(World world, String s, int x, int y, int z) {
        if ("Stronghold".equals(s) && this.world.strongholdGen != null) {
            return this.world.strongholdGen.func_151545_a(world, x, y, z);
        }
        return null;
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_82695_e(int chunkX, int chunkZ) {
        if (this.world.mineshaftGen != null) {
            this.world.mineshaftGen.func_151539_a(this, this.world.getWorld(), chunkX, chunkZ, null);
        }
        if (this.world.villageGen != null) {
            this.world.villageGen.func_151539_a(this, this.world.getWorld(), chunkX, chunkZ, null);
        }
        if (this.world.strongholdGen != null) {
            this.world.strongholdGen.func_151539_a(this, this.world.getWorld(), chunkX, chunkZ, null);
        }
        if (this.world.rareBuildingGen != null) {
            this.world.rareBuildingGen.func_151539_a(this, this.world.getWorld(), chunkX, chunkZ, null);
        }
        if (this.world.netherFortressGen != null) {
            this.world.netherFortressGen.func_151539_a(this, this.world.getWorld(), chunkX, chunkZ, null);
        }
    }

    public void func_104112_b() {
    }
}

