/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.forge;

import com.khorn.terraincontrol.BiomeIds;
import com.khorn.terraincontrol.LocalBiome;
import com.khorn.terraincontrol.configuration.BiomeConfig;
import com.khorn.terraincontrol.forge.generator.BiomeGenCustom;
import net.minecraft.world.biome.BiomeGenBase;

public class ForgeBiome
implements LocalBiome {
    private final BiomeGenCustom biomeBase;
    private final BiomeIds biomeIds;
    private final BiomeConfig biomeConfig;

    public static ForgeBiome createBiome(BiomeConfig biomeConfig, BiomeIds biomeIds) {
        BiomeGenBase previousBiome = BiomeGenBase.func_150568_d((int)biomeIds.getSavedId());
        BiomeGenCustom custom = new BiomeGenCustom(biomeConfig.getName(), biomeIds);
        custom.field_76790_z = biomeConfig.biomeColor;
        ForgeBiome biome = new ForgeBiome(biomeConfig, custom);
        if (previousBiome != null) {
            biome.biomeBase.copyBiome(previousBiome);
        }
        return biome;
    }

    private ForgeBiome(BiomeConfig biomeConfig, BiomeGenCustom biome) {
        this.biomeBase = biome;
        this.biomeIds = new BiomeIds(biome.generationId, biome.field_76756_M);
        this.biomeConfig = biomeConfig;
    }

    @Override
    public boolean isCustom() {
        return true;
    }

    @Override
    public void setEffects() {
        this.biomeBase.setEffects(this.biomeConfig);
    }

    @Override
    public String getName() {
        return this.biomeBase.field_76791_y;
    }

    public BiomeGenCustom getHandle() {
        return this.biomeBase;
    }

    @Override
    public BiomeIds getIds() {
        return this.biomeIds;
    }

    @Override
    public float getTemperatureAt(int x, int y, int z) {
        return this.biomeBase.func_150564_a(x, y, z);
    }

    @Override
    public BiomeConfig getBiomeConfig() {
        return this.biomeConfig;
    }

    public String toString() {
        return this.getName() + "[" + this.biomeIds + "]";
    }
}

