/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.customobjects.bo3;

import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.configuration.ConfigFunction;
import com.khorn.terraincontrol.customobjects.Branch;
import com.khorn.terraincontrol.customobjects.CustomObject;
import com.khorn.terraincontrol.customobjects.CustomObjectCoordinate;
import com.khorn.terraincontrol.customobjects.bo3.BO3Config;
import com.khorn.terraincontrol.customobjects.bo3.BO3Function;
import com.khorn.terraincontrol.customobjects.bo3.BranchNode;
import com.khorn.terraincontrol.exception.InvalidConfigException;
import com.khorn.terraincontrol.logging.LogMarker;
import com.khorn.terraincontrol.util.Rotation;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.SortedSet;
import java.util.TreeSet;

public class BranchFunction
extends BO3Function
implements Branch {
    public int x;
    public int y;
    public int z;
    public SortedSet<BranchNode> branches;
    public double totalChance = -1.0;

    @Override
    public BranchFunction rotate() {
        BranchFunction rotatedBranch = new BranchFunction();
        rotatedBranch.x = this.z;
        rotatedBranch.y = this.y;
        rotatedBranch.z = -this.x;
        rotatedBranch.branches = new TreeSet<BranchNode>();
        for (BranchNode holder : this.branches) {
            rotatedBranch.branches.add(new BranchNode(holder.getRotation().next(), holder.getChance(), holder.getCustomObject()));
        }
        return rotatedBranch;
    }

    @Override
    public void load(List<String> args) throws InvalidConfigException {
        this.branches = new TreeSet<BranchNode>();
        this.readArgs(args, false);
    }

    @Override
    public String makeString() {
        StringBuilder output = new StringBuilder(this.getConfigName()).append('(').append(this.x).append(',').append(this.y).append(',').append(this.z);
        Iterator it = this.branches.iterator();
        while (it.hasNext()) {
            output.append(((BranchNode)it.next()).toBranchString());
        }
        if (this.totalChance != -1.0) {
            output.append(',').append(this.totalChance);
        }
        return output.append(')').toString();
    }

    @Override
    public CustomObjectCoordinate toCustomObjectCoordinate(LocalWorld world, Random random, int x, int y, int z) {
        TerrainControl.log(LogMarker.TRACE, "Branch:", new Object[0]);
        for (BranchNode branch : this.branches) {
            double randomChance = random.nextDouble() * (this.totalChance != -1.0 ? this.totalChance : 100.0);
            TerrainControl.log(LogMarker.TRACE, "  Needed: {} Obtained: {}", branch.getChance(), randomChance);
            if (!(randomChance < branch.getChance())) continue;
            TerrainControl.log(LogMarker.TRACE, "  Successful Spawn", new Object[0]);
            return new CustomObjectCoordinate(branch.getCustomObject(), branch.getRotation(), x + this.x, y + this.y, z + this.z);
        }
        TerrainControl.log(LogMarker.TRACE, "  No Spawn", new Object[0]);
        return null;
    }

    protected String getConfigName() {
        return "Branch";
    }

    protected double readArgs(List<String> args, boolean accumulateChances) throws InvalidConfigException {
        int i;
        this.assureSize(6, args);
        this.x = this.readInt(args.get(0), -32, 32);
        this.y = this.readInt(args.get(1), -64, 64);
        this.z = this.readInt(args.get(2), -32, 32);
        double cumulativeChance = 0.0;
        for (i = 3; i < args.size() - 2; i += 3) {
            CustomObject object = ((BO3Config)this.getHolder()).otherObjectsInDirectory.get(args.get(i).toLowerCase());
            if (object == null) {
                throw new InvalidConfigException("The " + this.getConfigName() + " `" + args.get(i) + "` was not found. Make sure to place it in the same directory.");
            }
            TerrainControl.log(LogMarker.TRACE, "{} Initialized", object.getName());
            double branchChance = this.readDouble(args.get(i + 2), 0.0, Double.MAX_VALUE);
            if (accumulateChances) {
                this.branches.add(new BranchNode(Rotation.getRotation(args.get(i + 1)), cumulativeChance += branchChance, object));
                continue;
            }
            this.branches.add(new BranchNode(Rotation.getRotation(args.get(i + 1)), branchChance, object));
        }
        TerrainControl.log(LogMarker.TRACE, "{}:{}", args.size(), i);
        if (i < args.size()) {
            TerrainControl.log(LogMarker.TRACE, "{} TotalChance set.", this.getConfigName());
            this.totalChance = this.readDouble(args.get(i), 0.0, Double.MAX_VALUE);
        }
        return cumulativeChance;
    }

    @Override
    public boolean isAnalogousTo(ConfigFunction<BO3Config> other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        BranchFunction branch = (BranchFunction)other;
        return branch.x == this.x && branch.y == this.y && branch.z == this.z;
    }
}

