/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.customobjects.bo2;

import com.khorn.terraincontrol.LocalBiome;
import com.khorn.terraincontrol.LocalMaterialData;
import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.configuration.ConfigFile;
import com.khorn.terraincontrol.configuration.io.SettingsReader;
import com.khorn.terraincontrol.configuration.io.SettingsWriter;
import com.khorn.terraincontrol.customobjects.CustomObject;
import com.khorn.terraincontrol.customobjects.bo2.BO2Settings;
import com.khorn.terraincontrol.customobjects.bo2.ObjectCoordinate;
import com.khorn.terraincontrol.util.ChunkCoordinate;
import com.khorn.terraincontrol.util.MaterialSet;
import com.khorn.terraincontrol.util.Rotation;
import com.khorn.terraincontrol.util.minecraftTypes.DefaultMaterial;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class BO2
extends ConfigFile
implements CustomObject {
    public ObjectCoordinate[][] data = new ObjectCoordinate[4][];
    public BO2[] groupObjects = null;
    public List<String> spawnInBiome;
    public String version;
    public MaterialSet spawnOnBlockType;
    public MaterialSet collisionBlockType;
    public boolean spawnWater;
    public boolean spawnLava;
    public boolean spawnAboveGround;
    public boolean spawnUnderGround;
    public boolean spawnSunlight;
    public boolean spawnDarkness;
    public boolean underFill;
    public boolean randomRotation;
    public boolean dig;
    public boolean tree;
    public boolean branch;
    public boolean diggingBranch;
    public boolean needsFoundation;
    public int rarity;
    public double collisionPercentage;
    public int spawnElevationMin;
    public int spawnElevationMax;
    public int groupFrequencyMin;
    public int groupFrequencyMax;
    public int groupSeparationMin;
    public int groupSeparationMax;
    public List<String> groupId;
    public int branchLimit;

    public BO2(SettingsReader reader) {
        super(reader);
    }

    @Override
    public void onEnable(Map<String, CustomObject> otherObjectsInDirectory) {
        this.enable();
    }

    private void enable() {
        this.readConfigSettings();
        this.correctSettings();
    }

    @Override
    public boolean canSpawnAsTree() {
        return this.tree;
    }

    @Override
    public boolean canSpawnAsObject() {
        return true;
    }

    @Override
    public boolean canRotateRandomly() {
        return this.randomRotation;
    }

    @Override
    public boolean spawnForced(LocalWorld world, Random random, Rotation rotation, int x, int y, int z) {
        ObjectCoordinate[] data;
        for (ObjectCoordinate point : data = this.data[rotation.getRotationId()]) {
            if (world.isEmpty(x + point.x, y + point.y, z + point.z)) {
                world.setBlock(x + point.x, y + point.y, z + point.z, point.material);
                continue;
            }
            if (!this.dig) continue;
            world.setBlock(x + point.x, y + point.y, z + point.z, point.material);
        }
        return true;
    }

    @Override
    public boolean canSpawnAt(LocalWorld world, Rotation rotation, int x, int y, int z) {
        if (world.isEmpty(x, y - 5, z) && this.needsFoundation) {
            return false;
        }
        LocalMaterialData checkBlock = world.getMaterial(x, y + 2, z);
        if (!this.spawnWater && (checkBlock.equals((Object)DefaultMaterial.WATER) || checkBlock.equals((Object)DefaultMaterial.STATIONARY_WATER))) {
            return false;
        }
        if (!this.spawnLava && (checkBlock.equals((Object)DefaultMaterial.LAVA) || checkBlock.equals((Object)DefaultMaterial.STATIONARY_LAVA))) {
            return false;
        }
        int checkLight = world.getLightLevel(x, y + 2, z);
        if (!this.spawnSunlight && checkLight > 8) {
            return false;
        }
        if (!this.spawnDarkness && checkLight < 9) {
            return false;
        }
        if (y < this.spawnElevationMin || y > this.spawnElevationMax) {
            return false;
        }
        if (!this.spawnOnBlockType.contains(world.getMaterial(x, y - 1, z))) {
            return false;
        }
        ObjectCoordinate[] objData = this.data[rotation.getRotationId()];
        int faultCounter = 0;
        for (ObjectCoordinate point : objData) {
            if (!world.isLoaded(x + point.x, y + point.y, z + point.z)) {
                return false;
            }
            if (this.dig || !this.collisionBlockType.contains(world.getMaterial(x + point.x, y + point.y, z + point.z)) || !((double)(++faultCounter) > (double)objData.length * (this.collisionPercentage / 100.0))) continue;
            return false;
        }
        return TerrainControl.fireCanCustomObjectSpawnEvent(this, world, x, y, z);
    }

    protected boolean spawn(LocalWorld world, Random random, int x, int z) {
        Rotation rotation;
        int y;
        if (this.spawnAboveGround) {
            y = world.getSolidHeight(x, z);
        } else if (this.spawnUnderGround) {
            int solidHeight = world.getSolidHeight(x, z);
            if (solidHeight < 1 || solidHeight <= this.spawnElevationMin) {
                return false;
            }
            if (solidHeight > this.spawnElevationMax) {
                solidHeight = this.spawnElevationMax;
            }
            y = random.nextInt(solidHeight - this.spawnElevationMin) + this.spawnElevationMin;
        } else {
            y = world.getHighestBlockYAt(x, z);
        }
        if (y < 0) {
            return false;
        }
        Rotation rotation2 = rotation = this.randomRotation ? Rotation.getRandomRotation(random) : Rotation.NORTH;
        if (!this.canSpawnAt(world, rotation, x, y, z)) {
            return false;
        }
        boolean objectSpawned = this.spawnForced(world, random, rotation, x, y, z);
        return objectSpawned;
    }

    @Override
    public boolean spawnAsTree(LocalWorld world, Random random, int x, int z) {
        return this.spawn(world, random, x, z);
    }

    @Override
    public boolean process(LocalWorld world, Random rand, ChunkCoordinate chunkCoord) {
        if (this.branch) {
            return false;
        }
        int randomRoll = rand.nextInt(100);
        boolean objectSpawned = false;
        for (int ObjectRarity = this.rarity; randomRoll < ObjectRarity; ObjectRarity -= 100) {
            int x = chunkCoord.getBlockX() + rand.nextInt(16);
            int z = chunkCoord.getBlockZ() + rand.nextInt(16);
            objectSpawned = this.spawn(world, rand, x, z);
        }
        return objectSpawned;
    }

    @Override
    public CustomObject applySettings(SettingsReader extraSettings) {
        extraSettings.setFallbackReader(this.reader);
        BO2 bo2WithSettings = new BO2(extraSettings);
        bo2WithSettings.enable();
        return bo2WithSettings;
    }

    @Override
    protected void writeConfigSettings(SettingsWriter writer) throws IOException {
    }

    @Override
    protected void readConfigSettings() {
        this.version = this.readSettings(BO2Settings.VERSION);
        this.spawnOnBlockType = this.readSettings(BO2Settings.SPAWN_ON_BLOCK_TYPE);
        this.collisionBlockType = this.readSettings(BO2Settings.COLLISTION_BLOCK_TYPE);
        this.spawnInBiome = this.readSettings(BO2Settings.SPAWN_IN_BIOME);
        this.spawnSunlight = this.readSettings(BO2Settings.SPAWN_SUNLIGHT);
        this.spawnDarkness = this.readSettings(BO2Settings.SPAWN_DARKNESS);
        this.spawnWater = this.readSettings(BO2Settings.SPAWN_WATER);
        this.spawnLava = this.readSettings(BO2Settings.SPAWN_LAVA);
        this.spawnAboveGround = this.readSettings(BO2Settings.SPAWN_ABOVE_GROUND);
        this.spawnUnderGround = this.readSettings(BO2Settings.SPAWN_UNDER_GROUND);
        this.underFill = this.readSettings(BO2Settings.UNDER_FILL);
        this.randomRotation = this.readSettings(BO2Settings.RANDON_ROTATION);
        this.dig = this.readSettings(BO2Settings.DIG);
        this.tree = this.readSettings(BO2Settings.TREE);
        this.branch = this.readSettings(BO2Settings.BRANCH);
        this.diggingBranch = this.readSettings(BO2Settings.DIGGING_BRANCH);
        this.needsFoundation = this.readSettings(BO2Settings.NEEDS_FOUNDATION);
        this.rarity = this.readSettings(BO2Settings.RARITY);
        this.collisionPercentage = this.readSettings(BO2Settings.COLLISION_PERCENTAGE);
        this.spawnElevationMin = this.readSettings(BO2Settings.SPAWN_ELEVATION_MIN);
        this.spawnElevationMax = this.readSettings(BO2Settings.SPAWN_ELEVATION_MAX);
        this.groupFrequencyMin = this.readSettings(BO2Settings.GROUP_FREQUENCY_MIN);
        this.groupFrequencyMax = this.readSettings(BO2Settings.GROUP_FREQUENCY_MAX);
        this.groupSeparationMin = this.readSettings(BO2Settings.GROUP_SEPERATION_MIN);
        this.groupSeparationMax = this.readSettings(BO2Settings.GROUP_SEPERATION_MAX);
        this.groupId = this.readSettings(BO2Settings.GROUP_ID);
        this.branchLimit = this.readSettings(BO2Settings.BRANCH_LIMIT);
        this.ReadCoordinates();
    }

    @Override
    protected void correctSettings() {
    }

    @Override
    protected void renameOldSettings() {
    }

    private void ReadCoordinates() {
        ArrayList<ObjectCoordinate> coordinates = new ArrayList<ObjectCoordinate>();
        for (Map.Entry<String, String> line : this.reader.getRawSettings()) {
            ObjectCoordinate buffer = ObjectCoordinate.getCoordinateFromString(line.getKey(), line.getValue());
            if (buffer == null) continue;
            coordinates.add(buffer);
        }
        this.data[0] = new ObjectCoordinate[coordinates.size()];
        this.data[1] = new ObjectCoordinate[coordinates.size()];
        this.data[2] = new ObjectCoordinate[coordinates.size()];
        this.data[3] = new ObjectCoordinate[coordinates.size()];
        for (int i = 0; i < coordinates.size(); ++i) {
            ObjectCoordinate coordinate;
            this.data[0][i] = coordinate = (ObjectCoordinate)coordinates.get(i);
            this.data[1][i] = coordinate = coordinate.Rotate();
            this.data[2][i] = coordinate = coordinate.Rotate();
            this.data[3][i] = coordinate = coordinate.Rotate();
        }
    }

    @Override
    public boolean hasPreferenceToSpawnIn(LocalBiome biome) {
        return this.spawnInBiome.contains(biome.getName()) || this.spawnInBiome.contains("All");
    }
}

