/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.configuration;

import com.khorn.terraincontrol.configuration.ConfigFunction;
import com.khorn.terraincontrol.configuration.ErroredFunction;
import com.khorn.terraincontrol.exception.InvalidConfigException;
import com.khorn.terraincontrol.generator.resource.AboveWaterGen;
import com.khorn.terraincontrol.generator.resource.BoulderGen;
import com.khorn.terraincontrol.generator.resource.CactusGen;
import com.khorn.terraincontrol.generator.resource.CustomObjectGen;
import com.khorn.terraincontrol.generator.resource.CustomStructureGen;
import com.khorn.terraincontrol.generator.resource.DungeonGen;
import com.khorn.terraincontrol.generator.resource.GrassGen;
import com.khorn.terraincontrol.generator.resource.IceSpikeGen;
import com.khorn.terraincontrol.generator.resource.LiquidGen;
import com.khorn.terraincontrol.generator.resource.OreGen;
import com.khorn.terraincontrol.generator.resource.PlantGen;
import com.khorn.terraincontrol.generator.resource.ReedGen;
import com.khorn.terraincontrol.generator.resource.SaplingGen;
import com.khorn.terraincontrol.generator.resource.SmallLakeGen;
import com.khorn.terraincontrol.generator.resource.TreeGen;
import com.khorn.terraincontrol.generator.resource.UnderWaterOreGen;
import com.khorn.terraincontrol.generator.resource.UndergroundLakeGen;
import com.khorn.terraincontrol.generator.resource.VeinGen;
import com.khorn.terraincontrol.generator.resource.VinesGen;
import com.khorn.terraincontrol.generator.resource.WellGen;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConfigFunctionsManager {
    private Map<String, Class<? extends ConfigFunction<?>>> configFunctions = new HashMap();

    public ConfigFunctionsManager() {
        this.registerConfigFunction("AboveWaterRes", AboveWaterGen.class);
        this.registerConfigFunction("Boulder", BoulderGen.class);
        this.registerConfigFunction("Cactus", CactusGen.class);
        this.registerConfigFunction("CustomObject", CustomObjectGen.class);
        this.registerConfigFunction("CustomStructure", CustomStructureGen.class);
        this.registerConfigFunction("Dungeon", DungeonGen.class);
        this.registerConfigFunction("Grass", GrassGen.class);
        this.registerConfigFunction("IceSpike", IceSpikeGen.class);
        this.registerConfigFunction("Liquid", LiquidGen.class);
        this.registerConfigFunction("Ore", OreGen.class);
        this.registerConfigFunction("Plant", PlantGen.class);
        this.registerConfigFunction("Reed", ReedGen.class);
        this.registerConfigFunction("Sapling", SaplingGen.class);
        this.registerConfigFunction("SmallLake", SmallLakeGen.class);
        this.registerConfigFunction("Tree", TreeGen.class);
        this.registerConfigFunction("UndergroundLake", UndergroundLakeGen.class);
        this.registerConfigFunction("UnderWaterOre", UnderWaterOreGen.class);
        this.registerConfigFunction("Vein", VeinGen.class);
        this.registerConfigFunction("Vines", VinesGen.class);
        this.registerConfigFunction("Well", WellGen.class);
    }

    public void registerConfigFunction(String name, Class<? extends ConfigFunction<?>> value) {
        this.configFunctions.put(name.toLowerCase(), value);
    }

    public <T> ConfigFunction<T> getConfigFunction(String name, T holder, List<String> args) {
        ConfigFunction<?> configFunction;
        Class<ConfigFunction<?>> clazz = this.configFunctions.get(name.toLowerCase());
        if (clazz == null) {
            return new ErroredFunction<T>(name, holder, args, "Resource type " + name + " not found");
        }
        try {
            configFunction = clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Reflection error while loading the resources: ", e);
        }
        boolean matchingTypes = holder.getClass().isAssignableFrom(configFunction.getHolderType());
        if (!matchingTypes) {
            return new ErroredFunction<T>(name, holder, args, "Resource " + name + " cannot be placed in this config file");
        }
        try {
            configFunction.init(holder, args);
        }
        catch (InvalidConfigException e) {
            configFunction.invalidate(name, args, e.getMessage());
        }
        return configFunction;
    }
}

