/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol;

import com.khorn.terraincontrol.LocalMaterialData;
import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.configuration.ConfigFunctionsManager;
import com.khorn.terraincontrol.configuration.PluginConfig;
import com.khorn.terraincontrol.configuration.io.FileSettingsReader;
import com.khorn.terraincontrol.configuration.io.FileSettingsWriter;
import com.khorn.terraincontrol.customobjects.CustomObject;
import com.khorn.terraincontrol.customobjects.CustomObjectManager;
import com.khorn.terraincontrol.events.EventHandler;
import com.khorn.terraincontrol.events.EventPriority;
import com.khorn.terraincontrol.exception.InvalidConfigException;
import com.khorn.terraincontrol.generator.biome.BiomeModeManager;
import com.khorn.terraincontrol.generator.resource.Resource;
import com.khorn.terraincontrol.logging.LogFactory;
import com.khorn.terraincontrol.logging.Logger;
import com.khorn.terraincontrol.util.ChunkCoordinate;
import com.khorn.terraincontrol.util.minecraftTypes.DefaultMaterial;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public abstract class TerrainControlEngine {
    private BiomeModeManager biomeManagers;
    private List<EventHandler> cancelableEventHandlers = new ArrayList<EventHandler>(5);
    private ConfigFunctionsManager configFunctionsManager;
    private CustomObjectManager customObjectManager;
    private List<EventHandler> monitoringEventHandlers = new ArrayList<EventHandler>(5);
    private PluginConfig pluginConfig;
    private Logger logger;

    public TerrainControlEngine() {
        this.logger = LogFactory.getLogger();
    }

    public TerrainControlEngine(org.apache.logging.log4j.Logger log4jLogger) {
        this.logger = LogFactory.getLogger(log4jLogger);
    }

    public boolean fireCanCustomObjectSpawnEvent(CustomObject object, LocalWorld world, int x, int y, int z) {
        boolean success = true;
        for (EventHandler handler : this.cancelableEventHandlers) {
            if (handler.canCustomObjectSpawn(object, world, x, y, z, !success)) continue;
            success = false;
        }
        for (EventHandler handler : this.monitoringEventHandlers) {
            handler.canCustomObjectSpawn(object, world, x, y, z, !success);
        }
        return success;
    }

    public void firePopulationEndEvent(LocalWorld world, Random random, boolean villageInChunk, ChunkCoordinate chunkCoord) {
        for (EventHandler handler : this.cancelableEventHandlers) {
            handler.onPopulateEnd(world, random, villageInChunk, chunkCoord.getChunkX(), chunkCoord.getChunkZ());
        }
        for (EventHandler handler : this.monitoringEventHandlers) {
            handler.onPopulateEnd(world, random, villageInChunk, chunkCoord.getChunkX(), chunkCoord.getChunkZ());
        }
    }

    public void firePopulationStartEvent(LocalWorld world, Random random, boolean villageInChunk, ChunkCoordinate chunkCoord) {
        for (EventHandler handler : this.cancelableEventHandlers) {
            handler.onPopulateStart(world, random, villageInChunk, chunkCoord.getChunkX(), chunkCoord.getChunkZ());
        }
        for (EventHandler handler : this.monitoringEventHandlers) {
            handler.onPopulateStart(world, random, villageInChunk, chunkCoord.getChunkX(), chunkCoord.getChunkZ());
        }
    }

    public boolean fireResourceProcessEvent(Resource resource, LocalWorld world, Random random, boolean villageInChunk, int chunkX, int chunkZ) {
        boolean success = true;
        for (EventHandler handler : this.cancelableEventHandlers) {
            if (handler.onResourceProcess(resource, world, random, villageInChunk, chunkX, chunkZ, !success)) continue;
            success = false;
        }
        for (EventHandler handler : this.monitoringEventHandlers) {
            handler.onResourceProcess(resource, world, random, villageInChunk, chunkX, chunkZ, !success);
        }
        return success;
    }

    public BiomeModeManager getBiomeModeManager() {
        return this.biomeManagers;
    }

    public ConfigFunctionsManager getConfigFunctionsManager() {
        return this.configFunctionsManager;
    }

    public CustomObjectManager getCustomObjectManager() {
        return this.customObjectManager;
    }

    public abstract File getGlobalObjectsDirectory();

    public Logger getLogger() {
        return this.logger;
    }

    public PluginConfig getPluginConfig() {
        return this.pluginConfig;
    }

    public abstract File getTCDataFolder();

    public abstract LocalWorld getWorld(String var1);

    public void onShutdown() {
        this.customObjectManager.shutdown();
        this.customObjectManager = null;
        this.configFunctionsManager = null;
        this.biomeManagers = null;
        this.pluginConfig = null;
        this.cancelableEventHandlers.clear();
        this.monitoringEventHandlers.clear();
        this.cancelableEventHandlers = null;
        this.monitoringEventHandlers = null;
    }

    public void onStart() {
        this.configFunctionsManager = new ConfigFunctionsManager();
        this.customObjectManager = new CustomObjectManager();
        this.biomeManagers = new BiomeModeManager();
        this.pluginConfig = new PluginConfig(new FileSettingsReader("PluginConfig", new File(this.getTCDataFolder(), "TerrainControl.ini")));
        FileSettingsWriter.writeToFile(this.pluginConfig, this.pluginConfig.SettingsMode);
        this.logger.setLevel(this.pluginConfig.getLogLevel().getLevel());
        for (EventHandler handler : this.cancelableEventHandlers) {
            handler.onStart();
        }
        for (EventHandler handler : this.monitoringEventHandlers) {
            handler.onStart();
        }
        this.customObjectManager.loadGlobalObjects();
    }

    public void registerEventHandler(EventHandler handler) {
        this.cancelableEventHandlers.add(handler);
    }

    public void registerEventHandler(EventHandler handler, EventPriority priority) {
        if (priority == EventPriority.CANCELABLE) {
            this.cancelableEventHandlers.add(handler);
        } else {
            this.monitoringEventHandlers.add(handler);
        }
    }

    public abstract LocalMaterialData readMaterial(String var1) throws InvalidConfigException;

    public abstract LocalMaterialData toLocalMaterialData(DefaultMaterial var1, int var2);
}

