/*
 * Decompiled with CFR 0.152.
 */
package exterminatorJeff.undergroundBiomes.constructs;

import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import exterminatorJeff.undergroundBiomes.api.UndergroundBiomesSettings;
import exterminatorJeff.undergroundBiomes.common.UndergroundBiomes;
import exterminatorJeff.undergroundBiomes.common.block.BlockMetadataBase;
import exterminatorJeff.undergroundBiomes.common.item.SwitchableRecipeGroup;
import exterminatorJeff.undergroundBiomes.constructs.IconTrap;
import exterminatorJeff.undergroundBiomes.constructs.block.UBButtonGroup;
import exterminatorJeff.undergroundBiomes.constructs.block.UBStairsGroup;
import exterminatorJeff.undergroundBiomes.constructs.block.UBWallGroup;
import exterminatorJeff.undergroundBiomes.constructs.entity.UndergroundBiomesTileEntity;
import exterminatorJeff.undergroundBiomes.constructs.util.UndergroundBiomesBlockList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockButtonStone;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockWall;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.config.Configuration;

public class UndergroundBiomesConstructs {
    public static int subdivisionBlockCount = 4;
    private UBStairsGroup stoneStair;
    private UBWallGroup stoneWall;
    private UBButtonGroup stoneButton;
    private BlockMetadataBase iconTrap;
    public Configuration config;
    private UndergroundBiomesBlockList ubBlockList;
    public static String blockCategory = "block";
    public static String itemCategory = "item";
    private SwitchableRecipeGroup stairRecipes;
    private SwitchableRecipeGroup wallRecipes;
    private SwitchableRecipeGroup buttonRecipes;

    private UndergroundBiomesSettings settings() {
        return UndergroundBiomes.instance().settings();
    }

    public int stoneStairID() {
        return this.settings().stoneStairID.value();
    }

    public UBStairsGroup stoneStair() {
        return this.stoneStair;
    }

    public int stoneWallID() {
        return this.settings().stoneWallID.value();
    }

    public UBWallGroup stoneWall() {
        return this.stoneWall;
    }

    public int stoneButtonID() {
        return this.settings().stoneButtonID.value();
    }

    public UBButtonGroup stoneButton() {
        return this.stoneButton;
    }

    public void preInit(Configuration config) {
        this.config = config;
        this.ubBlockList = new UndergroundBiomesBlockList();
        GameRegistry.registerTileEntity(UndergroundBiomesTileEntity.class, (String)"UndergroundBiomesTileEntity");
        this.iconTrap = new IconTrap();
        this.preInitButtons();
        this.preInitStairs();
        this.preInitWalls();
    }

    public void preInitStairs() {
        this.stoneStair = new UBStairsGroup();
        this.stoneStair.baseBlock = this.iconTrap;
        this.stoneStair.define(this.stoneStairID());
    }

    public void preInitWalls() {
        this.stoneWall = new UBWallGroup();
        this.stoneWall.baseBlock = this.ubBlockList.sedimentaryStone;
        this.stoneWall.define(this.stoneWallID());
    }

    public void preInitButtons() {
        this.stoneButton = new UBButtonGroup();
        this.stoneButton.baseBlock = this.ubBlockList.sedimentaryStone;
        this.stoneButton.define(this.stoneButtonID());
    }

    public void load(FMLInitializationEvent event) {
        this.loadButtons();
        this.loadStairs();
        this.loadWalls();
    }

    private void loadStairs() {
        this.stairRecipes = new SwitchableRecipeGroup(this.stoneStair.recipes(), this.settings().stairsOn);
    }

    private void loadWalls() {
        this.wallRecipes = new SwitchableRecipeGroup(this.stoneWall.recipes(), this.settings().wallsOn);
    }

    private void loadButtons() {
        this.buttonRecipes = new SwitchableRecipeGroup(this.stoneButton.recipes(), this.settings().buttonsOn);
    }

    public void postInit(FMLPostInitializationEvent event) throws Exception {
    }

    public static boolean overridesRecipe(IRecipe recipe) {
        if (recipe == null) {
            return false;
        }
        Item output = null;
        try {
            output = recipe.func_77571_b().func_77973_b();
        }
        catch (Exception e) {
            return false;
        }
        if (output == null) {
            return false;
        }
        if (!(output instanceof ItemBlock)) {
            return false;
        }
        Block blockMade = ((ItemBlock)output).field_150939_a;
        if (UndergroundBiomes.buttonsOn() && blockMade instanceof BlockButtonStone) {
            return true;
        }
        if (UndergroundBiomes.stairsOn() && blockMade instanceof BlockStairs) {
            return true;
        }
        if (UndergroundBiomes.wallsOn() && blockMade instanceof BlockWall) {
            return true;
        }
        if (blockMade instanceof BlockSlab) {
            return !blockMade.func_149662_c();
        }
        return false;
    }
}

