/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.tileentity;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import com.rwtema.extrautils.ExtraUtils;
import com.rwtema.extrautils.ExtraUtilsMod;
import com.rwtema.extrautils.LogHelper;
import com.rwtema.extrautils.XUHelper;
import cpw.mods.fml.common.Optional;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.Facing;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.TileFluidHandler;

@Optional.InterfaceList(value={@Optional.Interface(iface="buildcraft.api.mj.IBatteryProvider", modid="BuildCraftAPI|power")})
public class TileEntityEnderThermicLavaPump
extends TileFluidHandler
implements IFluidHandler,
IEnergyHandler {
    public EntityPlayer owner = null;
    public boolean finished = false;
    private ForgeChunkManager.Ticket chunkTicket;
    private FluidTank tank;
    private int pump_y = -1;
    private int chunk_x = 0;
    private int chunk_z = 0;
    private int b = 0;
    private boolean find_new_block = false;
    private boolean init = false;
    private int chunk_no = -1;
    private float p = 0.95f;
    private EnergyStorage cofhEnergy = new EnergyStorage(10000);

    public TileEntityEnderThermicLavaPump() {
        this.tank = new FluidTank(1000);
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.finished) {
            if (this.chunkTicket != null) {
                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkTicket);
                this.chunkTicket = null;
            }
            return;
        }
        if (this.chunkTicket == null) {
            boolean valid = false;
            if (ExtraUtils.validDimensionsForEnderPump != null) {
                if (ExtraUtils.allNonVanillaDimensionsValidForEnderPump) {
                    valid = true;
                }
                for (int i = 0; i < ExtraUtils.validDimensionsForEnderPump.length; ++i) {
                    if (ExtraUtils.validDimensionsForEnderPump[i] != this.field_145850_b.field_73011_w.field_76574_g) continue;
                    valid = !valid;
                    break;
                }
            }
            if (!valid) {
                this.finished = true;
                if (this.owner != null) {
                    this.owner.func_146105_b((IChatComponent)new ChatComponentText("Pump will not function in this dimension"));
                    this.owner = null;
                }
                this.func_70296_d();
                return;
            }
            this.chunkTicket = ForgeChunkManager.requestTicket((Object)ExtraUtilsMod.instance, (World)this.field_145850_b, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
            if (this.chunkTicket == null) {
                this.finished = true;
                if (this.owner != null) {
                    this.owner.func_146105_b((IChatComponent)new ChatComponentText("Unable to assign Chunkloader, this pump will not work"));
                    this.owner = null;
                }
                this.func_70296_d();
                return;
            }
            this.owner = null;
            this.chunkTicket.getModData().func_74778_a("id", "pump");
            this.chunkTicket.getModData().func_74768_a("pumpX", this.field_145851_c);
            this.chunkTicket.getModData().func_74768_a("pumpY", this.field_145848_d);
            this.chunkTicket.getModData().func_74768_a("pumpZ", this.field_145849_e);
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (ChunkCoordIntPair)new ChunkCoordIntPair(this.field_145851_c >> 4, this.field_145849_e >> 4));
        }
        boolean goAgain = true;
        for (int t = 0; t < 16 && goAgain; ++t) {
            goAgain = false;
            int bx = this.b >> 4;
            int bz = this.b & 0xF;
            int pump_x = (this.chunk_x << 4) + bx;
            int pump_z = (this.chunk_z << 4) + bz;
            Block id = this.field_145850_b.func_147439_a(pump_x, this.pump_y, pump_z);
            if (this.pump_y >= 0 && XUHelper.drainBlock(this.field_145850_b, pump_x, this.pump_y, pump_z, false) != null) {
                if (this.tank.getInfo().fluid != null && this.tank.getInfo().fluid.amount > 0 || this.cofhEnergy.extractEnergy(100, true) != 100 || this.cofhEnergy.extractEnergy(100, false) <= 0) continue;
                FluidStack liquid = XUHelper.drainBlock(this.field_145850_b, pump_x, this.pump_y, pump_z, true);
                this.tank.fill(liquid, true);
                if (this.field_145850_b.func_147437_c(pump_x, this.pump_y, pump_z)) {
                    if (this.field_145850_b.field_73012_v.nextDouble() < (double)this.p) {
                        this.field_145850_b.func_147465_d(pump_x, this.pump_y, pump_z, Blocks.field_150348_b, 0, 2);
                    } else {
                        this.field_145850_b.func_147465_d(pump_x, this.pump_y, pump_z, Blocks.field_150347_e, 0, 2);
                    }
                }
                --this.pump_y;
                this.func_70296_d();
                continue;
            }
            goAgain = true;
            if (!this.init) {
                this.b = 256;
            }
            ++this.b;
            if (this.b >= 256) {
                int dz;
                this.b = 0;
                goAgain = false;
                if (this.init && this.chunk_no > 0) {
                    for (int dx = -2; dx <= 2; ++dx) {
                        for (dz = -2; dz <= 2; ++dz) {
                            ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (ChunkCoordIntPair)new ChunkCoordIntPair(this.chunk_x + dx, this.chunk_z + dz));
                        }
                    }
                }
                ++this.chunk_no;
                this.setChunk(this.chunk_no);
                for (int dx = -2; dx <= 2; ++dx) {
                    for (dz = -2; dz <= 2; ++dz) {
                        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (ChunkCoordIntPair)new ChunkCoordIntPair(this.chunk_x + dx, this.chunk_z + dz));
                        this.field_145850_b.func_72964_e(this.chunk_x + dx, this.chunk_z + dz);
                    }
                }
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (ChunkCoordIntPair)new ChunkCoordIntPair(this.field_145851_c >> 4, this.field_145849_e >> 4));
            }
            this.pump_y = this.field_145848_d - 1;
            this.init = true;
            this.func_70296_d();
        }
        FluidStack liquid = this.tank.getInfo().fluid;
        if (liquid != null && liquid.amount > 0) {
            int[] seq = XUHelper.rndSeq(6, this.field_145850_b.field_73012_v);
            for (int i = 0; i < 6; ++i) {
                TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + Facing.field_71586_b[seq[i]], this.field_145848_d + Facing.field_71587_c[seq[i]], this.field_145849_e + Facing.field_71585_d[seq[i]]);
                if (!(tile instanceof IFluidHandler)) continue;
                int moved = ((IFluidHandler)tile).fill(ForgeDirection.values()[seq[i]].getOpposite(), liquid, true);
                this.func_70296_d();
                this.tank.drain(moved, true);
                liquid = this.tank.getInfo().fluid;
                if (liquid == null || liquid.amount <= 0) break;
            }
        }
    }

    public void func_145843_s() {
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkTicket);
        super.func_145843_s();
    }

    public void onChunkUnload() {
    }

    public void setChunk(int chunk_no) {
        int base_chunk_x = this.field_145851_c >> 4;
        int base_chunk_z = this.field_145849_e >> 4;
        int j = chunk_no;
        if (j == 0) {
            this.chunk_x = base_chunk_x;
            this.chunk_z = base_chunk_z;
            return;
        }
        --j;
        for (int k = 1; k <= 5; ++k) {
            if (j >= 4 * k) {
                j -= 4 * k;
                continue;
            }
            if (j < k) {
                this.chunk_x = base_chunk_x + j;
                this.chunk_z = base_chunk_z + k - j;
            } else if (j < 2 * k) {
                this.chunk_x = base_chunk_x + k - (j -= k);
                this.chunk_z = base_chunk_z - j;
            } else if (j < 3 * k) {
                this.chunk_x = base_chunk_x - (j -= 2 * k);
                this.chunk_z = base_chunk_z - (k - j);
            } else {
                this.chunk_x = base_chunk_x - (k - (j -= 3 * k));
                this.chunk_z = base_chunk_z + j;
            }
            return;
        }
        this.finished = true;
        this.func_70296_d();
        chunk_no = 255;
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        if (par1NBTTagCompound.func_74764_b("block_no") && par1NBTTagCompound.func_74781_a("block_no") instanceof NBTTagInt) {
            this.b = par1NBTTagCompound.func_74762_e("block_no");
        } else {
            LogHelper.info("Extra Utilities: Problem loading EnderPump TileEntity Tag (block_no)", new Object[0]);
        }
        if (par1NBTTagCompound.func_74764_b("chunk_no") && par1NBTTagCompound.func_74781_a("chunk_no") instanceof NBTTagByte) {
            this.chunk_no = par1NBTTagCompound.func_74771_c("chunk_no");
        } else {
            LogHelper.info("Extra Utilities: Problem loading EnderPump TileEntity Tag (chunk_no)", new Object[0]);
        }
        if (this.chunk_no == -128) {
            this.finished = true;
        } else {
            this.setChunk(this.chunk_no);
        }
        this.tank.readFromNBT(par1NBTTagCompound.func_74775_l("tank"));
        this.init = true;
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("block_no", this.b);
        if (this.finished) {
            par1NBTTagCompound.func_74774_a("chunk_no", (byte)-128);
        } else {
            par1NBTTagCompound.func_74774_a("chunk_no", (byte)this.chunk_no);
        }
        NBTTagCompound tank_tags = new NBTTagCompound();
        this.tank.writeToNBT(tank_tags);
        par1NBTTagCompound.func_74782_a("tank", (NBTBase)tank_tags);
        NBTTagCompound power_tags = new NBTTagCompound();
        par1NBTTagCompound.func_74782_a("power", (NBTBase)power_tags);
    }

    public void forceChunkLoading(ForgeChunkManager.Ticket ticket) {
        if (this.chunkTicket == null) {
            this.chunkTicket = ticket;
        }
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (ChunkCoordIntPair)new ChunkCoordIntPair(this.field_145851_c >> 4, this.field_145849_e >> 4));
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dz = -2; dz <= 2; ++dz) {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (ChunkCoordIntPair)new ChunkCoordIntPair(this.chunk_x + dx, this.chunk_z + dz));
                this.field_145850_b.func_72964_e(this.chunk_x + dx, this.chunk_z + dz);
            }
        }
    }

    public Packet func_145844_m() {
        if (this.finished) {
            NBTTagCompound t = new NBTTagCompound();
            t.func_74757_a("finished", true);
        }
        return null;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.cofhEnergy.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.cofhEnergy.extractEnergy(maxExtract, simulate);
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.cofhEnergy.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.cofhEnergy.getMaxEnergyStored();
    }
}

