/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.compress;

import WayofTime.alchemicalWizardry.api.compress.CompressionHandler;
import WayofTime.alchemicalWizardry.api.compress.CompressionRegistry;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.world.World;

public class AdvancedCompressionHandler
extends CompressionHandler {
    @Override
    public ItemStack compressInventory(ItemStack[] inv, World world) {
        return this.test(inv, true, world);
    }

    public ItemStack test(ItemStack[] inv, boolean doDrain, World world) {
        for (ItemStack invStack : inv) {
            if (invStack == null) continue;
            for (int i = 2; i <= 3; ++i) {
                int needed;
                int threshold;
                int neededLeft;
                ItemStack stacky = this.getRecipe(invStack, world, i);
                if (!this.isResultStackReversible(stacky, i, world) || (neededLeft = this.iterateThroughInventory(invStack, threshold = CompressionRegistry.getItemThreshold(invStack), inv, needed = i * i, false)) > 0) continue;
                this.iterateThroughInventory(invStack, 0, inv, needed, true);
                return stacky;
            }
        }
        return null;
    }

    public int iterateThroughInventory(ItemStack required, int kept, ItemStack[] inv, int needed, boolean doDrain) {
        int i = -1;
        for (ItemStack invStack : inv) {
            int remainingFromStack;
            ++i;
            if (invStack == null || !invStack.func_77969_a(required) || !(invStack.func_77978_p() == null ? required.func_77978_p() == null : invStack.func_77978_p().equals((Object)required.func_77978_p()))) continue;
            int stackSize = invStack.field_77994_a;
            int used = 0;
            if (kept > 0) {
                remainingFromStack = Math.max(stackSize - kept, 0);
                used += stackSize - remainingFromStack;
            }
            if ((kept -= used) <= 0 && needed > 0) {
                remainingFromStack = Math.max(stackSize - used - needed, 0);
                if (doDrain) {
                    invStack.field_77994_a = remainingFromStack + used;
                    if (invStack.field_77994_a <= 0) {
                        inv[i] = null;
                    }
                }
                needed -= stackSize - used - remainingFromStack;
            }
            if (needed > 0) continue;
            return 0;
        }
        return needed;
    }

    public boolean isResultStackReversible(ItemStack stack, int gridSize, World world) {
        if (stack == null) {
            return false;
        }
        InventoryCrafting inventory = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer player) {
                return false;
            }
        }, 2, 2);
        inventory.func_70299_a(0, stack);
        ItemStack returnStack = CraftingManager.func_77594_a().func_82787_a(inventory, world);
        if (returnStack == null) {
            return false;
        }
        ItemStack compressedStack = null;
        switch (gridSize) {
            case 2: {
                compressedStack = this.get22Recipe(returnStack, world);
                break;
            }
            case 3: {
                compressedStack = this.get33Recipe(returnStack, world);
            }
        }
        if (compressedStack == null) {
            return false;
        }
        return SpellHelper.areItemStacksEqual(stack, compressedStack);
    }

    public ItemStack getRecipe(ItemStack stack, World world, int gridSize) {
        InventoryCrafting inventory = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer player) {
                return false;
            }
        }, gridSize, gridSize);
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            inventory.func_70299_a(i, stack);
        }
        return CraftingManager.func_77594_a().func_82787_a(inventory, world);
    }

    public boolean has22Recipe(ItemStack stack, World world) {
        return this.get22Recipe(stack, world) != null;
    }

    public ItemStack get22Recipe(ItemStack stack, World world) {
        return this.getRecipe(stack, world, 2);
    }

    public boolean has33Recipe(ItemStack stack, World world) {
        return this.get22Recipe(stack, world) != null;
    }

    public ItemStack get33Recipe(ItemStack stack, World world) {
        return this.getRecipe(stack, world, 3);
    }
}

