/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.api.soulNetwork;

import WayofTime.alchemicalWizardry.api.event.AddToNetworkEvent;
import WayofTime.alchemicalWizardry.api.event.ItemBindEvent;
import WayofTime.alchemicalWizardry.api.event.ItemDrainInContainerEvent;
import WayofTime.alchemicalWizardry.api.event.ItemDrainNetworkEvent;
import WayofTime.alchemicalWizardry.api.soulNetwork.LifeEssenceNetwork;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;

public class SoulNetworkHandler {
    public static UUID getUUIDFromPlayer(EntityPlayer player) {
        return player.getPersistentID();
    }

    public static EntityPlayer getPlayerFromUUID(UUID uuid) {
        MinecraftServer server = MinecraftServer.func_71276_C();
        GameProfile gameProfile = server.func_152358_ax().func_152652_a(uuid);
        return null;
    }

    public static boolean syphonFromNetworkWhileInContainer(ItemStack ist, int damageToBeDone) {
        ItemDrainInContainerEvent event;
        String ownerName = "";
        if (ist.func_77978_p() != null && !ist.func_77978_p().func_74779_i("ownerName").equals("")) {
            ownerName = ist.func_77978_p().func_74779_i("ownerName");
        }
        if (MinecraftForge.EVENT_BUS.post((Event)(event = new ItemDrainInContainerEvent(ist, ownerName, damageToBeDone))) || event.getResult() == Event.Result.DENY) {
            return false;
        }
        return SoulNetworkHandler.syphonFromNetwork(event.ownerNetwork, event.drainAmount) >= damageToBeDone;
    }

    public static int getCurrentMaxOrb(String ownerName) {
        if (MinecraftServer.func_71276_C() == null) {
            return 0;
        }
        WorldServer world = MinecraftServer.func_71276_C().field_71305_c[0];
        LifeEssenceNetwork data = (LifeEssenceNetwork)world.func_72943_a(LifeEssenceNetwork.class, ownerName);
        if (data == null) {
            data = new LifeEssenceNetwork(ownerName);
            world.func_72823_a(ownerName, (WorldSavedData)data);
        }
        return data.maxOrb;
    }

    public static void setMaxOrbToMax(String ownerName, int maxOrb) {
        if (MinecraftServer.func_71276_C() == null) {
            return;
        }
        WorldServer world = MinecraftServer.func_71276_C().field_71305_c[0];
        LifeEssenceNetwork data = (LifeEssenceNetwork)world.func_72943_a(LifeEssenceNetwork.class, ownerName);
        if (data == null) {
            data = new LifeEssenceNetwork(ownerName);
            world.func_72823_a(ownerName, (WorldSavedData)data);
        }
        data.maxOrb = Math.max(maxOrb, data.maxOrb);
        data.func_76185_a();
    }

    public static int getMaximumForOrbTier(int maxOrb) {
        switch (maxOrb) {
            case 1: {
                return 5000;
            }
            case 2: {
                return 25000;
            }
            case 3: {
                return 150000;
            }
            case 4: {
                return 1000000;
            }
            case 5: {
                return 10000000;
            }
            case 6: {
                return 30000000;
            }
        }
        return 1;
    }

    public static int syphonFromNetwork(ItemStack ist, int damageToBeDone) {
        if (ist.func_77978_p() != null && !ist.func_77978_p().func_74779_i("ownerName").equals("")) {
            String ownerName = ist.func_77978_p().func_74779_i("ownerName");
            return SoulNetworkHandler.syphonFromNetwork(ownerName, damageToBeDone);
        }
        return 0;
    }

    public static int syphonFromNetwork(String ownerName, int damageToBeDone) {
        if (MinecraftServer.func_71276_C() == null) {
            return 0;
        }
        WorldServer world = MinecraftServer.func_71276_C().field_71305_c[0];
        LifeEssenceNetwork data = (LifeEssenceNetwork)world.func_72943_a(LifeEssenceNetwork.class, ownerName);
        if (data == null) {
            data = new LifeEssenceNetwork(ownerName);
            world.func_72823_a(ownerName, (WorldSavedData)data);
        }
        if (data.currentEssence >= damageToBeDone) {
            data.currentEssence -= damageToBeDone;
            data.func_76185_a();
            return damageToBeDone;
        }
        return 0;
    }

    public static boolean syphonAndDamageFromNetwork(ItemStack ist, EntityPlayer player, int drain) {
        if (player.field_70170_p.field_72995_K) {
            return false;
        }
        if (ist.func_77978_p() != null && !ist.func_77978_p().func_74779_i("ownerName").equals("")) {
            String ownerName = ist.func_77978_p().func_74779_i("ownerName");
            ItemDrainNetworkEvent event = new ItemDrainNetworkEvent(player, ownerName, ist, drain);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return false;
            }
            int drainAmount = SoulNetworkHandler.syphonFromNetwork(event.ownerNetwork, event.drainAmount);
            if (drainAmount == 0 || event.shouldDamage) {
                SoulNetworkHandler.hurtPlayer(player, event.damageAmount);
            }
            return event.getResult() != Event.Result.DENY;
        }
        int amount = SoulNetworkHandler.syphonFromNetwork(ist, drain);
        SoulNetworkHandler.hurtPlayer(player, drain - amount);
        return true;
    }

    public static boolean syphonAndDamageFromNetwork(String ownerName, EntityPlayer player, int damageToBeDone) {
        if (player.field_70170_p.field_72995_K) {
            return false;
        }
        World world = player.field_70170_p;
        if (world != null) {
            double posX = player.field_70165_t;
            double posY = player.field_70163_u;
            double posZ = player.field_70161_v;
            world.func_72908_a((double)((float)player.field_70165_t + 0.5f), (double)((float)player.field_70163_u + 0.5f), (double)((float)player.field_70161_v + 0.5f), "random.fizz", 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
        }
        int amount = SoulNetworkHandler.syphonFromNetwork(ownerName, damageToBeDone);
        SoulNetworkHandler.hurtPlayer(player, damageToBeDone - amount);
        return true;
    }

    public static boolean canSyphonFromOnlyNetwork(ItemStack ist, int damageToBeDone) {
        if (ist.func_77978_p() != null && !ist.func_77978_p().func_74779_i("ownerName").equals("")) {
            String ownerName = ist.func_77978_p().func_74779_i("ownerName");
            return SoulNetworkHandler.canSyphonFromOnlyNetwork(ownerName, damageToBeDone);
        }
        return false;
    }

    public static boolean canSyphonFromOnlyNetwork(String ownerName, int damageToBeDone) {
        if (MinecraftServer.func_71276_C() == null) {
            return false;
        }
        WorldServer world = MinecraftServer.func_71276_C().field_71305_c[0];
        LifeEssenceNetwork data = (LifeEssenceNetwork)world.func_72943_a(LifeEssenceNetwork.class, ownerName);
        if (data == null) {
            data = new LifeEssenceNetwork(ownerName);
            world.func_72823_a(ownerName, (WorldSavedData)data);
        }
        return data.currentEssence >= damageToBeDone;
    }

    public static int getCurrentEssence(String ownerName) {
        if (MinecraftServer.func_71276_C() == null) {
            return 0;
        }
        WorldServer world = MinecraftServer.func_71276_C().field_71305_c[0];
        LifeEssenceNetwork data = (LifeEssenceNetwork)world.func_72943_a(LifeEssenceNetwork.class, ownerName);
        if (data == null) {
            data = new LifeEssenceNetwork(ownerName);
            world.func_72823_a(ownerName, (WorldSavedData)data);
        }
        return data.currentEssence;
    }

    public static void setCurrentEssence(String ownerName, int essence) {
        if (MinecraftServer.func_71276_C() == null) {
            return;
        }
        WorldServer world = MinecraftServer.func_71276_C().field_71305_c[0];
        LifeEssenceNetwork data = (LifeEssenceNetwork)world.func_72943_a(LifeEssenceNetwork.class, ownerName);
        if (data == null) {
            data = new LifeEssenceNetwork(ownerName);
            world.func_72823_a(ownerName, (WorldSavedData)data);
        }
        data.currentEssence = essence;
        data.func_76185_a();
    }

    public static int addCurrentEssenceToMaximum(String ownerName, int addedEssence, int maximum) {
        int currEss;
        AddToNetworkEvent event = new AddToNetworkEvent(ownerName, addedEssence, maximum);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return 0;
        }
        if (MinecraftServer.func_71276_C() == null) {
            return 0;
        }
        WorldServer world = MinecraftServer.func_71276_C().field_71305_c[0];
        LifeEssenceNetwork data = (LifeEssenceNetwork)world.func_72943_a(LifeEssenceNetwork.class, event.ownerNetwork);
        if (data == null) {
            data = new LifeEssenceNetwork(event.ownerNetwork);
            world.func_72823_a(event.ownerNetwork, (WorldSavedData)data);
        }
        if ((currEss = data.currentEssence) >= event.maximum) {
            return 0;
        }
        int newEss = Math.min(event.maximum, currEss + event.addedAmount);
        if (event.getResult() != Event.Result.DENY) {
            data.currentEssence = newEss;
        }
        return newEss - currEss;
    }

    public static void hurtPlayer(EntityPlayer user, int energySyphoned) {
        block4: {
            block3: {
                if (energySyphoned >= 100 || energySyphoned <= 0) break block3;
                if (user.field_71075_bZ.field_75098_d) break block4;
                user.func_70606_j(user.func_110143_aJ() - 1.0f);
                if (user.func_110143_aJ() <= 5.0E-4f) {
                    user.func_70645_a(DamageSource.field_76377_j);
                }
                break block4;
            }
            if (energySyphoned >= 100 && !user.field_71075_bZ.field_75098_d) {
                for (int i = 0; i < (energySyphoned + 99) / 100; ++i) {
                    user.func_70606_j(user.func_110143_aJ() - 1.0f);
                    if (!(user.func_110143_aJ() <= 5.0E-4f)) continue;
                    user.func_70645_a(DamageSource.field_76377_j);
                    break;
                }
            }
        }
    }

    public static void hurtPlayer(EntityPlayer user, float damage) {
        if (!user.field_71075_bZ.field_75098_d) {
            user.func_70606_j(user.func_110143_aJ() - damage);
            if (user.func_110143_aJ() <= 5.0E-4f) {
                user.func_70645_a(DamageSource.field_76377_j);
            }
        }
    }

    public static void checkAndSetItemOwner(ItemStack item, EntityPlayer player) {
        ItemBindEvent event;
        if (item.field_77990_d == null) {
            item.func_77982_d(new NBTTagCompound());
        }
        if (item.field_77990_d.func_74779_i("ownerName").equals("") && !MinecraftForge.EVENT_BUS.post((Event)(event = new ItemBindEvent(player, SoulNetworkHandler.getUsername(player), item)))) {
            item.field_77990_d.func_74778_a("ownerName", event.key);
        }
    }

    public static void checkAndSetItemOwner(ItemStack item, String ownerName) {
        if (item.field_77990_d == null) {
            item.func_77982_d(new NBTTagCompound());
        }
        if (item.field_77990_d.func_74779_i("ownerName").equals("")) {
            item.field_77990_d.func_74778_a("ownerName", ownerName);
        }
    }

    public static String getUsername(EntityPlayer player) {
        return player.getDisplayName();
    }

    public static EntityPlayer getPlayerForUsername(String str) {
        if (MinecraftServer.func_71276_C() == null) {
            return null;
        }
        return MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(str);
    }

    public static void causeNauseaToPlayer(ItemStack stack) {
        if (stack.func_77978_p() != null && !stack.func_77978_p().func_74779_i("ownerName").equals("")) {
            String ownerName = stack.func_77978_p().func_74779_i("ownerName");
            SoulNetworkHandler.causeNauseaToPlayer(ownerName);
        }
    }

    public static void causeNauseaToPlayer(String ownerName) {
        EntityPlayer entityOwner = SoulNetworkHandler.getPlayerForUsername(ownerName);
        if (entityOwner == null) {
            return;
        }
        entityOwner.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 80));
    }

    public static String getOwnerName(ItemStack item) {
        if (item.field_77990_d == null) {
            item.func_77982_d(new NBTTagCompound());
        }
        return item.field_77990_d.func_74779_i("ownerName");
    }
}

