/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.api.alchemy.energy;

import WayofTime.alchemicalWizardry.api.alchemy.energy.Reagent;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentStack;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;

public class ReagentRegistry {
    public static Map<String, Reagent> reagentList = new HashMap<String, Reagent>();
    public static Map<ItemStack, ReagentStack> itemToReagentMap = new HashMap<ItemStack, ReagentStack>();
    public static Reagent sanctusReagent;
    public static Reagent incendiumReagent;
    public static Reagent aquasalusReagent;
    public static Reagent magicalesReagent;
    public static Reagent aetherReagent;
    public static Reagent crepitousReagent;
    public static Reagent crystallosReagent;
    public static Reagent terraeReagent;
    public static Reagent tenebraeReagent;
    public static Reagent offensaReagent;
    public static Reagent praesidiumReagent;
    public static Reagent orbisTerraeReagent;
    public static Reagent virtusReagent;
    public static Reagent reductusReagent;
    public static Reagent potentiaReagent;

    public static void initReagents() {
        sanctusReagent = new Reagent("sanctus");
        incendiumReagent = new Reagent("incendium");
        aquasalusReagent = new Reagent("aquasalus");
        magicalesReagent = new Reagent("magicales");
        aetherReagent = new Reagent("aether");
        crepitousReagent = new Reagent("crepitous");
        crystallosReagent = new Reagent("crystallos");
        terraeReagent = new Reagent("terrae");
        tenebraeReagent = new Reagent("tenebrae");
        offensaReagent = new Reagent("offensa");
        praesidiumReagent = new Reagent("praesidium");
        orbisTerraeReagent = new Reagent("orbisTerrae");
        virtusReagent = new Reagent("virtus");
        reductusReagent = new Reagent("reductus");
        potentiaReagent = new Reagent("potentia");
        sanctusReagent.setColour(255, 255, 0, 255);
        incendiumReagent.setColour(255, 0, 0, 255);
        aquasalusReagent.setColour(47, 0, 196, 255);
        magicalesReagent.setColour(150, 0, 146, 255);
        aetherReagent.setColour(105, 223, 86, 255);
        crepitousReagent.setColour(145, 145, 145, 255);
        crystallosReagent.setColour(135, 255, 231, 255);
        terraeReagent.setColour(147, 48, 13, 255);
        tenebraeReagent.setColour(86, 86, 86, 255);
        offensaReagent.setColour(126, 0, 0, 255);
        praesidiumReagent.setColour(135, 135, 135, 255);
        orbisTerraeReagent.setColour(32, 94, 14, 255);
        virtusReagent.setColour(180, 0, 0, 255);
        reductusReagent.setColour(20, 93, 2, 255);
        potentiaReagent.setColour(64, 81, 208, 255);
        ReagentRegistry.registerReagent("sanctus", sanctusReagent);
        ReagentRegistry.registerReagent("incendium", incendiumReagent);
        ReagentRegistry.registerReagent("aquasalus", aquasalusReagent);
        ReagentRegistry.registerReagent("magicales", magicalesReagent);
        ReagentRegistry.registerReagent("aether", aetherReagent);
        ReagentRegistry.registerReagent("crepitous", crepitousReagent);
        ReagentRegistry.registerReagent("crystallos", crystallosReagent);
        ReagentRegistry.registerReagent("terrae", terraeReagent);
        ReagentRegistry.registerReagent("tenebrae", tenebraeReagent);
        ReagentRegistry.registerReagent("offensa", offensaReagent);
        ReagentRegistry.registerReagent("praesidium", praesidiumReagent);
        ReagentRegistry.registerReagent("orbisTerrae", orbisTerraeReagent);
        ReagentRegistry.registerReagent("virtus", virtusReagent);
        ReagentRegistry.registerReagent("reductus", reductusReagent);
        ReagentRegistry.registerReagent("potentia", potentiaReagent);
    }

    public static boolean registerReagent(String key, Reagent reagent) {
        if (reagentList.containsKey(key) || reagent == null) {
            return false;
        }
        reagentList.put(key, reagent);
        return true;
    }

    public static Reagent getReagentForKey(String key) {
        if (reagentList.containsKey(key)) {
            return reagentList.get(key);
        }
        return null;
    }

    public static String getKeyForReagent(Reagent reagent) {
        if (reagentList.containsValue(reagent)) {
            Set<Map.Entry<String, Reagent>> set = reagentList.entrySet();
            for (Map.Entry<String, Reagent> entry : set) {
                if (!entry.getValue().equals(reagent)) continue;
                return entry.getKey();
            }
        }
        return "";
    }

    public static void registerItemAndReagent(ItemStack stack, ReagentStack reagentStack) {
        itemToReagentMap.put(stack, reagentStack);
    }

    public static ReagentStack getReagentStackForItem(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        for (Map.Entry<ItemStack, ReagentStack> entry : itemToReagentMap.entrySet()) {
            if (entry.getKey() == null || !entry.getKey().func_77969_a(stack)) continue;
            if (entry.getValue() == null) {
                return null;
            }
            return entry.getValue().copy();
        }
        return null;
    }

    public static ItemStack getItemForReagent(Reagent reagent) {
        if (reagent == null) {
            return null;
        }
        for (Map.Entry<ItemStack, ReagentStack> entry : itemToReagentMap.entrySet()) {
            if (entry.getValue() == null || entry.getValue().reagent != reagent) continue;
            if (entry.getKey() == null) {
                return null;
            }
            return entry.getKey().func_77946_l();
        }
        return null;
    }
}

