/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.utils;

import java.util.List;
import modtweaker2.helpers.StackHelper;
import modtweaker2.utils.BaseDescriptionAddition;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;

public abstract class BaseCraftingAddition
extends BaseDescriptionAddition {
    protected final List<IRecipe> list;
    protected final boolean shapeless;
    protected final ItemStack output;
    protected final Object[] recipe;

    public BaseCraftingAddition(String name, boolean shapeless, List list, ItemStack output, Object ... recipe) {
        super(name);
        this.shapeless = shapeless;
        this.output = output;
        this.recipe = recipe;
        this.list = list;
    }

    public void apply() {
        if (this.shapeless) {
            this.applyShapeless();
        } else {
            this.applyShaped();
        }
    }

    public abstract void applyShaped();

    public abstract void applyShapeless();

    @Override
    public boolean canUndo() {
        return this.list != null;
    }

    public void undo() {
        IRecipe remove = null;
        for (IRecipe recipe : this.list) {
            if (recipe.func_77571_b() == null || !StackHelper.areEqual(recipe.func_77571_b(), this.output)) continue;
            remove = recipe;
            break;
        }
        this.list.remove(remove);
    }

    @Override
    public String getRecipeInfo() {
        return this.output.func_82833_r();
    }
}

