/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.thermalexpansion.handlers;

import cofh.lib.inventory.ComparableItemStackSafe;
import cofh.thermalexpansion.util.crafting.TransposerManager;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.mods.thermalexpansion.ThermalHelper;
import modtweaker2.utils.BaseDescriptionAddition;
import modtweaker2.utils.BaseDescriptionRemoval;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.thermalexpansion.Transposer")
public class Transposer {
    private static boolean removeValidated(ComparableItemStackSafe stack) {
        TransposerManager.RecipeTransposer recipe;
        for (Map.Entry<List, TransposerManager.RecipeTransposer> entry : ThermalHelper.getFillMap().entrySet()) {
            recipe = entry.getValue();
            if (!stack.equals((Object)new ComparableItemStackSafe(recipe.getInput()))) continue;
            return false;
        }
        for (Map.Entry<List, TransposerManager.RecipeTransposer> entry : ThermalHelper.getExtractMap().entrySet()) {
            recipe = entry.getValue();
            if (!stack.equals((Object)new ComparableItemStackSafe(recipe.getInput()))) continue;
            return false;
        }
        return ThermalHelper.transposerValid.remove(stack);
    }

    @ZenMethod
    public static void addFillRecipe(int energy, IItemStack input, IItemStack output, ILiquidStack liquid) {
        Transposer.addRecipe(energy, input, output, liquid, 100, true);
    }

    @ZenMethod
    public static void addExtractRecipe(int energy, IItemStack input, IItemStack output, ILiquidStack liquid, int chance) {
        Transposer.addRecipe(energy, input, output, liquid, chance, false);
    }

    @ZenMethod
    public static void addRecipe(int energy, IItemStack input, IItemStack output, ILiquidStack liquid, int chance, boolean isFillRecipe) {
        ItemStack in = InputHelper.toStack(input);
        ItemStack out = InputHelper.toStack(output);
        FluidStack fluid = InputHelper.toFluid(liquid);
        TransposerManager.RecipeTransposer recipe = (TransposerManager.RecipeTransposer)ThermalHelper.getTERecipe(ThermalHelper.transposerRecipe, in, out, fluid, energy, chance);
        MineTweakerAPI.apply((IUndoableAction)new Add(in, fluid, recipe, isFillRecipe));
    }

    @ZenMethod
    public static void removeFillRecipe(IItemStack input, ILiquidStack liquid) {
        Transposer.removeRecipe(input, liquid, true);
    }

    @ZenMethod
    public static void removeExtractRecipe(IItemStack input) {
        Transposer.removeRecipe(input, null, false);
    }

    @ZenMethod
    public static void removeRecipe(IItemStack input, ILiquidStack liquid, boolean isFillRecipe) {
        MineTweakerAPI.apply((IUndoableAction)new Remove(InputHelper.toStack(input), InputHelper.toFluid(liquid), isFillRecipe));
    }

    private static class Remove
    extends BaseDescriptionRemoval {
        private final boolean isFillRecipe;
        private final ComparableItemStackSafe input;
        private List key;
        private TransposerManager.RecipeTransposer recipe;

        public Remove(ItemStack input, FluidStack fluid, boolean isFillRecipe) {
            super("Transposer");
            this.isFillRecipe = isFillRecipe;
            this.input = new ComparableItemStackSafe(input);
            if (this.isFillRecipe) {
                this.key = Arrays.asList(new ComparableItemStackSafe(input).hashCode(), fluid.fluidID);
            }
        }

        public void apply() {
            if (this.isFillRecipe) {
                this.recipe = ThermalHelper.getFillMap().get(this.key);
                ThermalHelper.getFillMap().remove(this.key);
            } else {
                this.recipe = ThermalHelper.getExtractMap().get(this.input);
                ThermalHelper.getExtractMap().remove(this.input);
            }
            Transposer.removeValidated(this.input);
        }

        @Override
        public boolean canUndo() {
            return this.input != null;
        }

        public void undo() {
            if (this.isFillRecipe) {
                ThermalHelper.getFillMap().put(this.key, this.recipe);
            } else {
                ThermalHelper.getExtractMap().put(this.input, this.recipe);
            }
            ThermalHelper.transposerValid.add(this.input);
        }

        @Override
        public String getRecipeInfo() {
            return this.input.toItemStack().func_82833_r();
        }
    }

    private static class Add
    extends BaseDescriptionAddition {
        private List key;
        private boolean isFillRecipe;
        private final ComparableItemStackSafe input;
        private final TransposerManager.RecipeTransposer recipe;

        public Add(ItemStack input, FluidStack fluid, TransposerManager.RecipeTransposer recipe, boolean isFillRecipe) {
            super("Transposer");
            this.isFillRecipe = isFillRecipe;
            this.input = new ComparableItemStackSafe(input);
            this.recipe = recipe;
            if (this.isFillRecipe) {
                this.key = Arrays.asList(new ComparableItemStackSafe(input).hashCode(), fluid.fluidID);
            }
        }

        public void apply() {
            if (this.isFillRecipe) {
                ThermalHelper.getFillMap().put(this.key, this.recipe);
            } else {
                ThermalHelper.getExtractMap().put(this.input, this.recipe);
            }
            ThermalHelper.transposerValid.add(this.input);
        }

        @Override
        public boolean canUndo() {
            return this.input != null;
        }

        public void undo() {
            if (this.isFillRecipe) {
                ThermalHelper.getFillMap().remove(this.key);
            } else {
                ThermalHelper.getExtractMap().remove(this.input);
            }
            Transposer.removeValidated(this.input);
        }

        @Override
        public String getRecipeInfo() {
            return this.recipe.getOutput().func_82833_r();
        }
    }
}

