/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.mariculture.handlers;

import java.util.List;
import mariculture.api.core.FuelInfo;
import mariculture.api.core.MaricultureHandlers;
import mariculture.api.core.RecipeSmelter;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.mods.mariculture.MaricultureHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import modtweaker2.utils.BaseMapAddition;
import modtweaker2.utils.BaseMapRemoval;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.mariculture.Crucible")
public class Crucible {
    @ZenMethod
    public static void addRecipe(int temp, IItemStack input, ILiquidStack fluid, @Optional IItemStack output, @Optional int chance) {
        ItemStack out = output != null ? InputHelper.toStack(output) : null;
        MineTweakerAPI.apply((IUndoableAction)new AddRecipe(new RecipeSmelter(InputHelper.toStack(input), null, temp, InputHelper.toFluid(fluid), out, chance)));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack input) {
        MineTweakerAPI.apply((IUndoableAction)new RemoveRecipe(InputHelper.toStack(input)));
    }

    @ZenMethod
    public static void addFuel(IItemStack input, int max, int per, int time) {
        MineTweakerAPI.apply((IUndoableAction)new AddFuel(InputHelper.toStack(input), new FuelInfo(max, per, time)));
    }

    @ZenMethod
    public static void addFuel(ILiquidStack input, int max, int per, int time) {
        MineTweakerAPI.apply((IUndoableAction)new AddFuel(InputHelper.toFluid(input), new FuelInfo(max, per, time)));
    }

    @ZenMethod
    public static void addFuel(String input, int max, int per, int time) {
        MineTweakerAPI.apply((IUndoableAction)new AddFuel(input, new FuelInfo(max, per, time)));
    }

    @ZenMethod
    public static void removeFuel(IItemStack fuel) {
        MineTweakerAPI.apply((IUndoableAction)new RemoveFuel(fuel));
    }

    @ZenMethod
    public static void removeFuel(ILiquidStack fuel) {
        MineTweakerAPI.apply((IUndoableAction)new RemoveFuel(fuel));
    }

    @ZenMethod
    public static void removeFuel(String fuel) {
        MineTweakerAPI.apply((IUndoableAction)new RemoveFuel(fuel));
    }

    private static class RemoveFuel
    extends BaseMapRemoval {
        public RemoveFuel(Object o) {
            super("Mariculture Crucible Fuel", MaricultureHelper.fuels, MaricultureHelper.getKey(o), null);
        }

        @Override
        public String getRecipeInfo() {
            return (String)this.key;
        }
    }

    private static class AddFuel
    extends BaseMapAddition {
        public AddFuel(Object o, FuelInfo info) {
            super("Mariculture Crucible Fuel", MaricultureHelper.fuels, MaricultureHelper.getKey(o), info);
        }

        @Override
        public String getRecipeInfo() {
            return (String)this.key;
        }
    }

    private static class RemoveRecipe
    extends BaseListRemoval {
        public RemoveRecipe(ItemStack stack) {
            super("Mariculture Crucible", (List)MaricultureHandlers.crucible.getRecipes(), stack);
        }

        public void apply() {
            for (RecipeSmelter r : MaricultureHandlers.crucible.getRecipes()) {
                if (r == null || r.input == null || this.stack == null || !StackHelper.areEqual(r.input, this.stack)) continue;
                this.recipe = r;
                break;
            }
            if (this.recipe != null) {
                MaricultureHandlers.crucible.getRecipes().remove(this.recipe);
            }
        }

        @Override
        public String getRecipeInfo() {
            return this.stack.func_82833_r();
        }
    }

    private static class AddRecipe
    extends BaseListAddition {
        public AddRecipe(RecipeSmelter recipe) {
            super("Mariculture Crucible", MaricultureHandlers.crucible.getRecipes(), recipe);
        }

        @Override
        public String getRecipeInfo() {
            return ((RecipeSmelter)this.recipe).input.func_82833_r();
        }
    }
}

