/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.exnihilo.handlers;

import exnihilo.registries.CrucibleRegistry;
import exnihilo.registries.HeatRegistry;
import exnihilo.registries.helpers.HeatSource;
import exnihilo.registries.helpers.Meltable;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.utils.BaseMapAddition;
import modtweaker2.utils.BaseMapRemoval;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.exnihilo.Crucible")
public class Crucible {
    @ZenMethod
    public static void addRecipe(IItemStack input, ILiquidStack fluid) {
        if (InputHelper.isABlock(input)) {
            Block theBlock = Block.func_149634_a((Item)InputHelper.toStack(input).func_77973_b());
            int theMeta = InputHelper.toStack(input).func_77960_j();
            MineTweakerAPI.apply((IUndoableAction)new AddRecipe(new Meltable(theBlock, theMeta, 2000.0f, InputHelper.toFluid(fluid).getFluid(), (float)InputHelper.toFluid((ILiquidStack)fluid).amount, theBlock)));
        }
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        if (InputHelper.isABlock(output)) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveRecipe(InputHelper.toStack(output)));
        }
    }

    @ZenMethod
    public static void addHeatSource(IItemStack input, double value) {
        if (InputHelper.isABlock(input)) {
            Block theBlock = Block.func_149634_a((Item)InputHelper.toStack(input).func_77973_b());
            int theMeta = InputHelper.toStack(input).func_77960_j();
            MineTweakerAPI.apply((IUndoableAction)new AddHeatSource(new HeatSource(theBlock, theMeta, (float)value)));
        }
    }

    @ZenMethod
    public static void removeHeatSource(IItemStack output) {
        if (InputHelper.isABlock(output)) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveHeatSource(InputHelper.toStack(output)));
        }
    }

    private static class RemoveHeatSource
    extends BaseMapRemoval {
        public RemoveHeatSource(ItemStack stack) {
            super("ExNihilo Crucible - Heat Source", HeatRegistry.entries, Block.func_149634_a((Item)stack.func_77973_b()) + ":" + stack.func_77960_j(), stack);
        }

        @Override
        public String getRecipeInfo() {
            return ((ItemStack)this.stack).func_82833_r();
        }
    }

    private static class AddHeatSource
    extends BaseMapAddition {
        public AddHeatSource(HeatSource recipe) {
            super("ExNihilo Crucible - Heat Source", HeatRegistry.entries, recipe.block + ":" + recipe.meta, recipe);
        }

        @Override
        public String getRecipeInfo() {
            return new ItemStack(((HeatSource)this.recipe).block, 1, ((HeatSource)this.recipe).meta).func_82833_r();
        }
    }

    private static class RemoveRecipe
    extends BaseMapRemoval {
        public RemoveRecipe(ItemStack stack) {
            super("ExNihilo Crucible", CrucibleRegistry.entries, Block.func_149634_a((Item)stack.func_77973_b()) + ":" + stack.func_77960_j(), stack);
        }

        @Override
        public String getRecipeInfo() {
            return ((ItemStack)this.stack).func_82833_r();
        }
    }

    private static class AddRecipe
    extends BaseMapAddition {
        public AddRecipe(Meltable recipe) {
            super("ExNihilo Crucible", CrucibleRegistry.entries, recipe.block + ":" + recipe.meta, recipe);
        }

        @Override
        public String getRecipeInfo() {
            return new ItemStack(((Meltable)this.recipe).block, 1, ((Meltable)this.recipe).meta).func_82833_r();
        }
    }
}

