/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.util;

import java.util.HashMap;
import net.minecraft.util.EnumChatFormatting;
import thaumcraft.api.aspects.Aspect;

public final class GuiHelper {
    public static final GuiHelper INSTANCE = new GuiHelper();
    public static final int MOUSE_BUTTON_LEFT = 0;
    public static final int MOUSE_BUTTON_RIGHT = 1;
    public static final int MOUSE_BUTTON_WHEEL = 2;
    public static final int MOUSE_WHEEL_MOTION = -2;
    private static final int COLOR_ARRAY_SIZE = 4;
    private final int[] COLOR_SHIFT_AMOUNT = new int[]{0, 8, 16, 24};
    private HashMap<Aspect, String> aspectChatColors = new HashMap();

    private GuiHelper() {
        this.aspectChatColors.put(Aspect.AIR, EnumChatFormatting.YELLOW.toString());
        this.aspectChatColors.put(Aspect.WATER, EnumChatFormatting.AQUA.toString());
        this.aspectChatColors.put(Aspect.FIRE, EnumChatFormatting.RED.toString());
        this.aspectChatColors.put(Aspect.ORDER, EnumChatFormatting.GRAY.toString());
        this.aspectChatColors.put(Aspect.ENTROPY, EnumChatFormatting.DARK_GRAY.toString());
        this.aspectChatColors.put(Aspect.EARTH, EnumChatFormatting.GREEN.toString());
    }

    public static String shortenCount(long count) {
        int unit = 1000;
        if (count < (long)unit) {
            return Long.toString(count);
        }
        int exponential = (int)(Math.log(count) / Math.log(unit));
        char postfix = "KMBT".charAt(exponential - 1);
        return String.format("%.1f%c", (double)count / Math.pow(unit, exponential), Character.valueOf(postfix));
    }

    public final byte[] convertPackedColorToARGB(int color) {
        byte[] colorBytes = new byte[4];
        for (int i = 0; i < 4; ++i) {
            colorBytes[3 - i] = (byte)(color >> this.COLOR_SHIFT_AMOUNT[i] & 0xFF);
        }
        return colorBytes;
    }

    public final int[] createColorGradient(int fromColor, int toColor, int iterations) {
        if (iterations < 3) {
            return new int[]{fromColor, toColor};
        }
        int[] fromColorBytes = new int[4];
        int[] toColorBytes = new int[4];
        float[] stepAmount = new float[4];
        float[] currentColor = new float[4];
        int[] gradient = new int[iterations];
        for (int i = 0; i < 4; ++i) {
            fromColorBytes[i] = fromColor >> this.COLOR_SHIFT_AMOUNT[i] & 0xFF;
            toColorBytes[i] = toColor >> this.COLOR_SHIFT_AMOUNT[i] & 0xFF;
            stepAmount[i] = (float)(toColorBytes[i] - fromColorBytes[i]) / (float)iterations;
            currentColor[i] = fromColorBytes[i];
        }
        gradient[0] = fromColor;
        for (int iteration = 1; iteration < iterations; ++iteration) {
            int result = 0;
            for (int i = 0; i < 4; ++i) {
                int n = i;
                currentColor[n] = currentColor[n] + stepAmount[i];
                result += (Math.round(currentColor[i]) & 0xFF) << this.COLOR_SHIFT_AMOUNT[i];
            }
            gradient[iteration] = result;
        }
        gradient[iterations - 1] = toColor;
        return gradient;
    }

    public final String getAspectChatColor(Aspect aspect) {
        if (this.aspectChatColors.containsKey(aspect)) {
            return this.aspectChatColors.get(aspect);
        }
        return EnumChatFormatting.WHITE.toString();
    }

    public final boolean isPointInGuiRegion(int top, int left, int height, int width, int pointX, int pointY, int guiLeft, int guiTop) {
        return this.isPointInRegion(top, left, height, width, pointX - guiLeft, pointY - guiTop);
    }

    public final boolean isPointInRegion(int top, int left, int height, int width, int pointX, int pointY) {
        return pointX >= left && pointX <= left + width && pointY >= top && pointY <= top + height;
    }

    public final float pingPongFromTime(double speedReduction, float minValue, float maxValue) {
        if (minValue == maxValue) {
            return minValue;
        }
        if (speedReduction <= 0.0) {
            speedReduction = 1.4E-45f;
        }
        float time = (float)((double)System.currentTimeMillis() / speedReduction % 2000.0);
        time = Math.abs(time - 1000.0f);
        float timePercentage = time / 1000.0f;
        float rangePercentage = (maxValue - minValue) * timePercentage;
        return minValue + rangePercentage;
    }
}

