/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.render;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;
import thaumicenergistics.registries.Renderers;
import thaumicenergistics.texture.BlockTextureManager;
import thaumicenergistics.tileentities.abstraction.TileProviderBase;

@SideOnly(value=Side.CLIENT)
public abstract class RenderBlockProviderBase
implements ISimpleBlockRenderingHandler {
    private static ForgeDirection[] FACES = ForgeDirection.VALID_DIRECTIONS;
    private BlockTextureManager textureSource;

    public RenderBlockProviderBase(BlockTextureManager sourceTextures) {
        this.textureSource = sourceTextures;
    }

    private void renderFaces(IBlockAccess world, int x, int y, int z, IIcon texture, int glowAmount) {
        Tessellator tessellator = Tessellator.field_78398_a;
        double minU = texture.func_94209_e();
        double maxU = texture.func_94212_f();
        double minV = texture.func_94206_g();
        double maxV = texture.func_94210_h();
        int x1 = x + 1;
        int y1 = y + 1;
        int z1 = z + 1;
        block8: for (ForgeDirection face : FACES) {
            tessellator.func_78380_c(world.func_72802_i(x + face.offsetX, y + face.offsetY, z - face.offsetZ, glowAmount));
            switch (face) {
                case DOWN: {
                    tessellator.func_78374_a((double)x, (double)y, (double)z, minU, maxV);
                    tessellator.func_78374_a((double)x1, (double)y, (double)z, maxU, maxV);
                    tessellator.func_78374_a((double)x1, (double)y, (double)z1, maxU, minV);
                    tessellator.func_78374_a((double)x, (double)y, (double)z1, minU, minV);
                    continue block8;
                }
                case EAST: {
                    tessellator.func_78374_a((double)x1, (double)y, (double)z, maxU, maxV);
                    tessellator.func_78374_a((double)x1, (double)y1, (double)z, maxU, minV);
                    tessellator.func_78374_a((double)x1, (double)y1, (double)z1, minU, minV);
                    tessellator.func_78374_a((double)x1, (double)y, (double)z1, minU, maxV);
                    continue block8;
                }
                case NORTH: {
                    tessellator.func_78374_a((double)x, (double)y, (double)z1, minU, maxV);
                    tessellator.func_78374_a((double)x1, (double)y, (double)z1, maxU, maxV);
                    tessellator.func_78374_a((double)x1, (double)y1, (double)z1, maxU, minV);
                    tessellator.func_78374_a((double)x, (double)y1, (double)z1, minU, minV);
                    continue block8;
                }
                case SOUTH: {
                    tessellator.func_78374_a((double)x, (double)y1, (double)z, maxU, minV);
                    tessellator.func_78374_a((double)x1, (double)y1, (double)z, minU, minV);
                    tessellator.func_78374_a((double)x1, (double)y, (double)z, minU, maxV);
                    tessellator.func_78374_a((double)x, (double)y, (double)z, maxU, maxV);
                    continue block8;
                }
                case UP: {
                    tessellator.func_78374_a((double)x, (double)y1, (double)z1, maxU, minV);
                    tessellator.func_78374_a((double)x1, (double)y1, (double)z1, minU, minV);
                    tessellator.func_78374_a((double)x1, (double)y1, (double)z, minU, maxV);
                    tessellator.func_78374_a((double)x, (double)y1, (double)z, maxU, maxV);
                    continue block8;
                }
                case WEST: {
                    tessellator.func_78374_a((double)x, (double)y, (double)z1, maxU, maxV);
                    tessellator.func_78374_a((double)x, (double)y1, (double)z1, maxU, minV);
                    tessellator.func_78374_a((double)x, (double)y1, (double)z, minU, minV);
                    tessellator.func_78374_a((double)x, (double)y, (double)z, minU, maxV);
                    continue block8;
                }
            }
        }
    }

    public final void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        Tessellator tessellator = Tessellator.field_78398_a;
        IIcon texture = this.textureSource.getTextures()[0];
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderer.func_147768_a(block, 0.0, 0.0, 0.0, texture);
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_147806_b(block, 0.0, 0.0, 0.0, texture);
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderer.func_147761_c(block, 0.0, 0.0, 0.0, texture);
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderer.func_147734_d(block, 0.0, 0.0, 0.0, texture);
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderer.func_147798_e(block, 0.0, 0.0, 0.0, texture);
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderer.func_147764_f(block, 0.0, 0.0, 0.0, texture);
        tessellator.func_78381_a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    public final boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        IIcon texture;
        Tessellator tessellator = Tessellator.field_78398_a;
        int glow = 0;
        if (Renderers.currentRenderPass == 0) {
            texture = this.textureSource.getTextures()[0];
            tessellator.func_78370_a(255, 255, 255, 255);
        } else {
            texture = this.textureSource.getTextures()[1];
            TileProviderBase provider = (TileProviderBase)world.func_147438_o(x, y, z);
            if (provider.isActive()) {
                glow = 15;
                tessellator.func_78378_d(provider.getColor().mediumVariant);
            } else {
                tessellator.func_78370_a(0, 0, 0, 255);
            }
        }
        this.renderFaces(world, x, y, z, texture, glow);
        return true;
    }

    public final boolean shouldRender3DInInventory(int modelId) {
        return true;
    }
}

