/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.parts;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.implementations.items.IMemoryCard;
import appeng.api.implementations.items.MemoryCardMessages;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.parts.PartItemStack;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.lang.ref.WeakReference;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.visnet.TileVisNode;
import thaumcraft.api.visnet.VisNetHandler;
import thaumcraft.common.tiles.TileVisRelay;
import thaumicenergistics.integration.tc.DigiVisSourceData;
import thaumicenergistics.integration.tc.IDigiVisSource;
import thaumicenergistics.integration.tc.VisProviderProxy;
import thaumicenergistics.parts.AbstractAEPartBase;
import thaumicenergistics.registries.AEPartsEnum;
import thaumicenergistics.texture.BlockTextureManager;

public class AEPartVisInterface
extends AbstractAEPartBase
implements IGridTickable,
IDigiVisSource {
    private static final String NBT_KEY_UID = "uid";
    private static final String NBT_KEY_IS_PROVIDER = "isProvider";
    private static final String NBT_KEY_PROVIDER_SOURCE = "linkedSource";
    private static final int TIME_TO_CLEAR = 500;
    private static final int POWER_PER_REQUESTED_VIS = 4;
    private long UID = 0L;
    private int visDrainingColor = 0;
    private long lastColorUpdate = 0L;
    private WeakReference<TileVisRelay> cachedRelay = new WeakReference<Object>(null);
    private boolean isProvider = false;
    private DigiVisSourceData visP2PSourceInfo = new DigiVisSourceData();
    private VisProviderProxy visProviderSubTile = null;

    public AEPartVisInterface() {
        super(AEPartsEnum.VisInterface);
        this.UID = System.currentTimeMillis() ^ (long)this.hashCode();
    }

    private int consumeVisFromVisNetwork(Aspect digiVisAspect, int amount) {
        TileVisRelay visRelay = this.getRelay();
        if (visRelay == null) {
            return 0;
        }
        IEnergyGrid eGrid = this.getGridBlock().getEnergyGrid();
        if (eGrid == null) {
            return 0;
        }
        double drainedPower = eGrid.extractAEPower(4.0, Actionable.SIMULATE, PowerMultiplier.CONFIG);
        if (drainedPower < 4.0) {
            return 0;
        }
        int amountReceived = visRelay.consumeVis(digiVisAspect, amount);
        if (amountReceived > 0) {
            eGrid.extractAEPower(4.0, Actionable.MODULATE, PowerMultiplier.CONFIG);
        }
        return amountReceived;
    }

    private boolean isP2PSourceValid() {
        if (!this.visP2PSourceInfo.hasSourceData()) {
            return false;
        }
        IDigiVisSource p2pSource = this.visP2PSourceInfo.tryGetSource(this.getGrid());
        if (p2pSource == null) {
            return false;
        }
        if (!(p2pSource instanceof AEPartVisInterface)) {
            return false;
        }
        if (this.equals(p2pSource)) {
            return false;
        }
        return ((AEPartVisInterface)p2pSource).isVisProvider() == false;
    }

    private void setDrainColor(int color) {
        if (color != 0) {
            if (color == this.visDrainingColor) {
                this.lastColorUpdate = System.currentTimeMillis();
                return;
            }
            if (System.currentTimeMillis() - this.lastColorUpdate <= 250L) {
                return;
            }
            this.lastColorUpdate = System.currentTimeMillis();
        }
        this.visDrainingColor = color;
        this.markForUpdate();
    }

    private void setIsVisProvider(boolean isProviding) {
        if (!isProviding) {
            this.visP2PSourceInfo.clearData();
            if (this.visProviderSubTile != null) {
                this.visProviderSubTile.func_145843_s();
                this.visProviderSubTile = null;
            }
        }
        this.isProvider = isProviding;
    }

    @Override
    public int cableConnectionRenderTo() {
        return 2;
    }

    @Override
    public int consumeVis(Aspect digiVisAspect, int amount) {
        if (!this.isActive()) {
            return 0;
        }
        int amountReceived = 0;
        if (this.isProvider) {
            if (this.isP2PSourceValid()) {
                IDigiVisSource source = this.visP2PSourceInfo.tryGetSource(this.getGrid());
                amountReceived = source.consumeVis(digiVisAspect, amount);
            }
        } else {
            amountReceived = this.consumeVisFromVisNetwork(digiVisAspect, amount);
        }
        if (amountReceived > 0) {
            this.setDrainColor(digiVisAspect.getColor());
        }
        return amountReceived;
    }

    @Override
    public void getBoxes(IPartCollisionHelper helper) {
        helper.addBox(6.0, 6.0, 15.0, 10.0, 10.0, 16.0);
        helper.addBox(4.0, 4.0, 14.0, 12.0, 12.0, 15.0);
        helper.addBox(5.0, 5.0, 13.0, 11.0, 11.0, 14.0);
    }

    @Override
    public IIcon getBreakingTexture() {
        return BlockTextureManager.VIS_RELAY_INTERFACE.getTextures()[0];
    }

    @Override
    public IGrid getGrid() {
        if (this.getGridBlock() == null) {
            return null;
        }
        return this.getGridBlock().getGrid();
    }

    @Override
    public double getIdlePowerUsage() {
        return 0.0;
    }

    @Override
    public int getLightLevel() {
        return 8;
    }

    public TileVisRelay getRelay() {
        TileVisRelay tVR = (TileVisRelay)this.cachedRelay.get();
        if (tVR != null && tVR == this.getHostTile().func_145831_w().func_147438_o(tVR.field_145851_c, tVR.field_145848_d, tVR.field_145849_e)) {
            return tVR;
        }
        TileEntity facingTile = this.getFacingTile();
        if (facingTile instanceof TileVisRelay) {
            tVR = (TileVisRelay)facingTile;
            if (tVR.orientation == this.getSide().ordinal()) {
                this.cachedRelay = new WeakReference<TileVisRelay>(tVR);
                return tVR;
            }
        }
        return null;
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(30, 30, false, false);
    }

    @Override
    public long getUID() {
        return this.UID;
    }

    @Override
    public boolean isActive() {
        return super.isActive();
    }

    public Boolean isVisProvider() {
        return this.isProvider;
    }

    @Override
    public boolean onActivate(EntityPlayer player, Vec3 position) {
        ItemStack playerHolding = player.field_71071_by.func_70448_g();
        if (playerHolding != null && playerHolding.func_77973_b() instanceof IMemoryCard) {
            IMemoryCard memoryCard = (IMemoryCard)playerHolding.func_77973_b();
            String settingsName = memoryCard.getSettingsName(playerHolding);
            if (settingsName.equals(DigiVisSourceData.SOURCE_UNLOC_NAME)) {
                NBTTagCompound data = memoryCard.getData(playerHolding);
                this.visP2PSourceInfo.readFromNBT(data);
                if (this.visP2PSourceInfo.hasSourceData()) {
                    if (!this.isP2PSourceValid()) {
                        memoryCard.notifyUser(player, MemoryCardMessages.INVALID_MACHINE);
                        this.visP2PSourceInfo.clearData();
                    } else {
                        this.setIsVisProvider(true);
                        memoryCard.notifyUser(player, MemoryCardMessages.SETTINGS_LOADED);
                    }
                }
                this.markForSave();
            } else if (settingsName.equals("gui.appliedenergistics2.Blank") && this.isProvider) {
                this.setIsVisProvider(false);
                memoryCard.notifyUser(player, MemoryCardMessages.SETTINGS_CLEARED);
                this.markForSave();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onShiftActivate(EntityPlayer player, Vec3 position) {
        ItemStack playerHolding = player.field_71071_by.func_70448_g();
        if (playerHolding != null && playerHolding.func_77973_b() instanceof IMemoryCard) {
            IMemoryCard memoryCard = (IMemoryCard)playerHolding.func_77973_b();
            DigiVisSourceData data = new DigiVisSourceData(this);
            memoryCard.setMemoryCardContents(playerHolding, DigiVisSourceData.SOURCE_UNLOC_NAME, data.writeToNBT());
            memoryCard.notifyUser(player, MemoryCardMessages.SETTINGS_SAVED);
            this.setIsVisProvider(false);
            this.markForSave();
            return true;
        }
        return false;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.func_74764_b(NBT_KEY_UID)) {
            this.UID = data.func_74763_f(NBT_KEY_UID);
        }
        if (data.func_74764_b(NBT_KEY_IS_PROVIDER)) {
            this.isProvider = data.func_74767_n(NBT_KEY_IS_PROVIDER);
            if (data.func_74764_b(NBT_KEY_PROVIDER_SOURCE)) {
                this.visP2PSourceInfo.readFromNBT(data, NBT_KEY_PROVIDER_SOURCE);
            }
        }
    }

    @Override
    public boolean readFromStream(ByteBuf data) throws IOException {
        boolean redraw = false;
        redraw |= super.readFromStream(data);
        int oldColor = this.visDrainingColor;
        this.visDrainingColor = data.readInt();
        return redraw |= this.visDrainingColor != oldColor;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper helper, RenderBlocks renderer) {
        IIcon side = BlockTextureManager.VIS_RELAY_INTERFACE.getTextures()[2];
        helper.setTexture(side, side, side, BlockTextureManager.VIS_RELAY_INTERFACE.getTexture(), side, side);
        helper.setBounds(6.0f, 6.0f, 15.0f, 10.0f, 10.0f, 16.0f);
        helper.renderInventoryBox(renderer);
        helper.setBounds(4.0f, 4.0f, 14.0f, 12.0f, 12.0f, 15.0f);
        helper.renderInventoryBox(renderer);
        helper.setBounds(5.0f, 5.0f, 13.0f, 11.0f, 11.0f, 14.0f);
        this.renderInventoryBusLights(helper, renderer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper helper, RenderBlocks renderer) {
        Tessellator tessellator = Tessellator.field_78398_a;
        IIcon side = BlockTextureManager.VIS_RELAY_INTERFACE.getTextures()[2];
        helper.setTexture(side, side, side, BlockTextureManager.VIS_RELAY_INTERFACE.getTexture(), side, side);
        helper.setBounds(6.0f, 6.0f, 15.0f, 10.0f, 10.0f, 16.0f);
        helper.renderBlock(x, y, z, renderer);
        helper.setBounds(4.0f, 4.0f, 14.0f, 12.0f, 12.0f, 15.0f);
        helper.renderBlock(x, y, z, renderer);
        if (this.visDrainingColor != 0) {
            tessellator.func_78378_d(this.visDrainingColor);
            helper.renderFace(x, y, z, BlockTextureManager.VIS_RELAY_INTERFACE.getTextures()[1], ForgeDirection.SOUTH, renderer);
        }
        helper.setBounds(5.0f, 5.0f, 13.0f, 11.0f, 11.0f, 14.0f);
        this.renderStaticBusLights(x, y, z, helper, renderer);
    }

    public TickRateModulation tickingRequest(IGridNode node, int TicksSinceLastCall) {
        if (this.visDrainingColor != 0 && System.currentTimeMillis() - this.lastColorUpdate > 500L) {
            this.setDrainColor(0);
        }
        if (this.isProvider) {
            boolean hasProvider;
            boolean bl = hasProvider = this.visProviderSubTile != null;
            if (!this.isP2PSourceValid()) {
                if (hasProvider) {
                    this.visProviderSubTile.func_145843_s();
                    this.visProviderSubTile = null;
                }
            } else {
                boolean hasRelay;
                boolean bl2 = hasRelay = this.getRelay() != null;
                if (!hasRelay && hasProvider) {
                    this.visProviderSubTile.func_145843_s();
                    this.visProviderSubTile = null;
                } else if (hasRelay && !hasProvider) {
                    this.visProviderSubTile = new VisProviderProxy(this);
                    VisNetHandler.addSource((World)this.getHostTile().func_145831_w(), (TileVisNode)this.visProviderSubTile);
                } else if (hasProvider) {
                    this.visProviderSubTile.func_145845_h();
                }
            }
        }
        return TickRateModulation.SAME;
    }

    @Override
    public void writeToNBT(NBTTagCompound data, PartItemStack saveType) {
        super.writeToNBT(data, saveType);
        if (saveType == PartItemStack.Wrench) {
            return;
        }
        data.func_74772_a(NBT_KEY_UID, this.UID);
        if (this.isProvider) {
            data.func_74757_a(NBT_KEY_IS_PROVIDER, this.isProvider);
            this.visP2PSourceInfo.writeToNBT(data, NBT_KEY_PROVIDER_SOURCE);
        }
    }

    @Override
    public void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
        data.writeInt(this.visDrainingColor);
    }
}

