/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.parts;

import appeng.api.AEApi;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.implementations.parts.IPartStorageMonitor;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.parts.PartItemStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalCoord;
import appeng.client.texture.CableBusTextures;
import appeng.core.localization.PlayerMessages;
import appeng.util.Platform;
import appeng.util.ReadableNumberConverter;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.awt.Color;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.aspect.AspectStack;
import thaumicenergistics.grid.IEssentiaWatcher;
import thaumicenergistics.grid.IEssentiaWatcherHost;
import thaumicenergistics.grid.IMEEssentiaMonitor;
import thaumicenergistics.integration.tc.EssentiaItemContainerHelper;
import thaumicenergistics.parts.AbstractAEPartBase;
import thaumicenergistics.registries.AEPartsEnum;
import thaumicenergistics.texture.BlockTextureManager;
import thaumicenergistics.util.EffectiveSide;

public class AEPartEssentiaStorageMonitor
extends AbstractAEPartBase
implements IPartStorageMonitor,
IEssentiaWatcherHost,
IPowerChannelState {
    private static final double IDLE_DRAIN = 0.0625;
    private static final String NBT_KEY_LOCKED = "Locked";
    private static final String NBT_KEY_TRACKED_ASPECT = "TrackedAspect";
    private IEssentiaWatcher essentiaWatcher;
    private boolean monitorLocked = false;
    protected final TrackingInformation trackedEssentia = new TrackingInformation();
    private boolean updateDisplayList = false;
    private Integer cachedDisplayList = null;
    CableBusTextures darkCornerTexture;
    CableBusTextures lightCornerTexture = CableBusTextures.PartConversionMonitor_Colored;

    protected AEPartEssentiaStorageMonitor(AEPartsEnum subPart) {
        super(subPart);
        this.darkCornerTexture = CableBusTextures.PartConversionMonitor_Dark;
    }

    public AEPartEssentiaStorageMonitor() {
        this(AEPartsEnum.EssentiaStorageMonitor);
    }

    private void configureWatcher() {
        if (this.essentiaWatcher != null) {
            this.essentiaWatcher.clear();
            if (this.trackedEssentia.isValid()) {
                this.essentiaWatcher.add(this.trackedEssentia.getAspectStack().aspect);
                IMEEssentiaMonitor essMon = this.getGridBlock().getEssentiaMonitor();
                if (essMon != null) {
                    this.updateTrackedEssentiaAmount(essMon);
                }
            }
        }
    }

    private boolean didActivateChangeLockState(EntityPlayer player, ItemStack heldItem) {
        TileEntity hte = this.getHostTile();
        if (!player.func_70093_af() && Platform.isWrench((EntityPlayer)player, (ItemStack)heldItem, (int)hte.field_145851_c, (int)hte.field_145848_d, (int)hte.field_145849_e)) {
            boolean bl = this.monitorLocked = !this.monitorLocked;
            if (this.monitorLocked) {
                player.func_145747_a(PlayerMessages.isNowLocked.get());
            } else {
                player.func_145747_a(PlayerMessages.isNowUnlocked.get());
            }
            this.markForUpdate();
            this.markForSave();
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    private void renderAspect(Tessellator tessellator, Aspect aspect) {
        Color aspectColor = new Color(aspect.getColor());
        GL11.glDisable((int)2896);
        GL11.glAlphaFunc((int)516, (float)0.004f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)((float)aspectColor.getRed() / 255.0f), (float)((float)aspectColor.getGreen() / 255.0f), (float)((float)aspectColor.getBlue() / 255.0f), (float)0.9f);
        tessellator.func_78369_a((float)aspectColor.getRed() / 255.0f, (float)aspectColor.getGreen() / 255.0f, (float)aspectColor.getBlue() / 255.0f, 0.9f);
        GL11.glTranslated((double)-0.2, (double)-0.25, (double)0.0);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(aspect.getImage());
        double size = 0.38;
        double zDepth = -0.265;
        tessellator.func_78382_b();
        tessellator.func_78374_a(0.0, size, zDepth, 0.0, 1.0);
        tessellator.func_78374_a(size, size, zDepth, 1.0, 1.0);
        tessellator.func_78374_a(size, 0.0, zDepth, 1.0, 0.0);
        tessellator.func_78374_a(0.0, 0.0, zDepth, 0.0, 0.0);
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2896);
    }

    @SideOnly(value=Side.CLIENT)
    private void renderScreen(Tessellator tessellator, AspectStack aspectStack) {
        ForgeDirection side = this.getSide();
        GL11.glTranslated((double)((double)side.offsetX * 0.77), (double)((double)side.offsetY * 0.77), (double)((double)side.offsetZ * 0.77));
        switch (side) {
            case DOWN: {
                GL11.glScalef((float)1.0f, (float)-1.0f, (float)1.0f);
                GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case EAST: {
                GL11.glScalef((float)-1.0f, (float)-1.0f, (float)-1.0f);
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case NORTH: {
                GL11.glScalef((float)-1.0f, (float)-1.0f, (float)-1.0f);
                break;
            }
            case SOUTH: {
                GL11.glScalef((float)-1.0f, (float)-1.0f, (float)-1.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case UP: {
                GL11.glScalef((float)1.0f, (float)-1.0f, (float)1.0f);
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GL11.glScalef((float)-1.0f, (float)-1.0f, (float)-1.0f);
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
        }
        try {
            int brightness = 0x1000100;
            int brightnessComponent1 = brightness % 65536;
            int brightnessComponent2 = brightness / 65536;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)brightnessComponent1 * 0.8f), (float)((float)brightnessComponent2 * 0.8f));
            this.renderAspect(tessellator, aspectStack.aspect);
        }
        catch (Exception brightness) {
            // empty catch block
        }
        GL11.glTranslatef((float)0.2f, (float)0.4f, (float)-0.25f);
        GL11.glScalef((float)0.016129032f, (float)0.016129032f, (float)0.016129032f);
        String renderedStackSize = ReadableNumberConverter.INSTANCE.toWideReadableForm(aspectStack.stackSize);
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        GL11.glTranslatef((float)(-0.5f * (float)fr.func_78256_a(renderedStackSize)), (float)0.0f, (float)-1.0f);
        fr.func_78276_b(renderedStackSize, 0, 0, 0);
    }

    private void updateTrackedEssentiaAmount(IMEEssentiaMonitor essMonitor) {
        if (!this.trackedEssentia.isValid()) {
            return;
        }
        this.trackedEssentia.updateTrackedAmount(0L);
        long stored = essMonitor.getEssentiaAmount(this.trackedEssentia.getAspectStack().aspect);
        if (stored > 0L) {
            this.trackedEssentia.updateTrackedAmount(stored);
        }
    }

    protected boolean activationCheck(EntityPlayer player) {
        if (player instanceof FakePlayer) {
            return false;
        }
        if (!this.isActive()) {
            return false;
        }
        return Platform.hasPermissions((DimensionalCoord)this.getLocation(), (EntityPlayer)player);
    }

    @SideOnly(value=Side.CLIENT)
    protected void finalize() throws Throwable {
        super.finalize();
        if (this.cachedDisplayList != null) {
            GLAllocation.func_74523_b((int)this.cachedDisplayList);
        }
    }

    protected boolean onActivatedWithEmptyHand() {
        if (this.monitorLocked) {
            return false;
        }
        this.trackedEssentia.setTracked(null);
        this.configureWatcher();
        this.markForUpdate();
        this.markForSave();
        return true;
    }

    protected boolean onActivateWithAspectItem(EntityPlayer player, ItemStack heldItem, EssentiaItemContainerHelper.AspectItemType itemType) {
        if (this.monitorLocked) {
            return false;
        }
        Aspect heldAspect = EssentiaItemContainerHelper.INSTANCE.getFilterAspectFromItem(heldItem);
        if (heldAspect == null) {
            return this.onActivatedWithEmptyHand();
        }
        this.trackedEssentia.setTracked(new AspectStack(heldAspect, 0L));
        this.configureWatcher();
        this.markForUpdate();
        this.markForSave();
        return true;
    }

    @Override
    public int cableConnectionRenderTo() {
        return 3;
    }

    @Override
    public void getBoxes(IPartCollisionHelper helper) {
        helper.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        helper.addBox(5.0, 5.0, 13.0, 11.0, 11.0, 14.0);
    }

    @Override
    public IIcon getBreakingTexture() {
        return BlockTextureManager.ARCANE_CRAFTING_TERMINAL.getTextures()[3];
    }

    public IAEStack<?> getDisplayed() {
        if (this.trackedEssentia.isValid()) {
            return this.trackedEssentia.getItemStack();
        }
        return null;
    }

    @Override
    public double getIdlePowerUsage() {
        return 0.0625;
    }

    @Override
    public int getLightLevel() {
        return this.isActive() ? 9 : 0;
    }

    public boolean isLocked() {
        return this.monitorLocked;
    }

    public boolean isPowered() {
        return this.isActive();
    }

    @Override
    public boolean onActivate(EntityPlayer player, Vec3 position) {
        if (EffectiveSide.isClientSide()) {
            return true;
        }
        if (!this.activationCheck(player)) {
            return false;
        }
        ItemStack heldItem = player.func_71045_bC();
        if (this.didActivateChangeLockState(player, heldItem)) {
            return true;
        }
        if (heldItem == null) {
            return this.onActivatedWithEmptyHand();
        }
        EssentiaItemContainerHelper.AspectItemType itemType = EssentiaItemContainerHelper.INSTANCE.getItemType(heldItem);
        if (itemType != EssentiaItemContainerHelper.AspectItemType.Invalid) {
            return this.onActivateWithAspectItem(player, heldItem, itemType);
        }
        return false;
    }

    @Override
    public void onEssentiaChange(Aspect aspect, long storedAmount, long changeAmount) {
        if (!this.trackedEssentia.isValid()) {
            return;
        }
        this.trackedEssentia.updateTrackedAmount(storedAmount);
        this.markForUpdate();
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.func_74764_b(NBT_KEY_LOCKED)) {
            this.monitorLocked = data.func_74767_n(NBT_KEY_LOCKED);
        }
        if (data.func_74764_b(NBT_KEY_TRACKED_ASPECT)) {
            Aspect trackedAspect = Aspect.getAspect((String)data.func_74779_i(NBT_KEY_TRACKED_ASPECT));
            this.trackedEssentia.setTracked(new AspectStack(trackedAspect, 0L));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean readFromStream(ByteBuf stream) throws IOException {
        boolean redraw = false;
        redraw |= super.readFromStream(stream);
        this.monitorLocked = stream.readBoolean();
        if (stream.readBoolean()) {
            AspectStack as = AspectStack.loadAspectStackFromNBT(ByteBufUtils.readTag((ByteBuf)stream));
            this.trackedEssentia.setTracked(as);
            this.updateDisplayList = true;
            redraw |= true;
        } else {
            this.trackedEssentia.setTracked(null);
            this.updateDisplayList = true;
            redraw |= true;
        }
        return redraw;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(double x, double y, double z, IPartRenderHelper helper, RenderBlocks renderer) {
        if (!this.isActive() || !this.trackedEssentia.isValid()) {
            return;
        }
        if (this.cachedDisplayList == null) {
            this.cachedDisplayList = GLAllocation.func_74526_a((int)1);
            this.updateDisplayList = true;
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        if (this.updateDisplayList) {
            this.updateDisplayList = false;
            GL11.glNewList((int)this.cachedDisplayList, (int)4865);
            this.renderScreen(Tessellator.field_78398_a, this.trackedEssentia.getAspectStack());
            GL11.glEndList();
        } else {
            GL11.glCallList((int)this.cachedDisplayList);
        }
        GL11.glPopMatrix();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper helper, RenderBlocks renderer) {
        IIcon side = BlockTextureManager.ARCANE_CRAFTING_TERMINAL.getTextures()[3];
        helper.setTexture(side, side, side, side, side, side);
        helper.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        helper.renderInventoryBox(renderer);
        helper.setBounds(2.0f, 2.0f, 15.0f, 14.0f, 14.0f, 16.0f);
        helper.setInvColor(AEColor.Transparent.blackVariant);
        helper.renderInventoryFace(this.darkCornerTexture.getIcon(), ForgeDirection.SOUTH, renderer);
        helper.setInvColor(AEColor.Transparent.mediumVariant);
        helper.renderInventoryFace(this.lightCornerTexture.getIcon(), ForgeDirection.SOUTH, renderer);
        helper.setInvColor(AEColor.Transparent.whiteVariant);
        helper.renderInventoryFace(CableBusTextures.PartConversionMonitor_Bright.getIcon(), ForgeDirection.SOUTH, renderer);
        helper.setInvColor(AEColor.Black.blackVariant);
        helper.renderInventoryFace(BlockTextureManager.ESSENTIA_TERMINAL.getTextures()[0], ForgeDirection.SOUTH, renderer);
        helper.setBounds(5.0f, 5.0f, 13.0f, 11.0f, 11.0f, 14.0f);
        this.renderInventoryBusLights(helper, renderer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper helper, RenderBlocks renderer) {
        Tessellator tessellator = Tessellator.field_78398_a;
        IIcon side = BlockTextureManager.ARCANE_CRAFTING_TERMINAL.getTextures()[3];
        helper.setTexture(side, side, side, side, side, side);
        helper.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        helper.renderBlock(x, y, z, renderer);
        if (this.isActive()) {
            Tessellator.field_78398_a.func_78380_c(0xD000D0);
        }
        tessellator.func_78378_d(this.getHost().getColor().blackVariant);
        helper.renderFace(x, y, z, this.darkCornerTexture.getIcon(), ForgeDirection.SOUTH, renderer);
        tessellator.func_78378_d(this.getHost().getColor().mediumVariant);
        helper.renderFace(x, y, z, this.lightCornerTexture.getIcon(), ForgeDirection.SOUTH, renderer);
        tessellator.func_78378_d(this.getHost().getColor().whiteVariant);
        helper.renderFace(x, y, z, CableBusTextures.PartConversionMonitor_Bright.getIcon(), ForgeDirection.SOUTH, renderer);
        if (!this.trackedEssentia.isValid()) {
            tessellator.func_78378_d(this.getHost().getColor().mediumVariant);
            helper.renderFace(x, y, z, BlockTextureManager.ESSENTIA_TERMINAL.getTextures()[0], ForgeDirection.SOUTH, renderer);
        }
        helper.setBounds(5.0f, 5.0f, 13.0f, 11.0f, 11.0f, 14.0f);
        this.renderStaticBusLights(x, y, z, helper, renderer);
    }

    @Override
    public boolean requireDynamicRender() {
        return true;
    }

    public boolean showNetworkInfo(MovingObjectPosition where) {
        return false;
    }

    @Override
    public void updateWatcher(IEssentiaWatcher newWatcher) {
        this.essentiaWatcher = newWatcher;
        this.configureWatcher();
    }

    @Override
    public void writeToNBT(NBTTagCompound data, PartItemStack saveType) {
        super.writeToNBT(data, saveType);
        if (this.monitorLocked) {
            data.func_74757_a(NBT_KEY_LOCKED, this.monitorLocked);
        }
        if (this.trackedEssentia.isValid()) {
            data.func_74778_a(NBT_KEY_TRACKED_ASPECT, this.trackedEssentia.getAspectStack().getTag());
        }
    }

    @Override
    public void writeToStream(ByteBuf stream) throws IOException {
        super.writeToStream(stream);
        stream.writeBoolean(this.monitorLocked);
        stream.writeBoolean(this.trackedEssentia.isValid());
        if (this.trackedEssentia.isValid()) {
            ByteBufUtils.writeTag((ByteBuf)stream, (NBTTagCompound)this.trackedEssentia.getAspectStack().writeToNBT(new NBTTagCompound()));
        }
    }

    protected class TrackingInformation {
        private IAEItemStack asItemStack;
        private AspectStack asAspectStack;

        public TrackingInformation() {
            ItemStack is = new ItemStack(new Item(){

                public String func_77653_i(ItemStack ignored_) {
                    return this.func_77658_a();
                }

                public String func_77658_a() {
                    return TrackingInformation.this.getAspectStack().getAspectName();
                }

                public String func_77667_c(ItemStack ignored) {
                    return this.func_77658_a();
                }
            });
            this.asItemStack = AEApi.instance().storage().createItemStack(is);
        }

        public AspectStack getAspectStack() {
            return this.asAspectStack;
        }

        public IAEItemStack getItemStack() {
            return this.asItemStack;
        }

        public boolean isValid() {
            return this.asAspectStack != null;
        }

        public void setTracked(AspectStack as) {
            this.asAspectStack = as != null ? as : null;
        }

        public void updateTrackedAmount(long aspectAmount) {
            if (this.isValid()) {
                this.asAspectStack.stackSize = aspectAmount;
            }
        }
    }
}

