/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.network.packet.server;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import thaumicenergistics.network.packet.AbstractPacket;
import thaumicenergistics.network.packet.AbstractServerPacket;
import thaumicenergistics.parts.AEPartEssentiaLevelEmitter;

public class PacketServerEssentiaEmitter
extends AbstractServerPacket {
    private static final byte MODE_REQUEST_UPDATE = 0;
    private static final byte MODE_SEND_WANTED = 1;
    private static final byte MODE_ADJUST_WANTED = 2;
    private static final byte MODE_TOGGLE_REDSTONE = 3;
    private AEPartEssentiaLevelEmitter part;
    private long wantedAmount;
    private int adjustmentAmount;

    public PacketServerEssentiaEmitter createRedstoneModeToggle(AEPartEssentiaLevelEmitter part, EntityPlayer player) {
        this.player = player;
        this.mode = (byte)3;
        this.part = part;
        return this;
    }

    public PacketServerEssentiaEmitter createUpdateRequest(AEPartEssentiaLevelEmitter part, EntityPlayer player) {
        this.player = player;
        this.mode = 0;
        this.part = part;
        return this;
    }

    public PacketServerEssentiaEmitter createWantedAmountAdjustment(int adjustmentAmount, AEPartEssentiaLevelEmitter part, EntityPlayer player) {
        this.player = player;
        this.mode = (byte)2;
        this.part = part;
        this.adjustmentAmount = adjustmentAmount;
        return this;
    }

    public PacketServerEssentiaEmitter createWantedAmountUpdate(long wantedAmount, AEPartEssentiaLevelEmitter part, EntityPlayer player) {
        this.player = player;
        this.mode = 1;
        this.part = part;
        this.wantedAmount = wantedAmount;
        return this;
    }

    @Override
    public void execute() {
        switch (this.mode) {
            case 0: {
                this.part.onClientUpdateRequest(this.player);
                break;
            }
            case 1: {
                this.part.onClientSetWantedAmount(this.wantedAmount, this.player);
                break;
            }
            case 2: {
                this.part.onClientAdjustWantedAmount(this.adjustmentAmount, this.player);
                break;
            }
            case 3: {
                this.part.onClientToggleRedstoneMode(this.player);
            }
        }
    }

    @Override
    public void readData(ByteBuf stream) {
        switch (this.mode) {
            case 0: {
                this.part = (AEPartEssentiaLevelEmitter)AbstractPacket.readPart(stream);
                break;
            }
            case 1: {
                this.part = (AEPartEssentiaLevelEmitter)AbstractPacket.readPart(stream);
                this.wantedAmount = stream.readLong();
                break;
            }
            case 2: {
                this.part = (AEPartEssentiaLevelEmitter)AbstractPacket.readPart(stream);
                this.adjustmentAmount = stream.readInt();
                break;
            }
            case 3: {
                this.part = (AEPartEssentiaLevelEmitter)AbstractPacket.readPart(stream);
            }
        }
    }

    @Override
    public void writeData(ByteBuf stream) {
        switch (this.mode) {
            case 0: {
                AbstractPacket.writePart(this.part, stream);
                break;
            }
            case 1: {
                AbstractPacket.writePart(this.part, stream);
                stream.writeLong(this.wantedAmount);
                break;
            }
            case 2: {
                AbstractPacket.writePart(this.part, stream);
                stream.writeInt(this.adjustmentAmount);
                break;
            }
            case 3: {
                AbstractPacket.writePart(this.part, stream);
            }
        }
    }
}

