/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.network.packet.client;

import appeng.api.config.RedstoneMode;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import thaumicenergistics.gui.GuiEssentiaIO;
import thaumicenergistics.network.packet.AbstractClientPacket;
import thaumicenergistics.registries.EnumCache;

public class PacketClientEssentiaIOBus
extends AbstractClientPacket {
    private static final byte MODE_SET_REDSTONE_CONTROLLED = 0;
    private static final byte MODE_SET_REDSTONE_MODE = 1;
    private static final byte MODE_SET_FILTER_SIZE = 2;
    private static final byte MODE_SEND_FULL_UPDATE = 3;
    private static final byte MODE_SEND_VOID_MODE = 4;
    private RedstoneMode redstoneMode;
    private byte filterSize;
    private boolean redstoneControlled;
    private boolean isVoidAllowed;

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void wrappedExecute() {
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        if (!(gui instanceof GuiEssentiaIO)) {
            return;
        }
        switch (this.mode) {
            case 0: {
                ((GuiEssentiaIO)gui).onReceiveRedstoneControlled(this.redstoneControlled);
                break;
            }
            case 1: {
                ((GuiEssentiaIO)gui).onReceiveRedstoneMode(this.redstoneMode);
                break;
            }
            case 2: {
                ((GuiEssentiaIO)gui).onReceiveFilterSize(this.filterSize);
                break;
            }
            case 3: {
                ((GuiEssentiaIO)gui).onReceiveRedstoneMode(this.redstoneMode);
                ((GuiEssentiaIO)gui).onReceiveRedstoneControlled(this.redstoneControlled);
                ((GuiEssentiaIO)gui).onReceiveFilterSize(this.filterSize);
                break;
            }
            case 4: {
                ((GuiEssentiaIO)gui).onServerSendVoidMode(this.isVoidAllowed);
            }
        }
    }

    public PacketClientEssentiaIOBus createFullUpdate(EntityPlayer player, RedstoneMode redstoneMode, byte filterSize, boolean redstoneControlled) {
        this.player = player;
        this.mode = (byte)3;
        this.redstoneMode = redstoneMode;
        this.filterSize = filterSize;
        this.redstoneControlled = redstoneControlled;
        return this;
    }

    public PacketClientEssentiaIOBus createSetFilterSize(EntityPlayer player, byte filterSize) {
        this.player = player;
        this.mode = (byte)2;
        this.filterSize = filterSize;
        return this;
    }

    public PacketClientEssentiaIOBus createSetRedstoneControlled(EntityPlayer player, boolean redstoneControlled) {
        this.player = player;
        this.mode = 0;
        this.redstoneControlled = redstoneControlled;
        return this;
    }

    public PacketClientEssentiaIOBus createSetRedstoneMode(EntityPlayer player, RedstoneMode redstoneMode) {
        this.player = player;
        this.mode = 1;
        this.redstoneMode = redstoneMode;
        return this;
    }

    public PacketClientEssentiaIOBus createVoidModeUpdate(EntityPlayer player, boolean isVoidAllowed) {
        this.player = player;
        this.mode = (byte)4;
        this.isVoidAllowed = isVoidAllowed;
        return this;
    }

    @Override
    public void readData(ByteBuf stream) {
        switch (this.mode) {
            case 0: {
                this.redstoneControlled = stream.readBoolean();
                break;
            }
            case 1: {
                this.redstoneMode = EnumCache.AE_REDSTONE_MODES[stream.readByte()];
                break;
            }
            case 2: {
                this.filterSize = stream.readByte();
                break;
            }
            case 3: {
                this.redstoneControlled = stream.readBoolean();
                this.redstoneMode = EnumCache.AE_REDSTONE_MODES[stream.readByte()];
                this.filterSize = stream.readByte();
                break;
            }
            case 4: {
                this.isVoidAllowed = stream.readBoolean();
            }
        }
    }

    @Override
    public void writeData(ByteBuf stream) {
        switch (this.mode) {
            case 0: {
                stream.writeBoolean(this.redstoneControlled);
                break;
            }
            case 1: {
                stream.writeByte((int)((byte)this.redstoneMode.ordinal()));
                break;
            }
            case 2: {
                stream.writeByte((int)this.filterSize);
                break;
            }
            case 3: {
                stream.writeBoolean(this.redstoneControlled);
                stream.writeByte((int)((byte)this.redstoneMode.ordinal()));
                stream.writeByte((int)this.filterSize);
                break;
            }
            case 4: {
                stream.writeBoolean(this.isVoidAllowed);
            }
        }
    }
}

