/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.integration.tc;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.common.tiles.TileMagicWorkbench;

public class ArcaneRecipeHelper {
    public static final ArcaneRecipeHelper INSTANCE = new ArcaneRecipeHelper();

    private ArcaneRecipeHelper() {
    }

    private TileMagicWorkbench createBridgeInventory(IInventory sourceInventory, int firstSlotIndex, int gridSize) {
        TileMagicWorkbench workbenchTile = new TileMagicWorkbench();
        for (int slotIndex = 0; slotIndex < gridSize; ++slotIndex) {
            workbenchTile.setInventorySlotContentsSoftly(slotIndex, sourceInventory.func_70301_a(slotIndex + firstSlotIndex));
        }
        return workbenchTile;
    }

    public IArcaneRecipe findMatchingArcaneResult(IInventory sourceInventory, int firstSlotIndex, int gridSize, EntityPlayer player) {
        TileMagicWorkbench workbenchTile = this.createBridgeInventory(sourceInventory, firstSlotIndex, gridSize);
        IArcaneRecipe arcaneRecipe = null;
        for (Object currentRecipe : ThaumcraftApi.getCraftingRecipes()) {
            if (!(currentRecipe instanceof IArcaneRecipe) || !((IArcaneRecipe)currentRecipe).matches((IInventory)workbenchTile, player.field_70170_p, player)) continue;
            arcaneRecipe = (IArcaneRecipe)currentRecipe;
            break;
        }
        return arcaneRecipe;
    }

    public AspectList getRecipeAspectCost(IInventory sourceInventory, int firstSlotIndex, int gridSize, IArcaneRecipe recipe) {
        if (recipe == null) {
            return null;
        }
        return recipe.getAspects((IInventory)this.createBridgeInventory(sourceInventory, firstSlotIndex, gridSize));
    }

    public ItemStack getRecipeOutput(IInventory sourceInventory, int firstSlotIndex, int gridSize, IArcaneRecipe recipe) {
        if (recipe == null) {
            return null;
        }
        return recipe.getCraftingResult((IInventory)this.createBridgeInventory(sourceInventory, firstSlotIndex, gridSize));
    }
}

